/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoSetImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.StringInterner;

public class DiskManagerUtil {
    private static final LogIDs LOGID = LogIDs.DISK;
    protected static int max_read_block_size;
    private static AEMonitor cache_read_mon;

    public static boolean checkBlockConsistencyForHint(DiskManager dm, String originator, int pieceNumber, int offset, int length) {
        if (length <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " length=" + length + " <= 0"));
            }
            return false;
        }
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= dm.getNbPieces()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + dm.getNbPieces()));
            }
            return false;
        }
        int pLength = dm.getPieceLength(pieceNumber);
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " > pLength=" + pLength));
            }
            return false;
        }
        if (offset + length > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " + length=" + length + " > pLength=" + pLength));
            }
            return false;
        }
        return true;
    }

    public static boolean checkBlockConsistencyForRead(DiskManager dm, String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        if (!DiskManagerUtil.checkBlockConsistencyForHint(dm, originator, pieceNumber, offset, length)) {
            return false;
        }
        if (length > max_read_block_size && peer_request) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " length=" + length + " > " + max_read_block_size));
            }
            return false;
        }
        if (!dm.getPiece(pieceNumber).isDone()) {
            Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " piece #" + pieceNumber + " not done"));
            return false;
        }
        return true;
    }

    public static void doFileExistenceChecks(DiskManagerFileInfoSet fileSet, boolean[] toCheck, DownloadManager dm, boolean allowAlloction) {
        DiskManagerFileInfo[] files = fileSet.getFiles();
        int lastPieceScanned = -1;
        int windowStart = -1;
        int windowEnd = -1;
        String[] types = DiskManagerImpl.getStorageTypes(dm);
        for (int i = 0; i < files.length; ++i) {
            int firstPiece = files[i].getFirstPieceNumber();
            int lastPiece = files[i].getLastPieceNumber();
            if (toCheck[i]) {
                if (lastPieceScanned < firstPiece) {
                    windowStart = firstPiece;
                    while (i > 0 && files[i - 1].getLastPieceNumber() >= windowStart) {
                        --i;
                    }
                }
                if (windowEnd < lastPiece) {
                    windowEnd = lastPiece;
                }
            }
            if ((windowStart > firstPiece || firstPiece > windowEnd) && (windowStart > lastPiece || lastPiece > windowEnd)) continue;
            File currentFile = files[i].getFile(true);
            if (!RDResumeHandler.fileMustExist(dm, files[i])) {
                int st = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                if (st == 2 || st == 4) {
                    currentFile.delete();
                }
            } else if (allowAlloction && !currentFile.exists()) {
                dm.setDataAlreadyAllocated(false);
            }
            lastPieceScanned = lastPiece;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean setFileLink(DownloadManager download_manager, DiskManagerFileInfo[] info, DiskManagerFileInfo file_info, File from_file, File to_link) {
        block8: {
            File existing_file;
            block9: {
                if (to_link == null) break block8;
                existing_file = file_info.getFile(true);
                if (to_link.equals(existing_file)) {
                    return true;
                }
                for (int i = 0; i < info.length; ++i) {
                    if (!to_link.equals(info[i].getFile(true))) continue;
                    Logger.log(new LogAlert((Object)download_manager, true, 3, "Attempt to link to existing file '" + info[i].getFile(true) + "'"));
                    return false;
                }
                if (!to_link.exists()) break block9;
                if (!existing_file.exists()) {
                    download_manager.recheckFile(file_info);
                    break block8;
                } else {
                    Object skip_delete = download_manager.getUserData("set_link_dont_delete_existing");
                    if (skip_delete instanceof Boolean && ((Boolean)skip_delete).booleanValue()) {
                        download_manager.recheckFile(file_info);
                        break block8;
                    } else {
                        if (!FileUtil.deleteWithRecycle(existing_file, download_manager.getDownloadState().getFlag(16L))) {
                            Logger.log(new LogAlert((Object)download_manager, true, 3, "Failed to delete '" + existing_file.toString() + "'"));
                            return false;
                        }
                        download_manager.recheckFile(file_info);
                    }
                }
                break block8;
            }
            if (existing_file.exists() && !FileUtil.renameFile(existing_file, to_link)) {
                Logger.log(new LogAlert((Object)download_manager, true, 3, "Failed to rename '" + existing_file.toString() + "'"));
                return false;
            }
        }
        DownloadManagerState state = download_manager.getDownloadState();
        state.setFileLink(file_info.getIndex(), from_file, to_link);
        state.save();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiskManagerFileInfoSet getFileInfoSkeleton(final DownloadManager download_manager, DiskManagerListener listener) {
        TOTorrent torrent = download_manager.getTorrent();
        if (torrent == null) {
            return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
        }
        String tempRootDir = download_manager.getAbsoluteSaveLocation().getParent();
        if (tempRootDir == null) {
            tempRootDir = download_manager.getAbsoluteSaveLocation().getPath();
        }
        if (!torrent.isSimpleTorrent()) {
            tempRootDir = tempRootDir + File.separator + download_manager.getAbsoluteSaveLocation().getName();
        }
        tempRootDir = tempRootDir + File.separator;
        boolean[] loading = new boolean[]{true};
        String root_dir = StringInterner.intern(tempRootDir);
        try {
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] torrent_files = torrent.getFiles();
            DiskManagerFileInfoHelper[] res = new FileSkeleton[torrent_files.length];
            String incomplete_suffix = download_manager.getDownloadState().getAttribute("incompfilesuffix");
            DiskManagerFileInfoSet fileSetSkeleton = new DiskManagerFileInfoSet((FileSkeleton[])res, loading, download_manager, listener){
                final /* synthetic */ FileSkeleton[] val$res;
                final /* synthetic */ boolean[] val$loading;
                final /* synthetic */ DownloadManager val$download_manager;
                final /* synthetic */ DiskManagerListener val$listener;
                {
                    this.val$res = fileSkeletonArray;
                    this.val$loading = blArray;
                    this.val$download_manager = downloadManager;
                    this.val$listener = diskManagerListener;
                }

                public DiskManagerFileInfo[] getFiles() {
                    return this.val$res;
                }

                public int nbFiles() {
                    return this.val$res.length;
                }

                public void setPriority(int[] toChange) {
                    int i;
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    for (i = 0; i < this.val$res.length; ++i) {
                        this.val$res[i].priority = toChange[i];
                    }
                    if (!this.val$loading[0]) {
                        DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    }
                    for (i = 0; i < this.val$res.length; ++i) {
                        if (toChange[i] == 0) continue;
                        this.val$listener.filePriorityChanged(this.val$res[i]);
                    }
                }

                public void setSkipped(boolean[] toChange, boolean setSkipped) {
                    int i;
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    if (!setSkipped) {
                        String[] types = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                        boolean[] toLinear = new boolean[toChange.length];
                        boolean[] toReorder = new boolean[toChange.length];
                        int num_linear = 0;
                        int num_reorder = 0;
                        for (int i2 = 0; i2 < toChange.length; ++i2) {
                            if (!toChange[i2]) continue;
                            int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i2]);
                            if (old_type == 2) {
                                toLinear[i2] = true;
                                ++num_linear;
                                continue;
                            }
                            if (old_type != 4) continue;
                            toReorder[i2] = true;
                            ++num_reorder;
                        }
                        if (num_linear > 0 && !Arrays.equals(toLinear, this.setStorageTypes(toLinear, 1))) {
                            return;
                        }
                        if (num_reorder > 0 && !Arrays.equals(toReorder, this.setStorageTypes(toReorder, 3))) {
                            return;
                        }
                    }
                    File[] to_link = new File[this.val$res.length];
                    for (int i3 = 0; i3 < this.val$res.length; ++i3) {
                        if (!toChange[i3]) continue;
                        to_link[i3] = this.val$res[i3].setSkippedInternal(setSkipped);
                    }
                    if (!this.val$loading[0]) {
                        DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    }
                    ArrayList<Integer> from_indexes = new ArrayList<Integer>();
                    ArrayList<File> from_links = new ArrayList<File>();
                    ArrayList<File> to_links = new ArrayList<File>();
                    for (i = 0; i < this.val$res.length; ++i) {
                        if (to_link[i] == null) continue;
                        from_indexes.add(i);
                        from_links.add(this.val$res[i].getFile(false));
                        to_links.add(to_link[i]);
                    }
                    if (from_links.size() > 0) {
                        this.val$download_manager.getDownloadState().setFileLinks(from_indexes, from_links, to_links);
                    }
                    if (!setSkipped) {
                        DiskManagerUtil.doFileExistenceChecks(this, toChange, this.val$download_manager, true);
                    }
                    for (i = 0; i < this.val$res.length; ++i) {
                        if (!toChange[i]) continue;
                        this.val$listener.filePriorityChanged(this.val$res[i]);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean[] setStorageTypes(boolean[] toChange, int newStorageType) {
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    String[] types = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                    boolean[] modified = new boolean[this.val$res.length];
                    boolean[] toSkip = new boolean[this.val$res.length];
                    int toSkipCount = 0;
                    DownloadManagerState dmState = this.val$download_manager.getDownloadState();
                    try {
                        int i;
                        dmState.suppressStateSave(true);
                        for (i = 0; i < this.val$res.length; ++i) {
                            if (!toChange[i]) continue;
                            final int idx = i;
                            int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                            if (newStorageType == old_type) {
                                modified[i] = true;
                                continue;
                            }
                            try {
                                File target_file = this.val$res[i].getFile(true);
                                if (target_file.exists()) {
                                    CacheFile cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        public String getCacheFileOwnerName() {
                                            return val$download_manager.getInternalName();
                                        }

                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$res[idx].getTorrentFile();
                                        }

                                        public File getCacheFileControlFileDir() {
                                            return val$download_manager.getDownloadState().getStateFile();
                                        }

                                        public int getCacheMode() {
                                            return 1;
                                        }
                                    }, target_file, DiskManagerUtil.convertDMStorageTypeToCache(newStorageType));
                                    cache_file.getLength();
                                    cache_file.close();
                                }
                                boolean bl = toSkip[i] = (newStorageType == 2 || newStorageType == 4) && !this.val$res[i].isSkipped();
                                if (toSkip[i]) {
                                    ++toSkipCount;
                                }
                                modified[i] = true;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                Logger.log(new LogAlert((Object)this.val$download_manager, true, 3, "Failed to change storage type for '" + this.val$res[i].getFile(true) + "': " + Debug.getNestedExceptionMessage(e)));
                                RDResumeHandler.recheckFile(this.val$download_manager, this.val$res[i]);
                            }
                            types[i] = DiskManagerUtil.convertDMStorageTypeToString(newStorageType);
                        }
                        dmState.setListAttribute("storetypes", types);
                        if (toSkipCount > 0) {
                            this.setSkipped(toSkip, true);
                        }
                        for (i = 0; i < this.val$res.length; ++i) {
                            int cleared;
                            if (!toChange[i] || (cleared = RDResumeHandler.storageTypeChanged(this.val$download_manager, this.val$res[i])) <= 0) continue;
                            this.val$res[i].downloaded -= (long)cleared * this.val$res[i].getTorrentFile().getTorrent().getPieceLength();
                            if (this.val$res[i].downloaded >= 0L) continue;
                            this.val$res[i].downloaded = 0L;
                        }
                        DiskManagerImpl.storeFileDownloaded(this.val$download_manager, this.val$res, true);
                        DiskManagerUtil.doFileExistenceChecks(this, toChange, this.val$download_manager, newStorageType == 1 || newStorageType == 3);
                        Object var14_14 = null;
                        dmState.suppressStateSave(false);
                        dmState.save();
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        dmState.suppressStateSave(false);
                        dmState.save();
                        throw throwable;
                    }
                    return modified;
                }
            };
            for (int i = 0; i < res.length; ++i) {
                TOTorrentFile torrent_file = torrent_files[i];
                int file_index = i;
                FileSkeleton info = new FileSkeleton((FileSkeleton[])res, listener, file_index, fileSetSkeleton, incomplete_suffix, torrent_file, root_dir, locale_decoder){
                    private volatile CacheFile read_cache_file;
                    private WeakReference dataFile = new WeakReference<Object>(null);
                    final /* synthetic */ FileSkeleton[] val$res;
                    final /* synthetic */ DiskManagerListener val$listener;
                    final /* synthetic */ int val$file_index;
                    final /* synthetic */ DiskManagerFileInfoSet val$fileSetSkeleton;
                    final /* synthetic */ String val$incomplete_suffix;
                    final /* synthetic */ TOTorrentFile val$torrent_file;
                    final /* synthetic */ String val$root_dir;
                    final /* synthetic */ LocaleUtilDecoder val$locale_decoder;
                    {
                        this.val$res = fileSkeletonArray;
                        this.val$listener = diskManagerListener;
                        this.val$file_index = n;
                        this.val$fileSetSkeleton = diskManagerFileInfoSet;
                        this.val$incomplete_suffix = string;
                        this.val$torrent_file = tOTorrentFile;
                        this.val$root_dir = string2;
                        this.val$locale_decoder = localeUtilDecoder;
                    }

                    public void setPriority(int b) {
                        this.priority = b;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        this.val$listener.filePriorityChanged(this);
                    }

                    public void setSkipped(boolean _skipped) {
                        if (!_skipped && this.getStorageType() == 2 && !this.setStorageType(1)) {
                            return;
                        }
                        if (!_skipped && this.getStorageType() == 4 && !this.setStorageType(3)) {
                            return;
                        }
                        File to_link = this.setSkippedInternal(_skipped);
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        if (to_link != null) {
                            download_manager.getDownloadState().setFileLink(this.val$file_index, this.getFile(false), to_link);
                        }
                        if (!_skipped) {
                            boolean[] toCheck = new boolean[this.val$fileSetSkeleton.nbFiles()];
                            toCheck[this.val$file_index] = true;
                            DiskManagerUtil.doFileExistenceChecks(this.val$fileSetSkeleton, toCheck, download_manager, true);
                        }
                        this.val$listener.filePriorityChanged(this);
                    }

                    public int getAccessMode() {
                        return 1;
                    }

                    public long getDownloaded() {
                        return this.downloaded;
                    }

                    public void setDownloaded(long l) {
                        this.downloaded = l;
                    }

                    public String getExtension() {
                        int separator;
                        String ext = this.lazyGetFile().getName();
                        if (this.val$incomplete_suffix != null && ext.endsWith(this.val$incomplete_suffix)) {
                            ext = ext.substring(0, ext.length() - this.val$incomplete_suffix.length());
                        }
                        if ((separator = ext.lastIndexOf(".")) == -1) {
                            separator = 0;
                        }
                        return ext.substring(separator);
                    }

                    public int getFirstPieceNumber() {
                        return this.val$torrent_file.getFirstPieceNumber();
                    }

                    public int getLastPieceNumber() {
                        return this.val$torrent_file.getLastPieceNumber();
                    }

                    public long getLength() {
                        return this.val$torrent_file.getLength();
                    }

                    public int getIndex() {
                        return this.val$file_index;
                    }

                    public int getNbPieces() {
                        return this.val$torrent_file.getNumberOfPieces();
                    }

                    public int getPriority() {
                        return this.priority;
                    }

                    protected File setSkippedInternal(boolean _skipped) {
                        DownloadManagerState dm_state;
                        String dnd_sf;
                        this.skipped_internal = _skipped;
                        if (!download_manager.isDestroyed() && (dnd_sf = (dm_state = download_manager.getDownloadState()).getAttribute("dnd_sf")) != null) {
                            File new_parent;
                            File new_file;
                            File parent;
                            File link = this.getLink();
                            File file = this.getFile(false);
                            if (_skipped) {
                                File parent2;
                                if ((link == null || link.equals(file)) && (parent2 = file.getParentFile()) != null) {
                                    File new_parent2;
                                    File new_file2;
                                    String prefix = dm_state.getAttribute("dnd_pfx");
                                    String file_name = file.getName();
                                    if (prefix != null && !file_name.startsWith(prefix)) {
                                        file_name = prefix + file_name;
                                    }
                                    if (!(new_file2 = new File(new_parent2 = new File(parent2, dnd_sf), file_name)).exists()) {
                                        boolean ok;
                                        if (!new_parent2.exists()) {
                                            new_parent2.mkdirs();
                                        }
                                        if (new_parent2.canWrite() && (ok = file.exists() ? FileUtil.renameFile(file, new_file2) : true)) {
                                            return new_file2;
                                        }
                                    }
                                }
                            } else if (link != null && !file.exists() && (parent = file.getParentFile()) != null && parent.canWrite() && (new_file = new File(new_parent = parent.getName().equals(dnd_sf) ? parent : new File(parent, dnd_sf), link.getName())).equals(link)) {
                                String incomp_ext = dm_state.getAttribute("incompfilesuffix");
                                String file_name = file.getName();
                                String prefix = dm_state.getAttribute("dnd_pfx");
                                boolean prefix_removed = false;
                                if (prefix != null && file_name.startsWith(prefix)) {
                                    file_name = file_name.substring(prefix.length());
                                    prefix_removed = true;
                                }
                                if (incomp_ext != null && incomp_ext.length() > 0 && this.getDownloaded() != this.getLength()) {
                                    if (prefix == null) {
                                        prefix = "";
                                    }
                                    file = new File(file.getParentFile(), prefix + file_name + incomp_ext);
                                } else if (prefix_removed) {
                                    file = new File(file.getParentFile(), file_name);
                                }
                                boolean ok = new_file.exists() ? FileUtil.renameFile(new_file, file) : true;
                                if (ok) {
                                    File[] files = new_parent.listFiles();
                                    if (files != null && files.length == 0) {
                                        new_parent.delete();
                                    }
                                    return file;
                                }
                            }
                        }
                        return null;
                    }

                    public boolean isSkipped() {
                        return this.skipped_internal;
                    }

                    public DiskManager getDiskManager() {
                        return null;
                    }

                    public DownloadManager getDownloadManager() {
                        return download_manager;
                    }

                    public File getFile(boolean follow_link) {
                        File link;
                        if (follow_link && (link = this.getLink()) != null) {
                            return link;
                        }
                        return this.lazyGetFile();
                    }

                    private File lazyGetFile() {
                        File toReturn = (File)this.dataFile.get();
                        if (toReturn != null) {
                            return toReturn;
                        }
                        TOTorrent tor = download_manager.getTorrent();
                        String path_str = this.val$root_dir;
                        File simpleFile = null;
                        if (tor == null || tor.isSimpleTorrent()) {
                            simpleFile = download_manager.getAbsoluteSaveLocation();
                        } else {
                            byte[][] path_comps = this.val$torrent_file.getPathComponents();
                            for (int j = 0; j < path_comps.length; ++j) {
                                String comp2;
                                try {
                                    comp2 = this.val$locale_decoder.decodeString(path_comps[j]);
                                }
                                catch (UnsupportedEncodingException e) {
                                    Debug.printStackTrace(e);
                                    comp2 = "undecodableFileName" + this.val$file_index;
                                }
                                comp2 = FileUtil.convertOSSpecificChars(comp2, j != path_comps.length - 1);
                                path_str = path_str + (j == 0 ? "" : File.separator) + comp2;
                            }
                        }
                        toReturn = simpleFile != null ? simpleFile : new File(path_str);
                        this.dataFile = new WeakReference<File>(toReturn);
                        return toReturn;
                    }

                    public TOTorrentFile getTorrentFile() {
                        return this.val$torrent_file;
                    }

                    public boolean setLink(File link_destination) {
                        if (download_manager.getTorrent().isSimpleTorrent()) {
                            try {
                                download_manager.moveDataFiles(link_destination.getParentFile(), link_destination.getName());
                                return true;
                            }
                            catch (DownloadManagerException e) {
                                return false;
                            }
                        }
                        return this.setLinkAtomic(link_destination);
                    }

                    public boolean setLinkAtomic(File link_destination) {
                        return DiskManagerUtil.setFileLink(download_manager, this.val$res, this, this.lazyGetFile(), link_destination);
                    }

                    public File getLink() {
                        return download_manager.getDownloadState().getFileLink(this.val$file_index, this.lazyGetFile());
                    }

                    public boolean setStorageType(int type) {
                        boolean[] change = new boolean[this.val$res.length];
                        change[this.val$file_index] = true;
                        return this.val$fileSetSkeleton.setStorageTypes(change, type)[this.val$file_index];
                    }

                    public int getStorageType() {
                        return DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(download_manager, this.val$file_index));
                    }

                    public void flushCache() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public DirectByteBuffer read(long offset, int length) throws IOException {
                        CacheFile temp;
                        try {
                            cache_read_mon.enter();
                            if (this.read_cache_file == null) {
                                try {
                                    int type = DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(download_manager, this.val$file_index));
                                    this.read_cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        public String getCacheFileOwnerName() {
                                            return download_manager.getInternalName();
                                        }

                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$torrent_file;
                                        }

                                        public File getCacheFileControlFileDir() {
                                            return download_manager.getDownloadState().getStateFile();
                                        }

                                        public int getCacheMode() {
                                            return 1;
                                        }
                                    }, this.getFile(true), DiskManagerUtil.convertDMStorageTypeToCache(type));
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    throw new IOException(e.getMessage());
                                }
                            }
                            temp = this.read_cache_file;
                            Object var7_7 = null;
                            cache_read_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            cache_read_mon.exit();
                            throw throwable;
                        }
                        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
                        try {
                            temp.read(buffer, offset, (short)1);
                        }
                        catch (Throwable e) {
                            buffer.returnToPool();
                            Debug.printStackTrace(e);
                            throw new IOException(e.getMessage());
                        }
                        return buffer;
                    }

                    public int getReadBytesPerSecond() {
                        CacheFile temp = this.read_cache_file;
                        if (temp == null) {
                            return 0;
                        }
                        return 0;
                    }

                    public int getWriteBytesPerSecond() {
                        return 0;
                    }

                    public long getETA() {
                        return -1L;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() {
                        CacheFile temp;
                        try {
                            cache_read_mon.enter();
                            temp = this.read_cache_file;
                            this.read_cache_file = null;
                            Object var3_2 = null;
                            cache_read_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            cache_read_mon.exit();
                            throw throwable;
                        }
                        if (temp != null) {
                            try {
                                temp.close();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    public void addListener(DiskManagerFileInfoListener listener) {
                        if (this.getDownloaded() == this.getLength()) {
                            try {
                                listener.dataWritten(0L, this.getLength());
                                listener.dataChecked(0L, this.getLength());
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    public void removeListener(DiskManagerFileInfoListener listener) {
                    }
                };
                res[i] = info;
            }
            DiskManagerUtil.loadFilePriorities(download_manager, fileSetSkeleton);
            DiskManagerUtil.loadFileDownloaded(download_manager, res);
            DiskManagerFileInfoSet diskManagerFileInfoSet = fileSetSkeleton;
            {
                Object var16_17 = null;
                loading[0] = false;
            }
            return diskManagerFileInfoSet;
        }
        catch (Throwable throwable) {
            try {
                Object var16_18 = null;
                loading[0] = false;
                throw throwable;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
            }
        }
    }

    public static int convertDMStorageTypeFromString(String str) {
        char c = str.charAt(0);
        switch (c) {
            case 'L': {
                return 1;
            }
            case 'C': {
                return 2;
            }
            case 'R': {
                return 3;
            }
            case 'X': {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    public static String convertDMStorageTypeToString(int dm_type) {
        switch (dm_type) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static String convertCacheStorageTypeToString(int cache_type) {
        switch (cache_type) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static int convertDMStorageTypeToCache(int dm_type) {
        switch (dm_type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        if (files == null) {
            return;
        }
        ArrayList<Long> file_priorities = new ArrayList<Long>(files.length);
        for (int i = 0; i < files.length; ++i) {
            int value;
            DiskManagerFileInfo file = files[i];
            if (file == null) {
                return;
            }
            boolean skipped = file.isSkipped();
            int priority = file.getPriority();
            if (skipped) {
                value = 0;
            } else if (priority > 0) {
                value = priority;
            } else {
                value = priority - 1;
                if (value > 0) {
                    value = Integer.MIN_VALUE;
                }
            }
            file_priorities.add(i, Long.valueOf(value));
        }
        download_manager.setData("file_priorities", file_priorities);
        if (files.length > 0 && !(files[0] instanceof DiskManagerFileInfoImpl)) {
            long skipped_file_set_size = 0L;
            long skipped_but_downloaded = 0L;
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo file = files[i];
                if (!file.isSkipped()) continue;
                skipped_file_set_size += file.getLength();
                skipped_but_downloaded += file.getDownloaded();
            }
            DownloadManagerStats stats2 = download_manager.getStats();
            if (stats2 instanceof DownloadManagerStatsImpl) {
                ((DownloadManagerStatsImpl)stats2).setSkippedFileStats(skipped_file_set_size, skipped_but_downloaded);
            }
        }
    }

    static void loadFilePriorities(DownloadManager download_manager, DiskManagerFileInfoSet fileSet) {
        try {
            DiskManagerFileInfo[] files = fileSet.getFiles();
            if (files == null) {
                return;
            }
            List file_priorities = (List)download_manager.getData("file_priorities");
            if (file_priorities == null) {
                return;
            }
            boolean[] toSkip = new boolean[files.length];
            int[] prio = new int[files.length];
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo file = files[i];
                if (file == null) {
                    return;
                }
                try {
                    int priority = ((Long)file_priorities.get(i)).intValue();
                    if (priority == 0) {
                        toSkip[i] = true;
                        continue;
                    }
                    if (priority < 0) {
                        // empty if block
                    }
                    prio[i] = ++priority;
                    continue;
                }
                catch (Throwable t2) {
                    Debug.printStackTrace(t2);
                }
            }
            fileSet.setPriority(prio);
            fileSet.setSkipped(toSkip, true);
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    protected static void loadFileDownloaded(DownloadManager download_manager, DiskManagerFileInfoHelper[] files) {
        DownloadManagerState state = download_manager.getDownloadState();
        Map details = state.getMapAttribute("filedownloaded");
        if (details == null) {
            return;
        }
        List downloaded = (List)details.get("downloaded");
        if (downloaded == null) {
            return;
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                files[i].setDownloaded((Long)downloaded.get(i));
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    static {
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
        cache_read_mon = new AEMonitor("DiskManager:cacheRead");
    }

    static abstract class FileSkeleton
    implements DiskManagerFileInfoHelper {
        protected int priority;
        protected boolean skipped_internal;
        protected long downloaded;

        FileSkeleton() {
        }

        protected abstract File setSkippedInternal(boolean var1);
    }
}

