/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import java.io.File;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

class GlobalManagerHostSupport
implements TRHostTorrentFinder {
    protected GlobalManager gm;
    protected TRHost host;

    protected GlobalManagerHostSupport(GlobalManager _gm) {
        this.gm = _gm;
        this.host = TRHostFactory.getSingleton();
        this.host.initialise(this);
    }

    public TOTorrent lookupTorrent(byte[] hash) {
        TOTorrent torrent;
        DownloadManager dm = this.gm.getDownloadManager(new HashWrapper(hash));
        if (dm != null && (torrent = dm.getTorrent()) != null) {
            return torrent;
        }
        torrent = DownloadManagerImpl.getStubTorrent(hash);
        return torrent;
    }

    protected void torrentRemoved(String torrent_file_str, TOTorrent torrent) {
        File torrent_file;
        TRHostTorrent host_torrent = this.host.getHostTorrent(torrent);
        if (host_torrent != null && (torrent_file = new File(torrent_file_str)).exists()) {
            try {
                TorrentUtils.writeToFile(host_torrent.getTorrent(), torrent_file, false);
                host_torrent.setPassive(true);
            }
            catch (Throwable e) {
                Debug.out("Failed to make torrent '" + torrent_file_str + "' passive: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    protected void torrentAdded(String torrent_file_str, TOTorrent torrent) {
        TRHostTorrent host_torrent = this.host.getHostTorrent(torrent);
        if (host_torrent != null && host_torrent.getTorrent() != torrent) {
            host_torrent.setTorrent(torrent);
        }
    }

    protected void destroy() {
        this.host.close();
    }
}

