/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterExternalHandler;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.BannedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.BlockedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IPAddressRangeManager;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterAutoLoaderImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IpFilterImpl
implements IpFilter {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final long BAN_IP_PERSIST_TIME = 604800000L;
    private static final int MAX_BLOCKS_TO_REMEMBER = 500;
    private static IpFilterImpl ipFilter;
    private static AEMonitor2 class_mon;
    private IPAddressRangeManager range_manager = new IPAddressRangeManager();
    private Map<Integer, BannedIpImpl> bannedIps;
    private LinkedList ipsBlocked;
    private int num_ips_blocked = 0;
    private int num_ips_blocked_loggable = 0;
    private long last_update_time;
    private CopyOnWriteList<IPFilterListener> listenerz = new CopyOnWriteList(true);
    private CopyOnWriteList<IpFilterExternalHandler> external_handlers = new CopyOnWriteList();
    FrequencyLimitedDispatcher blockedListChangedDispatcher;
    private IpFilterAutoLoaderImpl ipFilterAutoLoader;
    private boolean ip_filter_enabled;
    private boolean ip_filter_allow;
    private ByteArrayHashMap<String> excluded_hashes = new ByteArrayHashMap();
    private TimerEventPeriodic unban_timer;
    private Map<Long, List<String>> unban_map;
    private Map<String, Long> unban_map_reverse;

    private IpFilterImpl() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Ip Filter Allow", "Ip Filter Enabled"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                IpFilterImpl.this.ip_filter_enabled = COConfigurationManager.getBooleanParameter("Ip Filter Enabled");
                IpFilterImpl.this.ip_filter_allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
                if (parameterName != null && parameterName.equals("Ip Filter Enabled")) {
                    for (IPFilterListener listener : IpFilterImpl.this.listenerz) {
                        listener.IPFilterEnabledChanged(IpFilterImpl.this.ip_filter_enabled);
                    }
                }
            }
        });
        this.unban_map = new TreeMap<Long, List<String>>();
        this.unban_map_reverse = new HashMap<String, Long>();
        ipFilter = this;
        this.bannedIps = new HashMap<Integer, BannedIpImpl>();
        this.ipsBlocked = new LinkedList();
        this.blockedListChangedDispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

            public void runSupport() {
                for (IPFilterListener listener : IpFilterImpl.this.listenerz) {
                    try {
                        listener.IPBlockedListChanged(IpFilterImpl.this);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }
        }, 10000);
        this.ipFilterAutoLoader = new IpFilterAutoLoaderImpl(this);
        try {
            this.loadBannedIPs();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            this.loadFilters(true, true);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        COConfigurationManager.addParameterListener(new String[]{"Ip Filter Allow", "Ip Filter Enabled"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                IpFilterImpl.this.markAsUpToDate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpFilter getInstance() {
        try {
            class_mon.enter();
            if (ipFilter == null) {
                ipFilter = new IpFilterImpl();
            }
            IpFilterImpl ipFilterImpl = ipFilter;
            Object var2_1 = null;
            class_mon.exit();
            return ipFilterImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public File getFile() {
        return FileUtil.getUserFile("filters.config");
    }

    public void reload() throws Exception {
        this.reload(true);
    }

    public void reloadSync() throws Exception {
        this.reload(false);
    }

    public void reload(boolean allowAsyncDownloading) throws Exception {
        if (COConfigurationManager.getBooleanParameter("Ip Filter Clear On Reload")) {
            this.range_manager.clearAllEntries();
        }
        this.markAsUpToDate();
        this.loadFilters(allowAsyncDownloading, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws Exception {
        try {
            block5: {
                class_mon.enter();
                HashMap map = new HashMap();
                ArrayList filters = new ArrayList();
                map.put("ranges", filters);
                ArrayList entries = this.range_manager.getEntries();
                for (IpRange range : entries) {
                    if (!range.isValid() || range.isSessionOnly()) continue;
                    String description = range.getDescription();
                    String startIp = range.getStartIp();
                    String endIp = range.getEndIp();
                    HashMap<String, Object> mapRange = new HashMap<String, Object>();
                    mapRange.put("description", description.getBytes("UTF-8"));
                    mapRange.put("start", startIp);
                    mapRange.put("end", endIp);
                    filters.add(mapRange);
                }
                FileOutputStream fos = null;
                try {
                    File filtersFile = FileUtil.getUserFile("filters.config");
                    fos = new FileOutputStream(filtersFile);
                    fos.write(BEncoder.encode(map));
                    Object var11_10 = null;
                    if (fos == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
            }
            Object var13_13 = null;
            class_mon.exit();
            return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadFilters(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading) throws Exception {
        long startTime = System.currentTimeMillis();
        this.ipFilterAutoLoader.loadOtherFilters(allowAsyncDownloading, loadOldWhileAsyncDownloading);
        if (this.getNbRanges() > 0) {
            Logger.log(new LogEvent(LOGID, System.currentTimeMillis() - startTime + "ms for " + this.getNbRanges() + ". now loading norm"));
        }
        try {
            Throwable e22;
            BufferedInputStream bin;
            FileInputStream fin;
            ArrayList<IpRangeImpl> new_ipRanges;
            block18: {
                class_mon.enter();
                new_ipRanges = new ArrayList<IpRangeImpl>(1024);
                fin = null;
                bin = null;
                File filtersFile = FileUtil.getUserFile("filters.config");
                if (filtersFile.exists()) {
                    fin = new FileInputStream(filtersFile);
                    bin = new BufferedInputStream(fin, 16384);
                    Map<String, Object> map = BDecoder.decode(bin);
                    List list = (List)map.get("ranges");
                    ListIterator iter = list.listIterator();
                    while (iter.hasNext()) {
                        Map range = (Map)iter.next();
                        String description = new String((byte[])range.get("description"), "UTF-8");
                        String startIp = new String((byte[])range.get("start"));
                        String endIp = new String((byte[])range.get("end"));
                        IpRangeImpl ipRange = new IpRangeImpl(description, startIp, endIp, false);
                        ipRange.setAddedToRangeList(true);
                        new_ipRanges.add(ipRange);
                    }
                }
                Object var18_16 = null;
                if (bin == null) break block18;
                try {
                    bin.close();
                }
                catch (Throwable e22) {
                    // empty catch block
                }
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Throwable e22) {
                    // empty catch block
                }
            }
            Iterator it = new_ipRanges.iterator();
            while (it.hasNext()) {
                ((IpRange)it.next()).checkValid();
            }
            {
            }
            catch (Throwable throwable) {
                Throwable e22;
                Object var18_17 = null;
                if (bin != null) {
                    try {
                        bin.close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable e22) {
                        // empty catch block
                    }
                }
                it = new_ipRanges.iterator();
                while (it.hasNext()) {
                    ((IpRange)it.next()).checkValid();
                }
                this.markAsUpToDate();
                throw throwable;
            }
            this.markAsUpToDate();
            Object var21_21 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            class_mon.exit();
            throw throwable;
        }
        Logger.log(new LogEvent(LOGID, System.currentTimeMillis() - startTime + "ms to load all IP Filters"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBannedIPs() {
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            return;
        }
        try {
            try {
                class_mon.enter();
                Map map = FileUtil.readResilientConfigFile("banips.config");
                List ips = (List)map.get("ips");
                if (ips != null) {
                    long now = SystemTime.getCurrentTime();
                    for (int i = 0; i < ips.size(); ++i) {
                        Map entry = (Map)ips.get(i);
                        String ip = new String((byte[])entry.get("ip"));
                        String desc = new String((byte[])entry.get("desc"), "UTF-8");
                        Long ltime = (Long)entry.get("time");
                        long time = ltime;
                        boolean drop = false;
                        if (time > now) {
                            time = now;
                        } else if (now - time >= 604800000L) {
                            drop = true;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, 0, "Persistent ban dropped as too old : " + ip + ", " + desc));
                            }
                        }
                        if (drop) continue;
                        int int_ip = this.range_manager.addressToInt(ip);
                        this.bannedIps.put(new Integer(int_ip), new BannedIpImpl(ip, desc, time));
                    }
                }
                Object var15_13 = null;
                class_mon.exit();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                Object var15_14 = null;
                class_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBannedIPs() {
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            return;
        }
        try {
            try {
                class_mon.enter();
                HashMap map = new HashMap();
                ArrayList ips = new ArrayList();
                for (BannedIpImpl bip : this.bannedIps.values()) {
                    if (bip.isTemporary()) continue;
                    HashMap<String, Object> entry = new HashMap<String, Object>();
                    entry.put("ip", bip.getIp());
                    entry.put("desc", bip.getTorrentName().getBytes("UTF-8"));
                    entry.put("time", new Long(bip.getBanningTime()));
                    ips.add(entry);
                }
                map.put("ips", ips);
                FileUtil.writeResilientConfigFile("banips.config", map);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                Object var7_8 = null;
                class_mon.exit();
            }
            Object var7_7 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public boolean isInRange(String ipAddress) {
        return this.isInRange(ipAddress, "", null);
    }

    public boolean isInRange(String ipAddress, String torrent_name, byte[] torrent_hash) {
        return this.isInRange(ipAddress, torrent_name, torrent_hash, true);
    }

    public boolean isInRange(String ipAddress, String torrent_name, byte[] torrent_hash, boolean loggable) {
        IpRange explict_deny;
        if (this.isBanned(ipAddress)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (ipAddress.equals("127.0.0.1")) {
            return false;
        }
        if (ipAddress.indexOf(":") != -1) {
            return false;
        }
        if (AddressUtils.isLANLocalAddress(ipAddress) == 1) {
            return false;
        }
        if (torrent_hash != null && this.excluded_hashes.containsKey(torrent_hash)) {
            return false;
        }
        boolean allow = this.ip_filter_allow;
        IpRange match = (IpRange)this.range_manager.isInRange(ipAddress);
        if ((match == null || allow) && (explict_deny = this.checkExternalHandlers(torrent_hash, ipAddress)) != null) {
            match = explict_deny;
            allow = false;
        }
        if (match != null) {
            if (!allow) {
                if (AENetworkClassifier.categoriseAddress(ipAddress) != "Public") {
                    return false;
                }
                if (this.addBlockedIP(new BlockedIpImpl(ipAddress, match, torrent_name, loggable), torrent_hash, loggable)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", in range : " + match));
                    }
                    return true;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied : " + ipAddress + ", in range : " + match));
                }
                return false;
            }
            return false;
        }
        if (allow) {
            if (AENetworkClassifier.categoriseAddress(ipAddress) != "Public") {
                return false;
            }
            if (this.addBlockedIP(new BlockedIpImpl(ipAddress, null, torrent_name, loggable), torrent_hash, loggable)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", not in any range"));
                }
                return true;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied : " + ipAddress + ", not in any range"));
            }
            return false;
        }
        return false;
    }

    public boolean isInRange(InetAddress ipAddress, String torrent_name, byte[] torrent_hash, boolean loggable) {
        IpRange explicit_deny;
        if (this.isBanned(ipAddress)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (ipAddress.isLoopbackAddress() || ipAddress.isLinkLocalAddress() || ipAddress.isSiteLocalAddress()) {
            return false;
        }
        if (ipAddress instanceof Inet6Address) {
            return false;
        }
        if (AddressUtils.isLANLocalAddress(ipAddress) == 1) {
            return false;
        }
        if (torrent_hash != null && this.excluded_hashes.containsKey(torrent_hash)) {
            return false;
        }
        boolean allow = this.ip_filter_allow;
        IpRange match = (IpRange)this.range_manager.isInRange(ipAddress);
        if ((match == null || allow) && (explicit_deny = this.checkExternalHandlers(torrent_hash, ipAddress)) != null) {
            match = explicit_deny;
            allow = false;
        }
        if (match != null) {
            if (!allow) {
                if (this.addBlockedIP(new BlockedIpImpl(ipAddress.getHostAddress(), match, torrent_name, loggable), torrent_hash, loggable)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", in range : " + match));
                    }
                    return true;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied: " + ipAddress + ", in range : " + match));
                }
                return false;
            }
            return false;
        }
        if (allow) {
            if (this.addBlockedIP(new BlockedIpImpl(ipAddress.getHostAddress(), null, torrent_name, loggable), torrent_hash, loggable)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + ipAddress + ", not in any range"));
                }
                return true;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied : " + ipAddress + ", not in any range"));
            }
            return false;
        }
        return false;
    }

    protected IpRange checkExternalHandlers(byte[] torrent_hash, String address) {
        if (this.external_handlers.size() > 0) {
            Iterator<IpFilterExternalHandler> it = this.external_handlers.iterator();
            while (it.hasNext()) {
                if (!it.next().isBlocked(torrent_hash, address)) continue;
                return new IpRangeImpl("External handler", address, address, true);
            }
        }
        return null;
    }

    protected IpRange checkExternalHandlers(byte[] torrent_hash, InetAddress address) {
        if (this.external_handlers.size() > 0) {
            Iterator<IpFilterExternalHandler> it = this.external_handlers.iterator();
            while (it.hasNext()) {
                if (!it.next().isBlocked(torrent_hash, address)) continue;
                String ip = address.getHostAddress();
                return new IpRangeImpl("External handler", ip, ip, true);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addBlockedIP(BlockedIp ip, byte[] torrent_hash, boolean loggable) {
        if (torrent_hash != null) {
            for (IPFilterListener listener : this.listenerz) {
                try {
                    if (listener.canIPBeBlocked(ip.getBlockedIp(), torrent_hash)) continue;
                    return false;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        try {
            class_mon.enter();
            this.ipsBlocked.addLast(ip);
            ++this.num_ips_blocked;
            if (loggable) {
                ++this.num_ips_blocked_loggable;
            }
            if (this.ipsBlocked.size() > 500) {
                this.ipsBlocked.removeFirst();
            }
            Object var8_7 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            class_mon.exit();
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanned(InetAddress ipAddress) {
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            boolean bl = this.bannedIps.get(i_address) != null;
            Object var6_5 = null;
            class_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanned(String ipAddress) {
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            boolean bl = this.bannedIps.get(i_address) != null;
            Object var6_5 = null;
            class_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public boolean getInRangeAddressesAreAllowed() {
        return this.ip_filter_allow;
    }

    public void setInRangeAddressesAreAllowed(boolean b) {
        COConfigurationManager.setParameter("Ip Filter Allow", b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getIpRanges() {
        try {
            class_mon.enter();
            ArrayList arrayList = new ArrayList(this.range_manager.getEntries());
            Object var3_2 = null;
            class_mon.exit();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpRange[] getRanges() {
        try {
            class_mon.enter();
            ArrayList entries = this.range_manager.getEntries();
            IpRange[] res = new IpRange[entries.size()];
            entries.toArray(res);
            IpRange[] ipRangeArray = res;
            Object var5_4 = null;
            class_mon.exit();
            return ipRangeArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public IpRange createRange(boolean sessionOnly) {
        return new IpRangeImpl("", "", "", sessionOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRange(IpRange range) {
        try {
            class_mon.enter();
            ((IpRangeImpl)range).setAddedToRangeList(true);
            range.checkValid();
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
        this.markAsUpToDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(IpRange range) {
        try {
            class_mon.enter();
            ((IpRangeImpl)range).setAddedToRangeList(false);
            this.range_manager.removeRange(range);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
        this.markAsUpToDate();
    }

    public int getNbRanges() {
        ArrayList entries = this.range_manager.getEntries();
        return entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValidOrNot(IpRange range, boolean valid) {
        try {
            class_mon.enter();
            if (!range.getAddedToRangeList()) {
                Object var4_3 = null;
                class_mon.exit();
                return;
            }
            Object var4_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            class_mon.exit();
            throw throwable;
        }
        if (valid) {
            this.range_manager.addRange(range);
        } else {
            this.range_manager.removeRange(range);
        }
    }

    public int getNbIpsBlocked() {
        return this.num_ips_blocked;
    }

    public int getNbIpsBlockedAndLoggable() {
        return this.num_ips_blocked_loggable;
    }

    public boolean ban(String ipAddress, String torrent_name, boolean manual) {
        return this.ban(ipAddress, torrent_name, manual, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ban(String ipAddress, String torrent_name, boolean manual, int for_mins) {
        if (!manual) {
            for (IPFilterListener listener : this.listenerz) {
                try {
                    if (listener.canIPBeBanned(ipAddress)) continue;
                    return false;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        boolean block_ban = false;
        ArrayList<BannedIpImpl> new_bans = new ArrayList<BannedIpImpl>();
        boolean temporary = for_mins > 0;
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            if (this.bannedIps.get(i_address) == null) {
                BannedIpImpl new_ban = new BannedIpImpl(ipAddress, torrent_name, temporary);
                new_bans.add(new_ban);
                this.bannedIps.put(i_address, new_ban);
                if (temporary) {
                    this.addTemporaryBan(new_ban, for_mins);
                }
                if (!UnresolvableHostManager.isPseudoAddress(ipAddress)) {
                    long l_address = address;
                    if (l_address < 0L) {
                        l_address += 0x100000000L;
                    }
                    long start = l_address & 0xFFFFFFFFFFFFFF00L;
                    long end = start + 256L;
                    int hits = 0;
                    for (long i = start; i < end; ++i) {
                        Integer a = new Integer((int)i);
                        if (this.bannedIps.get(a) == null) continue;
                        ++hits;
                    }
                    int hit_limit = COConfigurationManager.getIntParameter("Ip Filter Ban Block Limit");
                    if (hits >= hit_limit) {
                        block_ban = true;
                        for (long i = start; i < end; ++i) {
                            Integer a = new Integer((int)i);
                            if (this.bannedIps.get(a) != null) continue;
                            BannedIpImpl new_block_ban = new BannedIpImpl(PRHelpers.intToAddress((int)i), torrent_name + " [block ban]", temporary);
                            new_bans.add(new_block_ban);
                            this.bannedIps.put(a, new_block_ban);
                            this.addTemporaryBan(new_block_ban, for_mins);
                        }
                    }
                }
                this.saveBannedIPs();
            }
            Object var24_24 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var24_25 = null;
            class_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < new_bans.size(); ++i) {
            BannedIp entry = (BannedIp)new_bans.get(i);
            for (IPFilterListener listener : this.listenerz) {
                try {
                    listener.IPBanned(entry);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        return block_ban;
    }

    private void addTemporaryBan(BannedIpImpl ban, int mins) {
        List<String> list;
        if (this.unban_timer == null) {
            this.unban_timer = SimpleTimer.addPeriodicEvent("Unbanner", 30000L, new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(TimerEvent event2) {
                    try {
                        Map.Entry entry;
                        class_mon.enter();
                        long now = SystemTime.getMonotonousTime();
                        Iterator it = IpFilterImpl.this.unban_map.entrySet().iterator();
                        while (it.hasNext() && (Long)(entry = it.next()).getKey() <= now) {
                            it.remove();
                            for (String ip : (List)entry.getValue()) {
                                IpFilterImpl.this.unban_map_reverse.remove(ip);
                                IpFilterImpl.this.unban(ip);
                            }
                        }
                        if (IpFilterImpl.this.unban_map.size() == 0) {
                            IpFilterImpl.this.unban_timer.cancel();
                            IpFilterImpl.this.unban_timer = null;
                        }
                        Object var9_7 = null;
                        class_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        class_mon.exit();
                        throw throwable;
                    }
                }
            });
        }
        String ip = ban.getIp();
        long expiry = SystemTime.getMonotonousTime() + (long)(mins * 60) * 1000L;
        expiry = (expiry + 29999L) / 30000L * 30000L;
        Long old_expiry = this.unban_map_reverse.get(ip);
        if (old_expiry != null && (list = this.unban_map.get(old_expiry)) != null) {
            list.remove(ip);
            if (list.size() == 0) {
                this.unban_map.remove(old_expiry);
            }
        }
        this.unban_map_reverse.put(ip, expiry);
        list = this.unban_map.get(expiry);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.unban_map.put(expiry, list);
        }
        list.add(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BannedIp[] getBannedIps() {
        try {
            class_mon.enter();
            BannedIp[] res = new BannedIp[this.bannedIps.size()];
            this.bannedIps.values().toArray(res);
            BannedIp[] bannedIpArray = res;
            Object var4_3 = null;
            class_mon.exit();
            return bannedIpArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public int getNbBannedIps() {
        return this.bannedIps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBannedIps() {
        try {
            class_mon.enter();
            this.bannedIps.clear();
            this.unban_map.clear();
            this.unban_map_reverse.clear();
            this.saveBannedIPs();
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unban(String ipAddress) {
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            BannedIpImpl entry = this.bannedIps.remove(i_address);
            if (entry != null && !entry.isTemporary()) {
                this.saveBannedIPs();
            }
            Object var6_5 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unban(String ipAddress, boolean block) {
        if (block) {
            int address = this.range_manager.addressToInt(ipAddress);
            long l_address = address;
            if (l_address < 0L) {
                l_address += 0x100000000L;
            }
            long start = l_address & 0xFFFFFFFFFFFFFF00L;
            long end = start + 256L;
            boolean hit = false;
            try {
                class_mon.enter();
                for (long i = start; i < end; ++i) {
                    Integer a = new Integer((int)i);
                    if (this.bannedIps.remove(a) == null) continue;
                    hit = true;
                }
                if (hit) {
                    this.saveBannedIPs();
                }
                Object var15_12 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var15_13 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        try {
            class_mon.enter();
            int address = this.range_manager.addressToInt(ipAddress);
            Integer i_address = new Integer(address);
            if (this.bannedIps.remove(i_address) != null) {
                this.saveBannedIPs();
            }
            Object var17_15 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockedIp[] getBlockedIps() {
        try {
            class_mon.enter();
            BlockedIp[] res = new BlockedIp[this.ipsBlocked.size()];
            this.ipsBlocked.toArray(res);
            BlockedIp[] blockedIpArray = res;
            Object var4_3 = null;
            class_mon.exit();
            return blockedIpArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlockedIPs() {
        try {
            class_mon.enter();
            this.ipsBlocked.clear();
            this.num_ips_blocked = 0;
            this.num_ips_blocked_loggable = 0;
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcludedHash(byte[] hash) {
        IpFilterImpl ipFilterImpl = this;
        synchronized (ipFilterImpl) {
            if (this.excluded_hashes.containsKey(hash)) {
                return;
            }
            ByteArrayHashMap<String> copy = new ByteArrayHashMap<String>();
            for (byte[] k : this.excluded_hashes.keys()) {
                copy.put(k, "");
            }
            copy.put(hash, "");
            this.excluded_hashes = copy;
        }
        this.markAsUpToDate();
        Logger.log(new LogEvent(LOGID, "Added " + ByteFormatter.encodeString(hash) + " to excluded set"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExcludedHash(byte[] hash) {
        IpFilterImpl ipFilterImpl = this;
        synchronized (ipFilterImpl) {
            if (!this.excluded_hashes.containsKey(hash)) {
                return;
            }
            ByteArrayHashMap<String> copy = new ByteArrayHashMap<String>();
            for (byte[] k : this.excluded_hashes.keys()) {
                copy.put(k, "");
            }
            copy.remove(hash);
            this.excluded_hashes = copy;
        }
        this.markAsUpToDate();
        Logger.log(new LogEvent(LOGID, "Removed " + ByteFormatter.encodeString(hash) + " from excluded set"));
    }

    public boolean isEnabled() {
        return this.ip_filter_enabled;
    }

    public void setEnabled(boolean enabled) {
        COConfigurationManager.setParameter("Ip Filter Enabled", enabled);
    }

    public void markAsUpToDate() {
        this.last_update_time = SystemTime.getCurrentTime();
        this.blockedListChangedDispatcher.dispatch();
    }

    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    public long getTotalAddressesInRange() {
        return this.range_manager.getTotalSpan();
    }

    public void addListener(IPFilterListener l) {
        this.listenerz.add(l);
    }

    public void removeListener(IPFilterListener l) {
        this.listenerz.remove(l);
    }

    public void addExternalHandler(IpFilterExternalHandler h) {
        this.external_handlers.add(h);
    }

    public void removeExternalHandler(IpFilterExternalHandler h) {
        this.external_handlers.remove(h);
    }

    static {
        class_mon = new AEMonitor2("IpFilter:class");
    }
}

