/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer;

import com.aelitis.azureus.core.AzureusCore;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.stats.transfer.LongTermStats;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.impl.LongTermStatsWrapper;
import org.gudy.azureus2.core3.stats.transfer.impl.OverallStatsImpl;

public class StatsFactory {
    private static OverallStats overall_stats;
    private static LongTermStats longterm_stats;
    private static Map<String, LongTermStats> generic_longterm_stats;

    public static OverallStats getStats() {
        return overall_stats;
    }

    public static LongTermStats getLongTermStats() {
        return longterm_stats;
    }

    public static void initialize(AzureusCore core, GlobalManagerStats stats2) {
        overall_stats = new OverallStatsImpl(core, stats2);
        longterm_stats = new LongTermStatsWrapper(core, stats2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LongTermStats getGenericLongTermStats(String id, LongTermStats.GenericStatsSource source) {
        Map<String, LongTermStats> map = generic_longterm_stats;
        synchronized (map) {
            LongTermStats result = generic_longterm_stats.get(id);
            if (result == null) {
                result = new LongTermStatsWrapper(id, source);
                generic_longterm_stats.put(id, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLongTermStats() {
        longterm_stats.reset();
        Map<String, LongTermStats> map = generic_longterm_stats;
        synchronized (map) {
            for (LongTermStats lts : generic_longterm_stats.values()) {
                lts.reset();
            }
        }
    }

    static {
        generic_longterm_stats = new HashMap<String, LongTermStats>();
    }
}

