/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class TRTrackerScraperResponseImpl
implements TRTrackerScraperResponse {
    private HashWrapper hash;
    private int seeds;
    private int peers;
    private int completed;
    private long scrapeStartTime;
    private long nextScrapeStartTime;
    private String sStatus = "";
    private String sLastStatus = "";
    private int status;
    private int last_status;
    private int last_status_set_time = (int)(SystemTime.getCurrentTime() / 1000L);
    private static final int scrapeFuzzAdd = (int)(Math.random() * 3.0 * 60.0);

    protected TRTrackerScraperResponseImpl(HashWrapper _hash) {
        this(_hash, -1, -1, -1, -1L);
    }

    protected TRTrackerScraperResponseImpl(HashWrapper _hash, int _seeds, int _peers, int completed, long _scrapeStartTime) {
        this.hash = _hash;
        this.seeds = _seeds;
        this.completed = completed;
        this.peers = _peers;
        this.scrapeStartTime = _scrapeStartTime;
        this.status = !this.isValid() ? 0 : 2;
        this.nextScrapeStartTime = -1L;
    }

    public int getCompleted() {
        return this.completed;
    }

    public void setCompleted(int completed) {
        if (completed >= 0) {
            this.completed = completed;
        }
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    public int getSeeds() {
        return this.seeds;
    }

    public void setSeeds(int s) {
        this.seeds = s;
    }

    public int getPeers() {
        return this.peers;
    }

    public void setPeers(int p) {
        this.peers = p;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int s) {
        this.last_status_set_time = (int)(SystemTime.getCurrentTime() / 1000L);
        this.status = s;
    }

    protected void setStatus(String str) {
        this.last_status_set_time = (int)(SystemTime.getCurrentTime() / 1000L);
        this.sStatus = str;
    }

    public void setStatus(int iNewStatus, String sNewStatus) {
        this.last_status_set_time = (int)(SystemTime.getCurrentTime() / 1000L);
        if (this.last_status != this.status && iNewStatus != this.status) {
            this.last_status = this.status;
        }
        this.status = iNewStatus == 2 ? (!this.isValid() ? 0 : 2) : iNewStatus;
        if (sNewStatus == null) {
            return;
        }
        if (!this.sLastStatus.equals(this.sStatus)) {
            this.sLastStatus = this.sStatus;
        }
        this.sStatus = StringInterner.intern(sNewStatus);
    }

    public void revertStatus() {
        this.status = this.last_status;
        this.sStatus = this.sLastStatus;
    }

    public int getScrapeTime() {
        return this.last_status_set_time;
    }

    public void setScrapeStartTime(long time) {
        this.scrapeStartTime = time;
    }

    public long getScrapeStartTime() {
        return this.scrapeStartTime;
    }

    public long getNextScrapeStartTime() {
        return this.nextScrapeStartTime;
    }

    public void setNextScrapeStartTime(long _nextScrapeStartTime) {
        this.nextScrapeStartTime = _nextScrapeStartTime;
    }

    public String getStatusString() {
        return this.sStatus;
    }

    public boolean isValid() {
        return this.seeds != -1 || this.peers != -1;
    }

    public abstract void setDHTBackup(boolean var1);

    public static int calcScrapeIntervalSecs(int iRecIntervalSecs, int iNumSeeds) {
        int MIN = 900;
        int MAX = 10800;
        int scrapeInterval = 900 + iNumSeeds * 10;
        if (iRecIntervalSecs > scrapeInterval) {
            scrapeInterval = iRecIntervalSecs;
        }
        if ((scrapeInterval += scrapeFuzzAdd) > 10800) {
            scrapeInterval = 10800;
        }
        return scrapeInterval;
    }

    public String getString() {
        return this.getURL() + ": " + ByteFormatter.encodeString(this.hash.getBytes()) + ",seeds=" + this.seeds + ",peers=" + this.peers + ",state=" + this.status + "/" + this.sStatus + ",last=" + this.last_status + "/" + this.sLastStatus + ",start=" + this.scrapeStartTime + ",next=" + this.nextScrapeStartTime;
    }
}

