/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerPublishImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class TRHostTorrentPublishImpl
implements TRHostTorrent {
    private TRHostImpl host;
    private TOTorrent torrent;
    private long date_added;
    private int status = 3;
    private boolean persistent;
    private int seed_count;
    private int peer_count;
    private TRHostPeer[] peers = new TRHostPeer[0];
    private List listeners_cow = new ArrayList();
    private List removal_listeners = new ArrayList();
    private HashMap data;
    protected AEMonitor this_mon = new AEMonitor("TRHostTorrentPublish");

    protected TRHostTorrentPublishImpl(TRHostImpl _host, TOTorrent _torrent, long _date_added) {
        this.host = _host;
        this.torrent = _torrent;
        this.date_added = _date_added;
    }

    public void start() {
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws TRHostTorrentRemovalVetoException {
        try {
            this.this_mon.enter();
            this.canBeRemoved();
            this.host.remove(this);
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean canBeRemoved() throws TRHostTorrentRemovalVetoException {
        for (int i = 0; i < this.removal_listeners.size(); ++i) {
            ((TRHostTorrentWillBeRemovedListener)this.removal_listeners.get(i)).torrentWillBeRemoved(this);
        }
        return true;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean _persistent) {
        this.persistent = _persistent;
    }

    public boolean isPassive() {
        return false;
    }

    public void setPassive(boolean passive) {
    }

    public long getDateAdded() {
        return this.date_added;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void setTorrent(TOTorrent t) {
        this.torrent = t;
    }

    public TRTrackerServerTorrent getTrackerTorrent() {
        return null;
    }

    public int getPort() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRHostPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRHostPeer[] tRHostPeerArray = this.peers;
            Object var3_2 = null;
            this.this_mon.exit();
            return tRHostPeerArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public long getAnnounceCount() {
        return 0L;
    }

    public long getAverageAnnounceCount() {
        return 0L;
    }

    public long getScrapeCount() {
        return 0L;
    }

    public long getAverageScrapeCount() {
        return 0L;
    }

    public long getCompletedCount() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStats() {
        TRTrackerScraperResponse resp = null;
        TRTrackerAnnouncer tc = this.host.getTrackerClient(this);
        if (tc != null) {
            resp = TRTrackerScraperFactory.getSingleton().scrape(tc);
        }
        if (resp == null) {
            resp = TRTrackerScraperFactory.getSingleton().scrape(this.torrent);
        }
        try {
            this.this_mon.enter();
            if (resp != null && resp.isValid()) {
                this.peer_count = resp.getPeers();
                this.seed_count = resp.getSeeds();
                this.peers = new TRHostPeer[this.peer_count + this.seed_count];
                for (int i = 0; i < this.peers.length; ++i) {
                    this.peers[i] = new TRHostPeerPublishImpl(i < this.seed_count);
                }
            } else {
                this.peers = new TRHostPeer[0];
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public int getSeedCount() {
        return this.seed_count;
    }

    public int getLeecherCount() {
        return this.peer_count;
    }

    public int getBadNATCount() {
        return 0;
    }

    public long getTotalUploaded() {
        return 0L;
    }

    public long getTotalDownloaded() {
        return 0L;
    }

    public long getTotalLeft() {
        return 0L;
    }

    public long getAverageUploaded() {
        return 0L;
    }

    public long getAverageDownloaded() {
        return 0L;
    }

    public long getTotalBytesIn() {
        return 0L;
    }

    public long getTotalBytesOut() {
        return 0L;
    }

    public long getAverageBytesIn() {
        return 0L;
    }

    public long getAverageBytesOut() {
        return 0L;
    }

    public void disableReplyCaching() {
    }

    protected void preProcess(TRHostTorrentRequest req) throws TRHostException {
        List listeners_ref = this.listeners_cow;
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                ((TRHostTorrentListener)listeners_ref.get(i)).preProcess(req);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void postProcess(TRHostTorrentRequest req) throws TRHostException {
        List listeners_ref = this.listeners_cow;
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                ((TRHostTorrentListener)listeners_ref.get(i)).postProcess(req);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            ArrayList<TRHostTorrentListener> new_listeners = new ArrayList<TRHostTorrentListener>(this.listeners_cow);
            new_listeners.add(l);
            this.listeners_cow = new_listeners;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.host.torrentListenerRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TRHostTorrentListener l) {
        try {
            this.this_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners_cow);
            new_listeners.remove(l);
            this.listeners_cow = new_listeners;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(l);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemovalListener(TRHostTorrentWillBeRemovedListener l) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(l);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }
}

