/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;

public abstract class TRTrackerServerTCP
extends TRTrackerServerImpl {
    private static int THREAD_POOL_SIZE = COConfigurationManager.getIntParameter("Tracker Max Threads");
    public static long PROCESSING_GET_LIMIT = COConfigurationManager.getIntParameter("Tracker Max GET Time") * 1000;
    public static int PROCESSING_POST_MULTIPLIER = COConfigurationManager.getIntParameter("Tracker Max POST Time Multiplier");
    private boolean ssl;
    private int port;
    private boolean apply_ip_filter;
    private boolean restrict_non_blocking_requests = TRTrackerServerImpl.restrict_non_blocking_requests;
    private ThreadPool thread_pool;
    static boolean LOG_DOS_TO_FILE;
    protected static File dos_log_file;
    protected static AEMonitor class_mon;
    Map DOS_map = new LinkedHashMap(1000, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return TRTrackerServerTCP.this.checkDOSRemove(eldest);
        }
    };
    List dos_list = new ArrayList(128);
    long last_dos_check = 0L;
    long MAX_DOS_ENTRIES = 10000L;
    long MAX_DOS_RETENTION = 10000L;
    int DOS_CHECK_DEAD_WOOD_COUNT = 512;
    int DOS_MIN_INTERVAL = 1000;
    int dos_check_count = 0;

    public TRTrackerServerTCP(String _name, int _port, boolean _ssl, boolean _apply_ip_filter, boolean _start_up_ready) throws TRTrackerServerException {
        super(_name, _start_up_ready);
        this.port = _port;
        this.ssl = _ssl;
        this.apply_ip_filter = _apply_ip_filter;
        this.thread_pool = new ThreadPool("TrackerServer:TCP:" + this.port, THREAD_POOL_SIZE);
        if (PROCESSING_GET_LIMIT > 0L) {
            this.thread_pool.setExecutionLimit(PROCESSING_GET_LIMIT);
        }
    }

    public void runProcessor(TRTrackerServerProcessorTCP processor2) {
        this.thread_pool.run(processor2);
    }

    protected boolean isIPFilterEnabled() {
        return this.apply_ip_filter;
    }

    public boolean getRestrictNonBlocking() {
        return this.restrict_non_blocking_requests;
    }

    public void setRestrictNonBlocking(boolean restrict) {
        this.restrict_non_blocking_requests = restrict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkDOS(String ip) throws UnknownHostException {
        inet_address = InetAddress.getByName(ip);
        if (inet_address.isLoopbackAddress() != false) return false;
        if (InetAddress.getLocalHost().equals(inet_address)) {
            return false;
        }
        this.last_dos_check = SystemTime.getCurrentTime();
        entry = (DOSEntry)this.DOS_map.get(ip);
        if (entry == null) {
            entry = new DOSEntry(ip);
            this.DOS_map.put(ip, entry);
            res = false;
        } else {
            v0 = res = this.last_dos_check - entry.last_time < (long)this.DOS_MIN_INTERVAL;
            if (res && TRTrackerServerTCP.LOG_DOS_TO_FILE) {
                this.dos_list.add(entry);
            }
            entry.last_time = this.last_dos_check;
        }
        ++this.dos_check_count;
        if (this.dos_check_count != this.DOS_CHECK_DEAD_WOOD_COUNT) return res;
        this.dos_check_count = 0;
        it = this.DOS_map.values().iterator();
        while (it.hasNext()) {
            this_entry = (DOSEntry)it.next();
            if (this.last_dos_check - this_entry.last_time <= this.MAX_DOS_RETENTION) break;
            it.remove();
        }
        if (this.dos_list.size() <= 0) return res;
        try {
            block18: {
                TRTrackerServerTCP.class_mon.enter();
                if (TRTrackerServerTCP.dos_log_file == null) {
                    TRTrackerServerTCP.dos_log_file = new File(System.getProperty("user.dir") + File.separator + "dos.log");
                }
                pw = null;
                try {
                    try {
                        pw = new PrintWriter(new FileWriter(TRTrackerServerTCP.dos_log_file, true));
                        for (i = 0; i < this.dos_list.size(); ++i) {
                            this_entry = (DOSEntry)this.dos_list.get(i);
                            ts = new SimpleDateFormat("HH:mm:ss - ").format(new Date(this_entry.last_time));
                            pw.println(ts + this_entry.ip);
                        }
                        var11_11 = null;
                        this.dos_list.clear();
                        if (pw == null) break block18;
                    }
                    catch (Throwable e) {
                        var11_12 = null;
                        this.dos_list.clear();
                        if (pw != null) {
                            try {
                                pw.close();
                            }
                            catch (Throwable e) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable var10_17) {
                    var11_13 = null;
                    this.dos_list.clear();
                    if (pw == null) throw var10_17;
                    ** try [egrp 3[TRYBLOCK] [4 : 445->453)] { 
lbl61:
                    // 1 sources

                    pw.close();
                    throw var10_17;
lbl63:
                    // 1 sources

                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw var10_17;
                }
                try {}
                catch (Throwable e) {}
                pw.close();
            }
            var14_18 = null;
            TRTrackerServerTCP.class_mon.exit();
            return res;
        }
        catch (Throwable var13_20) {
            var14_19 = null;
            TRTrackerServerTCP.class_mon.exit();
            throw var13_20;
        }
    }

    protected boolean checkDOSRemove(Map.Entry eldest) {
        boolean res = (long)this.DOS_map.size() > this.MAX_DOS_ENTRIES || this.last_dos_check - ((DOSEntry)eldest.getValue()).last_time > this.MAX_DOS_RETENTION;
        return res;
    }

    public int getPort() {
        return this.port;
    }

    protected void setPort(int _port) {
        this.port = _port;
    }

    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    public boolean isSSL() {
        return this.ssl;
    }

    protected boolean handleExternalRequest(final TRTrackerServerProcessorTCP processor2, final InetSocketAddress local_address, final InetSocketAddress client_address, final String user, final String url, final URL absolute_url, final String header, final InputStream is, final OutputStream os, final AsyncController async, final boolean[] keep_alive) throws IOException {
        final boolean original_ka = keep_alive[0];
        keep_alive[0] = false;
        for (Object listener : this.listeners) {
            if (!listener.handleExternalRequest(client_address, user, url, absolute_url, header, is, os, async)) continue;
            return true;
        }
        for (Object listener : this.listeners2) {
            TRTrackerServerListener2.ExternalRequest request2;
            if (!listener.handleExternalRequest(request2 = new TRTrackerServerListener2.ExternalRequest(){

                public InetSocketAddress getClientAddress() {
                    return client_address;
                }

                public InetSocketAddress getLocalAddress() {
                    return local_address;
                }

                public String getUser() {
                    return user;
                }

                public String getURL() {
                    return url;
                }

                public URL getAbsoluteURL() {
                    return absolute_url;
                }

                public String getHeader() {
                    return header;
                }

                public InputStream getInputStream() {
                    return is;
                }

                public OutputStream getOutputStream() {
                    return os;
                }

                public AsyncController getAsyncController() {
                    return async;
                }

                public boolean canKeepAlive() {
                    return original_ka;
                }

                public void setKeepAlive(boolean ka) {
                    keep_alive[0] = original_ka && ka;
                }

                public boolean isActive() {
                    return processor2.isActive();
                }
            })) continue;
            return true;
        }
        return false;
    }

    static {
        if (THREAD_POOL_SIZE <= 0) {
            THREAD_POOL_SIZE = 1;
        }
        if (PROCESSING_GET_LIMIT < 0L) {
            PROCESSING_GET_LIMIT = 0L;
        }
        if (PROCESSING_POST_MULTIPLIER < 0) {
            PROCESSING_POST_MULTIPLIER = 0;
        }
        LOG_DOS_TO_FILE = false;
        LOG_DOS_TO_FILE = System.getProperty("azureus.log.dos") != null;
        class_mon = new AEMonitor("TRTrackerServerTCP:class");
    }

    protected class DOSEntry {
        String ip;
        long last_time;

        protected DOSEntry(String _ip) {
            this.ip = _ip;
            this.last_time = TRTrackerServerTCP.this.last_dos_check;
        }
    }
}

