/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.Debug;

public class AEJavaManagement {
    private static ThreadStuff thread_stuff;
    private static MemoryStuff memory_stuff;

    public static void initialise() {
        try {
            thread_stuff = (ThreadStuff)Class.forName("org.gudy.azureus2.core3.util.jman.AEThreadMonitor").newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            memory_stuff = (MemoryStuff)Class.forName("org.gudy.azureus2.core3.util.jman.AEMemoryMonitor").newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static long getThreadCPUTime() {
        if (thread_stuff == null) {
            return 0L;
        }
        return thread_stuff.getThreadCPUTime();
    }

    public static void dumpThreads() {
        if (thread_stuff == null) {
            return;
        }
        thread_stuff.dumpThreads();
    }

    public static long getMaxHeapMB() {
        if (memory_stuff == null) {
            return 0L;
        }
        return memory_stuff.getMaxHeapMB();
    }

    public static long getJVMLongOption(String[] options, String prefix) {
        long value = -1L;
        for (String option : options) {
            try {
                if (!option.startsWith(prefix)) continue;
                String val = option.substring(prefix.length());
                value = AEJavaManagement.decodeJVMLong(val);
            }
            catch (Throwable e) {
                Debug.out("Failed to process option '" + option + "'", e);
            }
        }
        return value;
    }

    public static String[] setJVMLongOption(String[] options, String prefix, long val) {
        String new_option = prefix + AEJavaManagement.encodeJVMLong(val);
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (!option.startsWith(prefix)) continue;
            options[i] = new_option;
            new_option = null;
        }
        if (new_option != null) {
            String[] new_options = new String[options.length + 1];
            System.arraycopy(options, 0, new_options, 0, options.length);
            new_options[options.length] = new_option;
            options = new_options;
        }
        return options;
    }

    public static long decodeJVMLong(String val) throws Exception {
        long mult = 1L;
        char last_char = Character.toLowerCase(val.charAt(val.length() - 1));
        if (!Character.isDigit(last_char)) {
            val = val.substring(0, val.length() - 1);
            if (last_char == 'k') {
                mult = 1024L;
            } else if (last_char == 'm') {
                mult = 0x100000L;
            } else if (last_char == 'g') {
                mult = 0x40000000L;
            } else {
                throw new Exception("Invalid size unit '" + last_char + "'");
            }
        }
        return Long.parseLong(val) * mult;
    }

    public static String encodeJVMLong(long val) {
        if (val < 1024L) {
            return String.valueOf(val);
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + "k";
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + "m";
        }
        return String.valueOf(val /= 1024L) + "g";
    }

    public static interface MemoryStuff {
        public long getMaxHeapMB();
    }

    public static interface ThreadStuff {
        public long getThreadCPUTime();

        public void dumpThreads();
    }
}

