/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.util.JSONUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncodingException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.LightHashMapEx;
import org.gudy.azureus2.core3.util.StringInterner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BDecoder {
    public static final int MAX_BYTE_ARRAY_SIZE = 0x6400000;
    private static final int MAX_MAP_KEY_SIZE = 65536;
    private static final boolean TRACE = false;
    private boolean recovery_mode;
    private boolean verify_map_order;
    private static final byte[] PORTABLE_ROOT;
    private ByteBuffer keyBytesBuffer = ByteBuffer.allocate(32);
    private CharBuffer keyCharsBuffer = CharBuffer.allocate(32);
    private CharsetDecoder keyDecoder = Constants.BYTE_CHARSET.newDecoder();
    private final char[] numberChars = new char[32];

    public static Map<String, Object> decode(byte[] data) throws IOException {
        return new BDecoder().decodeByteArray(data);
    }

    public static Map<String, Object> decode(byte[] data, int offset, int length) throws IOException {
        return new BDecoder().decodeByteArray(data, offset, length);
    }

    public static Map<String, Object> decode(BufferedInputStream is) throws IOException {
        return new BDecoder().decodeStream(is);
    }

    public Map<String, Object> decodeByteArray(byte[] data) throws IOException {
        return this.decode(new BDecoderInputStreamArray(data), true);
    }

    public Map<String, Object> decodeByteArray(byte[] data, int offset, int length) throws IOException {
        return this.decode(new BDecoderInputStreamArray(data, offset, length), true);
    }

    public Map<String, Object> decodeByteArray(byte[] data, int offset, int length, boolean internKeys) throws IOException {
        return this.decode(new BDecoderInputStreamArray(data, offset, length), internKeys);
    }

    public Map<String, Object> decodeByteBuffer(ByteBuffer buffer, boolean internKeys) throws IOException {
        BDecoderInputStreamArray is = new BDecoderInputStreamArray(buffer);
        Map<String, Object> result = this.decode(is, internKeys);
        buffer.position(buffer.limit() - ((InputStream)is).available());
        return result;
    }

    public Map<String, Object> decodeStream(BufferedInputStream data) throws IOException {
        return this.decodeStream(data, true);
    }

    public Map<String, Object> decodeStream(BufferedInputStream data, boolean internKeys) throws IOException {
        Object res = this.decodeInputStream(data, "", 0, internKeys);
        if (res == null) {
            throw new BEncodingException("BDecoder: zero length file");
        }
        if (!(res instanceof Map)) {
            throw new BEncodingException("BDecoder: top level isn't a Map");
        }
        return (Map)res;
    }

    private Map<String, Object> decode(InputStream data, boolean internKeys) throws IOException {
        Object res = this.decodeInputStream(data, "", 0, internKeys);
        if (res == null) {
            throw new BEncodingException("BDecoder: zero length file");
        }
        if (!(res instanceof Map)) {
            throw new BEncodingException("BDecoder: top level isn't a Map");
        }
        return (Map)res;
    }

    /*
     * Unable to fully structure code
     */
    private Object decodeInputStream(InputStream dbis, String context, int nesting, boolean internKeys) throws IOException {
        if (nesting == 0 && !dbis.markSupported()) {
            throw new IOException("InputStream must support the mark() method");
        }
        dbis.mark(1);
        tempByte = dbis.read();
        switch (tempByte) {
            case 100: {
                tempMap = new LightHashMap<S, T>();
                try {
                    prev_key = null;
                    while (true) {
                        dbis.mark(1);
                        tempByte = dbis.read();
                        if (tempByte == 101 || tempByte == -1) break;
                        dbis.reset();
                        keyLength = this.getPositiveNumberFromStream(dbis, ':');
                        skipBytes = 0;
                        if (keyLength > 65536) {
                            skipBytes = keyLength - 65536;
                            keyLength = 65536;
                        }
                        if (keyLength < this.keyBytesBuffer.capacity()) {
                            this.keyBytesBuffer.position(0).limit(keyLength);
                            this.keyCharsBuffer.position(0).limit(keyLength);
                        } else {
                            this.keyBytesBuffer = ByteBuffer.allocate(keyLength);
                            this.keyCharsBuffer = CharBuffer.allocate(keyLength);
                        }
                        this.getByteArrayFromStream(dbis, keyLength, this.keyBytesBuffer.array());
                        if (skipBytes > 0) {
                            dbis.skip(skipBytes);
                        }
                        if (this.verify_map_order) {
                            current_key = new byte[keyLength];
                            System.arraycopy(this.keyBytesBuffer.array(), 0, current_key, 0, keyLength);
                            if (prev_key != null) {
                                len = Math.min(prev_key.length, keyLength);
                                state = 0;
                                for (i = 0; i < len; ++i) {
                                    cb = current_key[i] & 255;
                                    pb = prev_key[i] & 255;
                                    if (cb > pb) {
                                        state = 1;
                                        break;
                                    }
                                    if (cb >= pb) continue;
                                    state = 2;
                                    break;
                                }
                                if (state == 0 && prev_key.length > keyLength) {
                                    state = 2;
                                }
                                if (state == 2 && !(tempMap instanceof LightHashMapEx)) {
                                    x = new LightHashMapEx<S, T>(tempMap);
                                    x.setFlag((byte)1, true);
                                    tempMap = x;
                                }
                            }
                            prev_key = current_key;
                        }
                        this.keyDecoder.reset();
                        this.keyDecoder.decode(this.keyBytesBuffer, this.keyCharsBuffer, true);
                        this.keyDecoder.flush(this.keyCharsBuffer);
                        key = new String(this.keyCharsBuffer.array(), 0, this.keyCharsBuffer.limit());
                        if (internKeys) {
                            key = StringInterner.intern(key);
                        }
                        if ((value = this.decodeInputStream(dbis, key, nesting + 1, internKeys)) == null) {
                            System.err.println("Invalid encoding - value not serialsied for '" + key + "' - ignoring: map so far=" + tempMap + ",loc=" + Debug.getCompressedStackTrace());
                            break;
                        }
                        if (skipBytes > 0) {
                            msg = "dictionary key is too large - " + (keyLength + skipBytes) + ":, max=" + 65536 + ": skipping key starting with " + new String(key.substring(0, 128));
                            System.err.println(msg);
                            continue;
                        }
                        if (tempMap.put(key, value) == null) continue;
                        Debug.out("BDecoder: key '" + key + "' already exists!");
                    }
                    dbis.mark(1);
                    tempByte = dbis.read();
                    dbis.reset();
                    if (nesting > 0 && tempByte == -1) {
                        throw new BEncodingException("BDecoder: invalid input data, 'e' missing from end of dictionary");
                    }
                }
                catch (Throwable e) {
                    if (this.recovery_mode) ** GOTO lbl84
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(Debug.getNestedExceptionMessage(e));
                }
lbl84:
                // 2 sources

                tempMap.compactify(-0.9f);
                return tempMap;
            }
            case 108: {
                tempList = new ArrayList<Object>();
                try {
                    context2 = BDecoder.PORTABLE_ROOT == null ? context : context + "[]";
                    tempElement = null;
                    while ((tempElement = this.decodeInputStream(dbis, context2, nesting + 1, internKeys)) != null) {
                        tempList.add(tempElement);
                    }
                    tempList.trimToSize();
                    dbis.mark(1);
                    tempByte = dbis.read();
                    dbis.reset();
                    if (nesting > 0 && tempByte == -1) {
                        throw new BEncodingException("BDecoder: invalid input data, 'e' missing from end of list");
                    }
                }
                catch (Throwable e) {
                    if (this.recovery_mode) ** GOTO lbl107
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(Debug.getNestedExceptionMessage(e));
                }
lbl107:
                // 2 sources

                return tempList;
            }
            case -1: 
            case 101: {
                return null;
            }
            case 105: {
                return this.getNumberFromStream(dbis, 'e');
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                dbis.reset();
                return this.getByteArrayFromStream(dbis, context);
            }
        }
        rem_len = dbis.available();
        if (rem_len > 256) {
            rem_len = 256;
        }
        rem_data = new byte[rem_len];
        dbis.read(rem_data);
        throw new BEncodingException("BDecoder: unknown command '" + tempByte + ", remainder = " + new String(rem_data));
    }

    private int getPositiveNumberFromStream(InputStream dbis, char parseChar) throws IOException {
        int tempByte = dbis.read();
        if (tempByte < 0) {
            return -1;
        }
        if (tempByte != parseChar) {
            int value = tempByte - 48;
            tempByte = dbis.read();
            if (tempByte == parseChar) {
                return value;
            }
            if (tempByte < 0) {
                return -1;
            }
            do {
                value = (value << 3) + (value << 1) + (tempByte - 48);
                tempByte = dbis.read();
                if (tempByte != parseChar) continue;
                return value;
            } while (tempByte >= 0);
            return -1;
        }
        return 0;
    }

    private long getNumberFromStream(InputStream dbis, char parseChar) throws IOException {
        int tempByte = dbis.read();
        int pos = 0;
        while (tempByte != parseChar && tempByte >= 0) {
            this.numberChars[pos++] = (char)tempByte;
            if (pos == this.numberChars.length) {
                throw new NumberFormatException("Number too large: " + new String(this.numberChars, 0, pos) + "...");
            }
            tempByte = dbis.read();
        }
        if (tempByte < 0) {
            return -1L;
        }
        if (pos == 0) {
            return 0L;
        }
        try {
            return BDecoder.parseLong(this.numberChars, 0, pos);
        }
        catch (NumberFormatException e) {
            String temp = new String(this.numberChars, 0, pos);
            try {
                double d = Double.parseDouble(temp);
                long l = (long)d;
                Debug.out("Invalid number '" + temp + "' - decoding as " + l + " and attempting recovery");
                return l;
            }
            catch (Throwable f) {
                throw e;
            }
        }
    }

    public static long parseLong(char[] chars, int start, int length) {
        if (length > 0) {
            long limit;
            if (chars[start] == '0') {
                return 0L;
            }
            long result = 0L;
            boolean negative = false;
            int i = start;
            if (chars[i] == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                if (length == 1) {
                    int digit = chars[i] - 48;
                    if (digit < 0 || digit > 9) {
                        throw new NumberFormatException(new String(chars, start, length));
                    }
                    return digit;
                }
                limit = -9223372036854775807L;
            }
            int max = start + length;
            if (i < max) {
                int digit;
                if ((digit = chars[i++] - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                result = -digit;
            }
            long multmin = limit / 10L;
            while (i < max) {
                int digit;
                if ((digit = chars[i++] - 48) < 0 || digit > 9) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                if (result < multmin) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException(new String(chars, start, length));
                }
                result -= (long)digit;
            }
            if (negative) {
                if (i > start + 1) {
                    return result;
                }
                throw new NumberFormatException(new String(chars, start, length));
            }
            return -result;
        }
        throw new NumberFormatException(new String(chars, start, length));
    }

    private byte[] getByteArrayFromStream(InputStream dbis, String context2) throws IOException {
        int length = this.getPositiveNumberFromStream(dbis, ':');
        if (length < 0) {
            return null;
        }
        if (length > 0x6400000) {
            throw new IOException("Byte array length too large (" + length + ")");
        }
        byte[] tempArray = new byte[length];
        this.getByteArrayFromStream(dbis, length, tempArray);
        if (PORTABLE_ROOT != null && length >= PORTABLE_ROOT.length && tempArray[1] == 58 && tempArray[2] == 92 && context2 != null) {
            boolean mismatch = false;
            for (int i = 2; i < PORTABLE_ROOT.length; ++i) {
                if (tempArray[i] == PORTABLE_ROOT[i]) continue;
                mismatch = true;
                break;
            }
            if (!mismatch) {
                if ((context2 = context2.toLowerCase(Locale.US)).contains("file") || context2.contains("link") || context2.contains("dir") || context2.contains("folder") || context2.contains("path") || context2.contains("save") || context2.contains("torrent")) {
                    tempArray[0] = PORTABLE_ROOT[0];
                } else {
                    String test = new String(tempArray, 0, tempArray.length > 80 ? 80 : tempArray.length);
                    System.out.println("Portable: not mapping " + context2 + "->" + tempArray.length + ": " + test);
                }
            }
        }
        return tempArray;
    }

    private void getByteArrayFromStream(InputStream dbis, int length, byte[] targetArray) throws IOException {
        int count;
        int len = 0;
        for (count = 0; count != length && (len = dbis.read(targetArray, count, length - count)) > 0; count += len) {
        }
        if (count != length) {
            throw new IOException("BDecoder::getByteArrayFromStream: truncated");
        }
    }

    public void setVerifyMapOrder(boolean b) {
        this.verify_map_order = b;
    }

    public void setRecoveryMode(boolean r) {
        this.recovery_mode = r;
    }

    public static void print(Object obj) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        BDecoder.print(pw, obj);
        pw.flush();
        System.out.println(sw.toString());
    }

    public static void print(PrintWriter writer, Object obj) {
        BDecoder.print(writer, obj, "", false);
    }

    private static void print(PrintWriter writer, Object obj, String indent, boolean skip_indent) {
        String use_indent;
        String string = use_indent = skip_indent ? "" : indent;
        if (obj instanceof Long) {
            writer.println(use_indent + obj);
        } else if (obj instanceof byte[]) {
            byte[] b = (byte[])obj;
            if (b.length == 20) {
                writer.println(use_indent + " { " + ByteFormatter.nicePrint(b) + " }");
            } else if (b.length < 64) {
                writer.println(new String(b) + " [" + ByteFormatter.encodeString(b) + "]");
            } else {
                writer.println("[byte array length " + b.length);
            }
        } else if (obj instanceof String) {
            writer.println(use_indent + obj);
        } else if (obj instanceof List) {
            List l = (List)obj;
            writer.println(use_indent + "[");
            for (int i = 0; i < l.size(); ++i) {
                writer.print(indent + "  (" + i + ") ");
                BDecoder.print(writer, l.get(i), indent + "    ", true);
            }
            writer.println(indent + "]");
        } else {
            Map m = (Map)obj;
            for (String key : m.keySet()) {
                if (key.length() > 256) {
                    writer.print(indent + key.substring(0, 256) + "... = ");
                } else {
                    writer.print(indent + key + " = ");
                }
                BDecoder.print(writer, m.get(key), indent + "  ", true);
            }
        }
    }

    public static Map decodeStrings(Map map) {
        if (map == null) {
            return null;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof byte[]) {
                try {
                    entry.setValue(new String((byte[])value, "UTF-8"));
                }
                catch (Throwable e) {
                    System.err.println(e);
                }
                continue;
            }
            if (value instanceof Map) {
                BDecoder.decodeStrings((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            BDecoder.decodeStrings((List)value);
        }
        return map;
    }

    public static List decodeStrings(List list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (value instanceof byte[]) {
                try {
                    String str = new String((byte[])value, "UTF-8");
                    list.set(i, str);
                }
                catch (Throwable e) {
                    System.err.println(e);
                }
                continue;
            }
            if (value instanceof Map) {
                BDecoder.decodeStrings((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            BDecoder.decodeStrings((List)value);
        }
        return list;
    }

    private static void print(File f, File output) {
        try {
            BDecoder decoder = new BDecoder();
            decoder.setRecoveryMode(false);
            PrintWriter pw = new PrintWriter(new FileWriter(output));
            BDecoder.print(pw, decoder.decodeStream(new BufferedInputStream(new FileInputStream(f))));
            pw.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static Object decodeFromJSONGeneric(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return BDecoder.decodeFromJSONObject((Map)obj);
        }
        if (obj instanceof List) {
            return BDecoder.decodeFromJSONArray((List)obj);
        }
        if (obj instanceof String) {
            String s = (String)obj;
            try {
                int len = s.length();
                if (len >= 6 && s.startsWith("\\x") && s.endsWith("\\x")) {
                    byte[] result = new byte[(len - 4) / 2];
                    int pos = 2;
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = (byte)Integer.parseInt(s.substring(pos, pos + 2), 16);
                        pos += 2;
                    }
                    return result;
                }
                return s.getBytes("UTF-8");
            }
            catch (Throwable e) {
                return s.getBytes();
            }
        }
        if (obj instanceof Long) {
            return obj;
        }
        if (obj instanceof Boolean) {
            return new Long((Boolean)obj != false ? 1L : 0L);
        }
        if (obj instanceof Double) {
            return String.valueOf((Double)obj);
        }
        System.err.println("Unexpected JSON value type: " + obj.getClass());
        return obj;
    }

    public static List decodeFromJSONArray(List j_list) {
        ArrayList<Object> b_list = new ArrayList<Object>();
        for (Object o : j_list) {
            b_list.add(BDecoder.decodeFromJSONGeneric(o));
        }
        return b_list;
    }

    public static Map decodeFromJSONObject(Map<Object, Object> j_map) {
        HashMap<String, Object> b_map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : j_map.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            b_map.put((String)key, BDecoder.decodeFromJSONGeneric(val));
        }
        return b_map;
    }

    public static Map decodeFromJSON(String json) {
        Map j_map = JSONUtils.decodeJSON(json);
        return BDecoder.decodeFromJSONObject(j_map);
    }

    public static void main(String[] args) {
        BDecoder.print(new File("C:\\Temp\\tables.config"), new File("C:\\Temp\\tables.txt"));
    }

    static {
        byte[] portable = null;
        try {
            String root = System.getProperty("azureus.portable.root", "");
            if (root.length() > 0) {
                portable = root.getBytes("UTF-8");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        PORTABLE_ROOT = portable;
    }

    private static class BDecoderInputStreamArray
    extends InputStream {
        private final byte[] bytes;
        private int pos = 0;
        private int markPos;
        private int overPos;

        public BDecoderInputStreamArray(ByteBuffer buffer) {
            this.bytes = buffer.array();
            this.pos = buffer.arrayOffset() + buffer.position();
            this.overPos = this.pos + buffer.remaining();
        }

        private BDecoderInputStreamArray(byte[] _buffer) {
            this.bytes = _buffer;
            this.overPos = this.bytes.length;
        }

        private BDecoderInputStreamArray(byte[] _buffer, int _offset, int _length) {
            if (_offset == 0) {
                this.bytes = _buffer;
                this.overPos = _length;
            } else {
                this.bytes = _buffer;
                this.pos = _offset;
                this.overPos = Math.min(_offset + _length, this.bytes.length);
            }
        }

        public int read() throws IOException {
            if (this.pos < this.overPos) {
                return this.bytes[this.pos++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            if (this.pos < this.overPos) {
                int toRead = Math.min(length, this.overPos - this.pos);
                System.arraycopy(this.bytes, this.pos, b, offset, toRead);
                this.pos += toRead;
                return toRead;
            }
            return -1;
        }

        public int available() throws IOException {
            return this.overPos - this.pos;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int limit) {
            this.markPos = this.pos;
        }

        public void reset() throws IOException {
            this.pos = this.markPos;
        }
    }
}

