/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class DisplayFormatters {
    private static final boolean ROUND_NO = true;
    private static final boolean TRUNCZEROS_NO = false;
    private static final boolean TRUNCZEROS_YES = true;
    public static final int UNIT_B = 0;
    public static final int UNIT_KB = 1;
    public static final int UNIT_MB = 2;
    public static final int UNIT_GB = 3;
    public static final int UNIT_TB = 4;
    private static final int[] UNITS_PRECISION = new int[]{0, 1, 2, 2, 3};
    private static final NumberFormat[] cached_number_formats = new NumberFormat[20];
    private static NumberFormat percentage_format;
    private static final String[] all_units;
    private static String[] units;
    private static String[] units_bits;
    private static String[] units_rate;
    private static int unitsStopAt;
    private static String[] units_base10;
    private static String per_sec;
    private static boolean use_si_units;
    private static boolean force_si_values;
    private static boolean use_units_rate_bits;
    private static boolean not_use_GB_TB;
    private static int message_text_state;
    private static boolean separate_prot_data_stats;
    private static boolean data_stats_only;
    private static char decimalSeparator;
    private static volatile Map<String, Formatter> format_map;
    private static String PeerManager_status_finished;
    private static String PeerManager_status_finishedin;
    private static String Formats_units_alot;
    private static String discarded;
    private static String ManagerItem_waiting;
    private static String ManagerItem_initializing;
    private static String ManagerItem_allocating;
    private static String ManagerItem_checking;
    private static String ManagerItem_finishing;
    private static String ManagerItem_ready;
    private static String ManagerItem_downloading;
    private static String ManagerItem_swarmMerge;
    private static String ManagerItem_seeding;
    private static String ManagerItem_superseeding;
    private static String ManagerItem_stopping;
    private static String ManagerItem_stopped;
    private static String ManagerItem_paused;
    private static String ManagerItem_queued;
    private static String ManagerItem_error;
    private static String ManagerItem_forced;
    private static String ManagerItem_moving;
    private static String yes;
    private static String no;
    private static final SimpleDateFormat abs_df;

    public static void setUnits() {
        units = new String[unitsStopAt + 1];
        units_bits = new String[unitsStopAt + 1];
        units_rate = new String[unitsStopAt + 1];
        if (use_si_units) {
            DisplayFormatters.all_units[4] = DisplayFormatters.getUnit("TiB");
            DisplayFormatters.all_units[3] = DisplayFormatters.getUnit("GiB");
            DisplayFormatters.all_units[2] = DisplayFormatters.getUnit("MiB");
            DisplayFormatters.all_units[1] = DisplayFormatters.getUnit("KiB");
            DisplayFormatters.all_units[0] = DisplayFormatters.getUnit("B");
            switch (unitsStopAt) {
                case 4: {
                    DisplayFormatters.units[4] = all_units[4];
                    DisplayFormatters.units_bits[4] = DisplayFormatters.getUnit("Tibit");
                    DisplayFormatters.units_rate[4] = use_units_rate_bits ? DisplayFormatters.getUnit("Tibit") : DisplayFormatters.getUnit("TiB");
                }
                case 3: {
                    DisplayFormatters.units[3] = all_units[3];
                    DisplayFormatters.units_bits[3] = DisplayFormatters.getUnit("Gibit");
                    DisplayFormatters.units_rate[3] = use_units_rate_bits ? DisplayFormatters.getUnit("Gibit") : DisplayFormatters.getUnit("GiB");
                }
                case 2: {
                    DisplayFormatters.units[2] = all_units[2];
                    DisplayFormatters.units_bits[2] = DisplayFormatters.getUnit("Mibit");
                    DisplayFormatters.units_rate[2] = use_units_rate_bits ? DisplayFormatters.getUnit("Mibit") : DisplayFormatters.getUnit("MiB");
                }
                case 1: {
                    DisplayFormatters.units[1] = all_units[1];
                    DisplayFormatters.units_bits[1] = DisplayFormatters.getUnit("Kibit");
                    DisplayFormatters.units_rate[1] = use_units_rate_bits ? DisplayFormatters.getUnit("Kibit") : DisplayFormatters.getUnit("KiB");
                }
                case 0: {
                    DisplayFormatters.units[0] = all_units[0];
                    DisplayFormatters.units_bits[0] = DisplayFormatters.getUnit("bit");
                    DisplayFormatters.units_rate[0] = use_units_rate_bits ? DisplayFormatters.getUnit("bit") : DisplayFormatters.getUnit("B");
                }
            }
        } else {
            DisplayFormatters.all_units[4] = DisplayFormatters.getUnit("TB");
            DisplayFormatters.all_units[3] = DisplayFormatters.getUnit("GB");
            DisplayFormatters.all_units[2] = DisplayFormatters.getUnit("MB");
            DisplayFormatters.all_units[1] = DisplayFormatters.getUnit("kB");
            DisplayFormatters.all_units[0] = DisplayFormatters.getUnit("B");
            switch (unitsStopAt) {
                case 4: {
                    DisplayFormatters.units[4] = all_units[4];
                    DisplayFormatters.units_bits[4] = DisplayFormatters.getUnit("Tbit");
                    DisplayFormatters.units_rate[4] = use_units_rate_bits ? DisplayFormatters.getUnit("Tbit") : DisplayFormatters.getUnit("TB");
                }
                case 3: {
                    DisplayFormatters.units[3] = all_units[3];
                    DisplayFormatters.units_bits[3] = DisplayFormatters.getUnit("Gbit");
                    DisplayFormatters.units_rate[3] = use_units_rate_bits ? DisplayFormatters.getUnit("Gbit") : DisplayFormatters.getUnit("GB");
                }
                case 2: {
                    DisplayFormatters.units[2] = all_units[2];
                    DisplayFormatters.units_bits[2] = DisplayFormatters.getUnit("Mbit");
                    DisplayFormatters.units_rate[2] = use_units_rate_bits ? DisplayFormatters.getUnit("Mbit") : DisplayFormatters.getUnit("MB");
                }
                case 1: {
                    DisplayFormatters.units[1] = all_units[1];
                    DisplayFormatters.units_bits[1] = DisplayFormatters.getUnit("kbit");
                    DisplayFormatters.units_rate[1] = use_units_rate_bits ? DisplayFormatters.getUnit("kbit") : DisplayFormatters.getUnit("kB");
                }
                case 0: {
                    DisplayFormatters.units[0] = all_units[0];
                    DisplayFormatters.units_bits[0] = DisplayFormatters.getUnit("bit");
                    DisplayFormatters.units_rate[0] = use_units_rate_bits ? DisplayFormatters.getUnit("bit") : DisplayFormatters.getUnit("B");
                }
            }
        }
        per_sec = DisplayFormatters.getResourceString("Formats.units.persec", "/s");
        units_base10 = new String[]{DisplayFormatters.getUnit(use_units_rate_bits ? "bit" : "B"), DisplayFormatters.getUnit(use_units_rate_bits ? "kbit" : "KB"), DisplayFormatters.getUnit(use_units_rate_bits ? "Mbit" : "MB"), DisplayFormatters.getUnit(use_units_rate_bits ? "Gbit" : "GB"), DisplayFormatters.getUnit(use_units_rate_bits ? "Tbit" : "TB")};
        for (int i = 0; i <= unitsStopAt; ++i) {
            DisplayFormatters.units[i] = units[i];
            DisplayFormatters.units_rate[i] = units_rate[i] + per_sec;
        }
        Arrays.fill(cached_number_formats, null);
        percentage_format = NumberFormat.getPercentInstance();
        percentage_format.setMinimumFractionDigits(1);
        percentage_format.setMaximumFractionDigits(1);
        decimalSeparator = new DecimalFormatSymbols().getDecimalSeparator();
    }

    private static String getUnit(String key) {
        String res = " " + DisplayFormatters.getResourceString("Formats.units." + key, key);
        return res;
    }

    public static void loadMessages() {
        PeerManager_status_finished = DisplayFormatters.getResourceString("PeerManager.status.finished", "Finished");
        PeerManager_status_finishedin = DisplayFormatters.getResourceString("PeerManager.status.finishedin", "Finished in");
        Formats_units_alot = DisplayFormatters.getResourceString("Formats.units.alot", "A lot");
        discarded = DisplayFormatters.getResourceString("discarded", "discarded");
        ManagerItem_waiting = DisplayFormatters.getResourceString("ManagerItem.waiting", "waiting");
        ManagerItem_initializing = DisplayFormatters.getResourceString("ManagerItem.initializing", "initializing");
        ManagerItem_allocating = DisplayFormatters.getResourceString("ManagerItem.allocating", "allocating");
        ManagerItem_checking = DisplayFormatters.getResourceString("ManagerItem.checking", "checking");
        ManagerItem_finishing = DisplayFormatters.getResourceString("ManagerItem.finishing", "finishing");
        ManagerItem_ready = DisplayFormatters.getResourceString("ManagerItem.ready", "ready");
        ManagerItem_downloading = DisplayFormatters.getResourceString("ManagerItem.downloading", "downloading");
        ManagerItem_swarmMerge = DisplayFormatters.getResourceString("TableColumn.header.mergeddata", "swarm merge");
        ManagerItem_seeding = DisplayFormatters.getResourceString("ManagerItem.seeding", "seeding");
        ManagerItem_superseeding = DisplayFormatters.getResourceString("ManagerItem.superseeding", "superseeding");
        ManagerItem_stopping = DisplayFormatters.getResourceString("ManagerItem.stopping", "stopping");
        ManagerItem_stopped = DisplayFormatters.getResourceString("ManagerItem.stopped", "stopped");
        ManagerItem_paused = DisplayFormatters.getResourceString("ManagerItem.paused", "paused");
        ManagerItem_queued = DisplayFormatters.getResourceString("ManagerItem.queued", "queued");
        ManagerItem_error = DisplayFormatters.getResourceString("ManagerItem.error", "error");
        ManagerItem_forced = DisplayFormatters.getResourceString("ManagerItem.forced", "forced");
        ManagerItem_moving = DisplayFormatters.getResourceString("ManagerItem.moving", "moving");
        yes = DisplayFormatters.getResourceString("GeneralView.yes", "Yes");
        no = DisplayFormatters.getResourceString("GeneralView.no", "No");
    }

    private static String getResourceString(String key, String def) {
        if (message_text_state == 0) {
            try {
                MessageText.class.getName();
                message_text_state = 1;
            }
            catch (Throwable e) {
                message_text_state = 2;
            }
        }
        if (message_text_state == 1) {
            return MessageText.getString(key);
        }
        return def;
    }

    public static String getYesNo(boolean b) {
        return b ? yes : no;
    }

    public static String getRateUnit(int unit_size) {
        return units_rate[unit_size].substring(1, units_rate[unit_size].length());
    }

    public static String getUnit(int unit_size) {
        return units[unit_size].substring(1, units[unit_size].length());
    }

    public static String getRateUnitBase10(int unit_size) {
        return units_base10[unit_size] + per_sec;
    }

    public static String getUnitBase10(int unit_size) {
        return units_base10[unit_size];
    }

    public static boolean isRateUsingBits() {
        return use_units_rate_bits;
    }

    public static String formatByteCountToKiBEtc(int n) {
        return DisplayFormatters.formatByteCountToKiBEtc((long)n);
    }

    public static String formatByteCountToKiBEtc(long n) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, false, false);
    }

    public static String formatByteCountToKiBEtc(long n, boolean bTruncateZeros) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, false, bTruncateZeros);
    }

    public static String formatByteCountToKiBEtc(long n, boolean rate, boolean bTruncateZeros) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, rate, bTruncateZeros, -1);
    }

    public static int getKinB() {
        return force_si_values ? 1024 : (use_si_units ? 1024 : 1000);
    }

    public static String formatByteCountToKiBEtc(long n, boolean rate, boolean bTruncateZeros, int precision) {
        int unitIndex;
        long div;
        double dbl = rate && use_units_rate_bits ? (double)(n * 8L) : (double)n;
        long l = force_si_values ? 1024L : (div = (long)(use_si_units ? 1024 : 1000));
        for (unitIndex = 0; dbl >= (double)div && unitIndex < unitsStopAt; dbl /= (double)div, ++unitIndex) {
        }
        if (precision < 0) {
            precision = UNITS_PRECISION[unitIndex];
        }
        return DisplayFormatters.formatDecimal(dbl, precision, bTruncateZeros, rate) + (rate ? units_rate[unitIndex] : units[unitIndex]);
    }

    public static String formatByteCountToKiBEtc(long n, boolean rate, boolean bTruncateZeros, int precision, int minUnit) {
        int unitIndex;
        long div;
        double dbl = rate && use_units_rate_bits ? (double)(n * 8L) : (double)n;
        long l = force_si_values ? 1024L : (div = (long)(use_si_units ? 1024 : 1000));
        for (unitIndex = 0; dbl >= (double)div && unitIndex < unitsStopAt; dbl /= (double)div, ++unitIndex) {
        }
        while (unitIndex < minUnit) {
            dbl /= (double)div;
            ++unitIndex;
        }
        if (precision < 0) {
            precision = UNITS_PRECISION[unitIndex];
        }
        return DisplayFormatters.formatDecimal(dbl, precision, bTruncateZeros, rate) + (rate ? units_rate[unitIndex] : units[unitIndex]);
    }

    public static boolean isDataProtSeparate() {
        return separate_prot_data_stats;
    }

    public static String formatDataProtByteCountToKiBEtc(long data, long prot) {
        if (separate_prot_data_stats) {
            if (data == 0L && prot == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtc(0);
            }
            if (data == 0L) {
                return "(" + DisplayFormatters.formatByteCountToKiBEtc(prot) + ")";
            }
            if (prot == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtc(data);
            }
            return DisplayFormatters.formatByteCountToKiBEtc(data) + " (" + DisplayFormatters.formatByteCountToKiBEtc(prot) + ")";
        }
        if (data_stats_only) {
            return DisplayFormatters.formatByteCountToKiBEtc(data);
        }
        return DisplayFormatters.formatByteCountToKiBEtc(prot + data);
    }

    public static String formatDataProtByteCountToKiBEtcPerSec(long data, long prot) {
        if (separate_prot_data_stats) {
            if (data == 0L && prot == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(0L);
            }
            if (data == 0L) {
                return "(" + DisplayFormatters.formatByteCountToKiBEtcPerSec(prot) + ")";
            }
            if (prot == 0L) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(data);
            }
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(data) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(prot) + ")";
        }
        if (data_stats_only) {
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(data);
        }
        return DisplayFormatters.formatByteCountToKiBEtcPerSec(prot + data);
    }

    public static String formatByteCountToKiBEtcPerSec(long n) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, true, false);
    }

    public static String formatByteCountToKiBEtcPerSec(long n, boolean bTruncateZeros) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, true, bTruncateZeros);
    }

    public static String formatByteCountToBase10KBEtc(long n) {
        if (use_units_rate_bits) {
            n *= 8L;
        }
        if (n < 1000L) {
            return n + units_base10[0];
        }
        if (n < 1000000L) {
            return n / 1000L + "." + n % 1000L / 100L + units_base10[1];
        }
        if (n < 1000000000L || not_use_GB_TB) {
            return n / 1000000L + "." + n % 1000000L / 100000L + units_base10[2];
        }
        if (n < 1000000000000L) {
            return n / 1000000000L + "." + n % 1000000000L / 100000000L + units_base10[3];
        }
        if (n < 1000000000000000L) {
            return n / 1000000000000L + "." + n % 1000000000000L / 100000000000L + units_base10[4];
        }
        return Formats_units_alot;
    }

    public static String formatByteCountToBase10KBEtcPerSec(long n) {
        return DisplayFormatters.formatByteCountToBase10KBEtc(n) + per_sec;
    }

    public static String formatByteCountToBitsPerSec(long n) {
        int unitIndex;
        double dbl = n * 8L;
        long div = 1000L;
        for (unitIndex = 0; dbl >= (double)div && unitIndex < unitsStopAt; dbl /= (double)div, ++unitIndex) {
        }
        int precision = UNITS_PRECISION[unitIndex];
        return DisplayFormatters.formatDecimal(dbl, precision, true, true) + units_bits[unitIndex] + per_sec;
    }

    public static String formatETA(long eta) {
        return DisplayFormatters.formatETA(eta, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatETA(long eta, boolean abs) {
        if (eta == 0L) {
            return PeerManager_status_finished;
        }
        if (eta == -1L) {
            return "";
        }
        if (eta > 0L) {
            if (abs && eta != 31536000L && eta < 1827387392L) {
                int len;
                String str2;
                String str1;
                long now = SystemTime.getCurrentTime();
                long then = now + eta * 1000L;
                if (eta > 300L) {
                    then = then / 60000L * 60000L;
                }
                SimpleDateFormat simpleDateFormat = abs_df;
                synchronized (simpleDateFormat) {
                    str1 = abs_df.format(new Date(now));
                    str2 = abs_df.format(new Date(then));
                }
                int diff_at = len = Math.min(str1.length(), str2.length()) - 2;
                for (int i = 0; i < len; ++i) {
                    char c1 = str1.charAt(i);
                    if (c1 == str2.charAt(i)) continue;
                    diff_at = i;
                    break;
                }
                String res = diff_at >= 11 ? str2.substring(11) : (diff_at >= 5 ? str2.substring(5) : str2);
                return res;
            }
            return TimeFormatter.format(eta);
        }
        return PeerManager_status_finishedin + " " + TimeFormatter.format(eta * -1L);
    }

    public static String formatDownloaded(DownloadManagerStats stats2) {
        long total_discarded = stats2.getDiscarded();
        long total_received = stats2.getTotalGoodDataBytesReceived();
        if (total_discarded == 0L) {
            return DisplayFormatters.formatByteCountToKiBEtc(total_received);
        }
        return DisplayFormatters.formatByteCountToKiBEtc(total_received) + " ( " + DisplayFormatters.formatByteCountToKiBEtc(total_discarded) + " " + discarded + " )";
    }

    public static String formatHashFails(DownloadManager download_manager) {
        TOTorrent torrent = download_manager.getTorrent();
        if (torrent != null) {
            long bad = download_manager.getStats().getHashFailBytes();
            long count = bad / torrent.getPieceLength();
            String result = count + " ( " + DisplayFormatters.formatByteCountToKiBEtc(bad) + " )";
            return result;
        }
        return "";
    }

    public static String formatDownloadStatus(DownloadManager manager) {
        if (manager == null) {
            return ManagerItem_error + ": Download is null";
        }
        int state = manager.getState();
        String tmp = "";
        switch (state) {
            case 75: {
                tmp = ManagerItem_queued;
                break;
            }
            case 50: {
                tmp = ManagerItem_downloading;
                if (manager.isSwarmMerging() == null) break;
                tmp = tmp + " + " + ManagerItem_swarmMerge;
                break;
            }
            case 60: {
                DiskManager diskManager = manager.getDiskManager();
                if (diskManager != null) {
                    int mp = diskManager.getMoveProgress();
                    if (mp != -1) {
                        tmp = ManagerItem_moving + ": " + DisplayFormatters.formatPercentFromThousands(mp);
                    } else {
                        int done = diskManager.getCompleteRecheckStatus();
                        if (done != -1) {
                            tmp = ManagerItem_seeding + " + " + ManagerItem_checking + ": " + DisplayFormatters.formatPercentFromThousands(done);
                        }
                    }
                }
                if (tmp != "") break;
                if (manager.getPeerManager() != null && manager.getPeerManager().isSuperSeedMode()) {
                    tmp = ManagerItem_superseeding;
                    break;
                }
                tmp = ManagerItem_seeding;
                break;
            }
            case 70: {
                tmp = manager.isPaused() ? ManagerItem_paused : ManagerItem_stopped;
                break;
            }
            case 100: {
                tmp = ManagerItem_error + ": " + manager.getErrorDetails();
                break;
            }
            case 0: {
                tmp = ManagerItem_waiting;
                break;
            }
            case 5: {
                tmp = ManagerItem_initializing;
                break;
            }
            case 10: {
                tmp = ManagerItem_initializing;
                break;
            }
            case 20: {
                tmp = ManagerItem_allocating;
                DiskManager diskManager = manager.getDiskManager();
                if (diskManager == null) break;
                tmp = tmp + ": " + DisplayFormatters.formatPercentFromThousands(diskManager.getPercentDone());
                break;
            }
            case 30: {
                tmp = ManagerItem_checking + ": " + DisplayFormatters.formatPercentFromThousands(manager.getStats().getCompleted());
                break;
            }
            case 55: {
                tmp = ManagerItem_finishing;
                break;
            }
            case 40: {
                tmp = ManagerItem_ready;
                break;
            }
            case 65: {
                tmp = ManagerItem_stopping;
                break;
            }
            default: {
                tmp = String.valueOf(state);
            }
        }
        if (manager.isForceStart() && (state == 60 || state == 50)) {
            tmp = ManagerItem_forced + " " + tmp;
        }
        return tmp;
    }

    public static String formatDownloadStatusDefaultLocale(DownloadManager manager) {
        int state = manager.getState();
        String tmp = "";
        DiskManager dm = manager.getDiskManager();
        switch (state) {
            case 0: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.waiting");
                break;
            }
            case 5: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.initializing");
                break;
            }
            case 10: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.initializing");
                break;
            }
            case 20: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.allocating");
                break;
            }
            case 30: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.checking");
                break;
            }
            case 55: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.finishing");
                break;
            }
            case 40: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.ready");
                break;
            }
            case 50: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.downloading");
                if (manager.isSwarmMerging() == null) break;
                tmp = tmp + " + " + MessageText.getDefaultLocaleString("TableColumn.header.mergeddata");
                break;
            }
            case 60: {
                if (dm != null && dm.getCompleteRecheckStatus() != -1) {
                    int done = dm.getCompleteRecheckStatus();
                    if (done == -1) {
                        done = 1000;
                    }
                    tmp = MessageText.getDefaultLocaleString("ManagerItem.seeding") + " + " + MessageText.getDefaultLocaleString("ManagerItem.checking") + ": " + DisplayFormatters.formatPercentFromThousands(done);
                    break;
                }
                if (manager.getPeerManager() != null && manager.getPeerManager().isSuperSeedMode()) {
                    tmp = MessageText.getDefaultLocaleString("ManagerItem.superseeding");
                    break;
                }
                tmp = MessageText.getDefaultLocaleString("ManagerItem.seeding");
                break;
            }
            case 65: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.stopping");
                break;
            }
            case 70: {
                tmp = MessageText.getDefaultLocaleString(manager.isPaused() ? "ManagerItem.paused" : "ManagerItem.stopped");
                break;
            }
            case 75: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.queued");
                break;
            }
            case 100: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.error").concat(": ").concat(manager.getErrorDetails());
                break;
            }
            default: {
                tmp = String.valueOf(state);
            }
        }
        return tmp;
    }

    public static String trimDigits(String str, int num_digits) {
        char[] chars = str.toCharArray();
        String res = "";
        int digits = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isDigit(c)) {
                if (++digits > num_digits) continue;
                res = res + c;
                continue;
            }
            if (c == '.' && digits >= 3) continue;
            res = res + c;
        }
        return res;
    }

    public static String formatPercentFromThousands(int thousands) {
        return percentage_format.format((double)thousands / 1000.0);
    }

    public static String formatTimeStamp(long time) {
        StringBuffer sb = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        sb.append('[');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(5)));
        sb.append('.');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(2) + 1));
        sb.append('.');
        sb.append(calendar.get(1));
        sb.append(' ');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(11)));
        sb.append(':');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(12)));
        sb.append(':');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(13)));
        sb.append(']');
        return sb.toString();
    }

    public static String formatIntToTwoDigits(int n) {
        return n < 10 ? "0".concat(String.valueOf(n)) : String.valueOf(n);
    }

    private static String formatDate(long date, String format) {
        if (date == 0L) {
            return "";
        }
        SimpleDateFormat temp = new SimpleDateFormat(format);
        return temp.format(new Date(date));
    }

    public static String formatDate(long date) {
        return DisplayFormatters.formatDate(date, "dd-MMM-yyyy HH:mm:ss");
    }

    public static String formatDateShort(long date) {
        return DisplayFormatters.formatDate(date, "MMM dd, HH:mm");
    }

    public static String formatDateNum(long date) {
        return DisplayFormatters.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatCustomDateOnly(long date) {
        if (date == 0L) {
            return "";
        }
        return DisplayFormatters.formatDate(date, "dd-MMM-yyyy");
    }

    public static String formatCustomTimeOnly(long date) {
        return DisplayFormatters.formatCustomTimeOnly(date, true);
    }

    public static String formatCustomTimeOnly(long date, boolean with_secs) {
        if (date == 0L) {
            return "";
        }
        return DisplayFormatters.formatDate(date, with_secs ? "HH:mm:ss" : "HH:mm");
    }

    public static String formatCustomDateTime(long date) {
        if (date == 0L) {
            return "";
        }
        return DisplayFormatters.formatDate(date);
    }

    public static String formatTime(long time) {
        return TimeFormatter.formatColon(time / 1000L);
    }

    public static String formatDecimal(double value, int precision) {
        return DisplayFormatters.formatDecimal(value, precision, false, true);
    }

    public static String formatDecimal(double value, int precision, boolean bTruncateZeros, boolean bRound) {
        double tValue;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return "\u221e";
        }
        if (bRound) {
            tValue = value;
        } else if (precision == 0) {
            tValue = (long)value;
        } else {
            double shift = Math.pow(10.0, precision);
            tValue = (double)((long)(value * shift)) / shift;
        }
        int cache_index = (precision << 2) + ((bTruncateZeros ? 1 : 0) << 1) + (bRound ? 1 : 0);
        NumberFormat nf = null;
        if (cache_index < cached_number_formats.length) {
            nf = cached_number_formats[cache_index];
        }
        if (nf == null) {
            nf = NumberFormat.getNumberInstance();
            nf.setGroupingUsed(false);
            if (!bTruncateZeros) {
                nf.setMinimumFractionDigits(precision);
            }
            if (bRound) {
                nf.setMaximumFractionDigits(precision);
            }
            if (cache_index < cached_number_formats.length) {
                DisplayFormatters.cached_number_formats[cache_index] = nf;
            }
        }
        return nf.format(tValue);
    }

    public static String truncateString(String str, int width) {
        int excess = str.length() - width;
        if (excess <= 0) {
            return str;
        }
        excess += 3;
        int token_start = -1;
        int max_len = 0;
        int max_start = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '~') {
                if (token_start == -1) {
                    token_start = i;
                    continue;
                }
                int len = i - token_start;
                if (len <= max_len) continue;
                max_len = len;
                max_start = token_start;
                continue;
            }
            token_start = -1;
        }
        if (max_len >= excess) {
            int trim_point = max_start + max_len;
            return str.substring(0, trim_point - excess) + "..." + str.substring(trim_point);
        }
        return str.substring(0, width - 3) + "...";
    }

    public static char getDecimalSeparator() {
        return decimalSeparator;
    }

    private static void updateFormatOverrides(String formats) {
        HashMap<String, Formatter> map = new HashMap<String, Formatter>();
        String[] lines = formats.split("\n");
        ArrayList<String> errors = new ArrayList<String>();
        for (String line : lines) {
            String error = null;
            if ((line = line.trim()).length() == 0) continue;
            String[] key_value = line.split(":", 2);
            if (key_value.length != 2) {
                error = "is missing ':'";
            } else {
                String key = key_value[0].trim();
                Formatter formatter = new Formatter();
                String value = key_value[1].trim();
                error = formatter.parse(value);
                if (error == null) {
                    map.put(key, formatter);
                }
            }
            if (error == null) continue;
            errors.add("'" + line + "' " + error);
        }
        String status_msg = errors.size() > 0 ? "Format parsing failed: " + errors : "";
        COConfigurationManager.setParameter("config.style.formatOverrides.status", status_msg);
        format_map = map;
    }

    public static String formatCustomRate(String key, long value) {
        Formatter formatter = format_map.get(key);
        if (formatter != null) {
            return formatter.format(value, true);
        }
        return null;
    }

    public static String formatCustomSize(String key, long value) {
        Formatter formatter = format_map.get(key);
        if (formatter != null) {
            return formatter.format(value, false);
        }
        return null;
    }

    public static void main(String[] args) {
        double d = 3.991630774821635E-6;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(6);
        nf.setMinimumFractionDigits(6);
        String s = nf.format(d);
        System.out.println("Actual: " + d);
        System.out.println("NF/6:   " + s);
        System.out.println("DF:     " + DisplayFormatters.formatDecimal(d, 6));
        System.out.println("DF 0:   " + DisplayFormatters.formatDecimal(d, 0));
        System.out.println("0.000000:" + DisplayFormatters.formatDecimal(0.0, 6));
        System.out.println("0.001:" + DisplayFormatters.formatDecimal(0.001, 6, true, true));
        System.out.println("0:" + DisplayFormatters.formatDecimal(0.0, 0));
        System.out.println("123456:" + DisplayFormatters.formatDecimal(123456.0, 0));
        System.out.println("123456:" + DisplayFormatters.formatDecimal(123456.999, 0));
        System.out.println(DisplayFormatters.formatDecimal(Double.NaN, 3));
    }

    static {
        all_units = new String[5];
        unitsStopAt = 4;
        message_text_state = 0;
        format_map = new HashMap<String, Formatter>();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"config.style.useSIUnits", "config.style.forceSIValues", "config.style.useUnitsRateBits", "config.style.doNotUseGB", "config.style.formatOverrides"}, new ParameterListener(){

            public void parameterChanged(String x) {
                use_si_units = COConfigurationManager.getBooleanParameter("config.style.useSIUnits");
                force_si_values = COConfigurationManager.getBooleanParameter("config.style.forceSIValues");
                use_units_rate_bits = COConfigurationManager.getBooleanParameter("config.style.useUnitsRateBits");
                not_use_GB_TB = COConfigurationManager.getBooleanParameter("config.style.doNotUseGB");
                unitsStopAt = not_use_GB_TB ? 2 : 4;
                DisplayFormatters.setUnits();
                DisplayFormatters.updateFormatOverrides(COConfigurationManager.getStringParameter("config.style.formatOverrides", ""));
            }
        });
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                DisplayFormatters.setUnits();
                DisplayFormatters.loadMessages();
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"config.style.dataStatsOnly", "config.style.separateProtDataStats"}, new ParameterListener(){

            public void parameterChanged(String x) {
                separate_prot_data_stats = COConfigurationManager.getBooleanParameter("config.style.separateProtDataStats");
                data_stats_only = COConfigurationManager.getBooleanParameter("config.style.dataStatsOnly");
            }
        });
        DisplayFormatters.setUnits();
        DisplayFormatters.loadMessages();
        abs_df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    private static class Formatter {
        private static final int FORMAT_UNIT_B = 1;
        private static final int FORMAT_UNIT_K = 2;
        private static final int FORMAT_UNIT_M = 4;
        private static final int FORMAT_UNIT_G = 8;
        private static final int FORMAT_UNIT_T = 16;
        private static final int FORMAT_UNIT_NONE = 0;
        private static final int FORMAT_UNIT_ALL = 65535;
        private static final int[] tens = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};
        private int unit_formats = 65535;
        private boolean hide_units = false;
        private boolean short_units = false;
        private Boolean rate_units = null;
        private NumberFormat number_format = null;
        private long number_format_fact = 1L;
        private int rounding = 6;

        private Formatter() {
        }

        private String parse(String str) {
            try {
                String[] args;
                for (String arg : args = str.split(",")) {
                    if ((arg = arg.trim()).length() == 0) continue;
                    String[] sub_args = arg.split(";");
                    if (sub_args.length == 0) {
                        return "invalid argument '" + arg + "'";
                    }
                    String main_arg = null;
                    for (String sub_arg : sub_args) {
                        String[] bits = (sub_arg = sub_arg.trim()).split("=");
                        if (bits.length != 2) {
                            return "invalid argument '" + arg + "'";
                        }
                        String arg_name = bits[0].trim().toLowerCase(Locale.US);
                        String arg_value = bits[1].trim();
                        if (main_arg == null) {
                            main_arg = arg_name;
                            if (main_arg.equals("units")) {
                                String[] units;
                                int mask = arg_value.contains("-") ? 65535 : 0;
                                for (String unit : units = arg_value.toLowerCase(Locale.US).split("&")) {
                                    int m;
                                    boolean remove;
                                    if (unit.startsWith("-")) {
                                        unit = unit.substring(1);
                                        remove = true;
                                    } else {
                                        remove = false;
                                    }
                                    char c = unit.charAt(0);
                                    if (c == 'b') {
                                        m = 1;
                                    } else if (c == 'k') {
                                        m = 2;
                                    } else if (c == 'm') {
                                        m = 4;
                                    } else if (c == 'g') {
                                        m = 8;
                                    } else if (c == 't') {
                                        m = 16;
                                    } else {
                                        return "Invalid unit: " + unit;
                                    }
                                    if (remove) {
                                        mask &= ~m;
                                        continue;
                                    }
                                    mask |= m;
                                }
                                this.unit_formats = mask;
                                continue;
                            }
                            if (main_arg.equals("format")) {
                                this.number_format = NumberFormat.getInstance();
                                if (this.number_format instanceof DecimalFormat) {
                                    ((DecimalFormat)this.number_format).applyPattern(arg_value);
                                } else {
                                    Debug.out("Number pattern isn't a DecimalFormat: " + this.number_format);
                                }
                                int max_fd = this.number_format.getMaximumFractionDigits();
                                if (max_fd < tens.length) {
                                    this.number_format_fact = tens[max_fd];
                                    continue;
                                }
                                this.number_format_fact = 1L;
                                for (int i = 0; i < max_fd; ++i) {
                                    this.number_format_fact *= 10L;
                                }
                                continue;
                            }
                            Debug.out("TODO: " + main_arg);
                            continue;
                        }
                        if (main_arg.equals("units")) {
                            if (arg_name.equals("hide")) {
                                this.hide_units = arg_value.toLowerCase(Locale.US).startsWith("y");
                                continue;
                            }
                            if (arg_name.equals("short")) {
                                this.short_units = arg_value.toLowerCase(Locale.US).startsWith("y");
                                continue;
                            }
                            if (arg_name.equals("rate")) {
                                this.rate_units = arg_value.toLowerCase(Locale.US).startsWith("y");
                                continue;
                            }
                            Debug.out("TODO: " + arg_name);
                            continue;
                        }
                        if (main_arg.equals("format")) {
                            if (!arg_name.equals("round")) continue;
                            String r = arg_value.toLowerCase(Locale.US);
                            if (r.equals("up")) {
                                this.rounding = 0;
                                continue;
                            }
                            if (r.equals("down")) {
                                this.rounding = 1;
                                continue;
                            }
                            if (r.equals("halfup")) {
                                this.rounding = 4;
                                continue;
                            }
                            if (r.equals("halfdown")) {
                                this.rounding = 5;
                                continue;
                            }
                            return "Invald round mode: " + r;
                        }
                        Debug.out("TODO: " + arg_name);
                    }
                }
                return null;
            }
            catch (Throwable e) {
                return Debug.getNestedExceptionMessage(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String format(long _value, boolean is_rate) {
            try {
                String result;
                double value = _value;
                String unit_str = "";
                if (this.unit_formats == 2) {
                    value /= 1024.0;
                    unit_str = all_units[1];
                } else if (this.unit_formats == 4) {
                    value /= 1048576.0;
                    unit_str = all_units[2];
                } else if (this.unit_formats == 8) {
                    value /= 1.073741824E9;
                    unit_str = all_units[3];
                } else if (this.unit_formats == 16) {
                    value /= 1.099511627776E12;
                    unit_str = all_units[4];
                }
                if (this.number_format != null) {
                    if (this.rounding != 6) {
                        double l_value = (long)value;
                        double fraction = value - l_value;
                        double l_fraction = (long)(fraction *= (double)this.number_format_fact);
                        double rem = fraction - l_fraction;
                        if (this.rounding != 1) {
                            if (this.rounding == 0) {
                                if (rem > 0.0) {
                                    l_fraction += 1.0;
                                }
                            } else if (this.rounding == 4) {
                                if (rem >= 0.5) {
                                    l_fraction += 1.0;
                                }
                            } else if (this.rounding == 5 && rem > 0.5) {
                                l_fraction += 1.0;
                            }
                        }
                        value = l_value + (l_fraction /= (double)this.number_format_fact);
                    }
                    NumberFormat numberFormat = this.number_format;
                    synchronized (numberFormat) {
                        result = this.number_format.format(value);
                    }
                } else {
                    result = String.valueOf(value);
                }
                if (this.hide_units) {
                    return result;
                }
                if (unit_str.length() > 0) {
                    result = this.short_units ? result + " " + unit_str.charAt(1) : result + unit_str;
                }
                if (is_rate && (this.rate_units == null || this.rate_units.booleanValue())) {
                    result = result + per_sec;
                }
                return result;
            }
            catch (Throwable e) {
                Debug.out(e);
                return String.valueOf(_value);
            }
        }
    }
}

