/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.protocol.wss;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

public class Handler
extends URLStreamHandler {
    private static boolean install_prompted = false;

    public URLConnection openConnection(URL u) throws IOException {
        return this.getProxy(u).openConnection();
    }

    private URL getProxy(URL u) throws IOException {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azwebtorrent");
        if (pi == null) {
            Handler.installPlugin();
            throw new IOException("'WebTorrent Support Plugin' is required - go to 'Tools->Plugins->Installation Wizard' to install.");
        }
        IPCInterface ipc = pi.getIPC();
        try {
            URL url = (URL)ipc.invoke("getProxyURL", new Object[]{u});
            return url;
        }
        catch (IPCException ipce) {
            Throwable e = ipce;
            if (e.getCause() != null) {
                e = e.getCause();
            }
            throw new IOException("Communication error with WebTorrent Support Plugin: " + Debug.getNestedExceptionMessage(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installPlugin() {
        Class<Handler> clazz = Handler.class;
        synchronized (Handler.class) {
            if (install_prompted) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            install_prompted = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            new AEThread2("install::async"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean installing;
                    block8: {
                        installing = false;
                        try {
                            boolean install;
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            if (uif == null) {
                                Object var9_3 = null;
                                if (!installing) {
                                    // empty if block
                                }
                                return;
                            }
                            String title = MessageText.getString("azwebtorrent.install");
                            String text = MessageText.getString("azwebtorrent.install.text");
                            UIFunctionsUserPrompter prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
                            String remember_id = "azwebtorrent.install.remember.id";
                            if (remember_id != null) {
                                prompter.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                            }
                            prompter.setAutoCloseInMS(0);
                            prompter.open(null);
                            boolean bl = install = prompter.waitUntilClosed() == 0;
                            if (!install) break block8;
                            if (!Constants.isJava7OrHigher) {
                                title = MessageText.getString("azwebtorrent.install.fail.jver");
                                text = MessageText.getString("azwebtorrent.install.fail.jver.text");
                                prompter = uif.getUserPrompter(title, text, new String[]{MessageText.getString("Button.ok")}, 0);
                                prompter.setAutoCloseInMS(0);
                                prompter.open(null);
                                break block8;
                            }
                            uif.installPlugin("azwebtorrent", "azwebtorrent.install", new UIFunctions.actionListener(){

                                public void actionComplete(Object result) {
                                }
                            });
                            installing = true;
                        }
                        catch (Throwable throwable) {
                            Object var9_5 = null;
                            if (!installing) {
                                // empty if block
                            }
                            throw throwable;
                        }
                    }
                    Object var9_4 = null;
                    if (!installing) {
                        // empty if block
                    }
                }
            }.start();
            return;
        }
    }
}

