/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.gudy.azureus2.core3.util.FileUtil;

public class PListEditor {
    private String plistFile;
    private boolean found_bom;

    public PListEditor(String plistFile) throws IOException {
        this.plistFile = plistFile;
        File file = new File(plistFile);
        if (!file.exists()) {
            throw new IOException("plist file '" + file + "' doesn't exist");
        }
        if (!file.canWrite()) {
            throw new IOException("plist file '" + file + "' is read only");
        }
    }

    public void setFileTypeExtensions(String[] extensions) throws IOException {
        StringBuffer value = new StringBuffer();
        StringBuffer find = new StringBuffer();
        find.append("(?s).*?<key>CFBundleDocumentTypes</key>\\s*<array>.*?<key>CFBundleTypeExtensions</key>\\s*<array>");
        for (int i = 0; i < extensions.length; ++i) {
            value.append("\n\t\t\t\t<string>");
            value.append(extensions[i]);
            value.append("</string>");
            find.append(".*?");
            find.append(extensions[i]);
        }
        value.append("\n\t\t\t");
        find.append(".*?</array>.*");
        String match = "(?s)(<key>CFBundleDocumentTypes</key>\\s*<array>.*?<key>CFBundleTypeExtensions</key>\\s*<array>)(.*?)(</array>)";
        this.setValue(find.toString(), match, value.toString());
    }

    public void setSimpleStringValue(String key, String value) throws IOException {
        String find = "(?s).*?<key>" + key + "</key>\\s*" + "<string>" + value + "</string>.*";
        String match = "(?s)(<key>" + key + "</key>\\s*" + "<string>)(.*?)(</string>)";
        this.setValue(find, match, value);
    }

    public void setArrayValues(String key, String valueType, String[] values) throws IOException {
        StringBuffer value = new StringBuffer();
        StringBuffer find = new StringBuffer();
        find.append("(?s).*?<key>" + key + "</key>\\s*" + "<array>");
        for (int i = 0; i < values.length; ++i) {
            find.append("\\s*<" + valueType + ">" + values[i] + "</" + valueType + ">");
            value.append("\n\t\t\t\t<" + valueType + ">");
            value.append(values[i]);
            value.append("</" + valueType + ">");
        }
        find.append("\\s*</array>.*");
        value.append("\n\t\t\t");
        String match = "(?s)(<key>" + key + "</key>\\s*<array>)(.*?)(</array>)";
        this.setValue(find.toString(), match, value.toString());
    }

    private boolean isValuePresent(String fileContent, String match) throws IOException {
        return fileContent.matches(match);
    }

    private void setValue(String find, String match, String value) throws IOException {
        String fileContent = this.getFileContent();
        if (!this.isValuePresent(fileContent, find)) {
            fileContent = fileContent.replaceFirst(match, "$1" + value + "$3");
            this.setFileContent(fileContent);
            this.touchFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent() throws IOException {
        String string;
        block5: {
            InputStreamReader reader = null;
            try {
                String result;
                byte[] file_bytes = FileUtil.readFileAsByteArray(new File(this.plistFile));
                if (file_bytes.length > 3 && file_bytes[0] == -17 && file_bytes[1] == -69 && file_bytes[2] == -65) {
                    this.found_bom = true;
                    reader = new InputStreamReader(new ByteArrayInputStream(file_bytes, 3, file_bytes.length - 3));
                } else {
                    this.found_bom = false;
                    reader = new InputStreamReader(new ByteArrayInputStream(file_bytes));
                }
                int length = 32768;
                char[] buffer = new char[length];
                int offset = 0;
                int len = 0;
                while ((len = reader.read(buffer, offset, length - offset)) > 0) {
                    offset += len;
                }
                string = result = new String(buffer, 0, offset);
                Object var10_9 = null;
                if (reader == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_10 = null;
                    if (reader == null) break block6;
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFileContent(String fileContent) throws IOException {
        File backup_file;
        File file;
        block8: {
            file = new File(this.plistFile);
            backup_file = new File(this.plistFile + ".bak");
            if (file.exists() && !FileUtil.copyFile(file, backup_file)) {
                throw new IOException("Failed to backup plist file prior to modification");
            }
            boolean ok = false;
            try {
                block7: {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(fileContent.length() + 256);
                    if (this.found_bom) {
                        baos.write(new byte[]{-17, -69, -65});
                    }
                    OutputStreamWriter osw = new OutputStreamWriter(baos);
                    osw.write(fileContent);
                    osw.close();
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(this.plistFile);
                        out.write(baos.toByteArray());
                        Object var9_8 = null;
                        if (out == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (out == null) throw throwable;
                        out.close();
                        ok = true;
                        throw throwable;
                    }
                    out.close();
                    ok = true;
                }
                Object var11_11 = null;
                if (!ok) break block8;
                backup_file.delete();
                return;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (ok) {
                    backup_file.delete();
                    throw throwable;
                }
                if (!backup_file.exists()) throw throwable;
                File bork_file = new File(this.plistFile + ".bad");
                file.renameTo(bork_file);
                file.delete();
                backup_file.renameTo(file);
                throw throwable;
            }
        }
        if (!backup_file.exists()) return;
        File bork_file = new File(this.plistFile + ".bad");
        file.renameTo(bork_file);
        file.delete();
        backup_file.renameTo(file);
    }

    public void touchFile() {
        File file = new File(this.plistFile);
        for (int i = 0; i <= 2; ++i) {
            if (file == null) continue;
            String[] command = new String[]{"touch", file.getAbsolutePath()};
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            file = file.getParentFile();
        }
    }

    public static void main(String[] args) {
        try {
            PListEditor editor = new PListEditor("/Applications/Vuze.app/Contents/Info.plist");
            editor.setFileTypeExtensions(new String[]{"torrent", "tor", "vuze", "vuz"});
            editor.setSimpleStringValue("CFBundleName", "Vuze");
            editor.setSimpleStringValue("CFBundleTypeName", "Vuze Download");
            editor.setSimpleStringValue("CFBundleGetInfoString", "Vuze");
            editor.setArrayValues("CFBundleURLSchemes", "string", new String[]{"magnet", "dht"});
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

