/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.sharing;

import java.io.File;
import java.util.Map;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ShareManager {
    public static final String PR_PERSONAL = "personal";
    public static final String PR_NETWORKS = "networks";
    public static final String PR_TAGS = "tags";
    public static final String PR_USER_DATA = "user_data";
    public static final String PR_PERSISTENT = "persistent";

    public void initialise() throws ShareException;

    public boolean isInitialising();

    public ShareResource[] getShares();

    public ShareResource getShare(File var1);

    public ShareResourceFile addFile(File var1) throws ShareException, ShareResourceDeletionVetoException;

    public ShareResourceFile addFile(File var1, Map<String, String> var2) throws ShareException, ShareResourceDeletionVetoException;

    public ShareResourceDir addDir(File var1) throws ShareException, ShareResourceDeletionVetoException;

    public ShareResourceDir addDir(File var1, Map<String, String> var2) throws ShareException, ShareResourceDeletionVetoException;

    public ShareResourceDirContents addDirContents(File var1, boolean var2) throws ShareException, ShareResourceDeletionVetoException;

    public ShareResourceDirContents addDirContents(File var1, boolean var2, Map<String, String> var3) throws ShareException, ShareResourceDeletionVetoException;

    public void cancelOperation();

    public void addListener(ShareManagerListener var1);

    public void removeListener(ShareManagerListener var1);
}

