/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.tag.Tag;
import org.gudy.azureus2.plugins.tag.TagManager;
import org.gudy.azureus2.plugins.utils.AggregatedDispatcher;
import org.gudy.azureus2.plugins.utils.AggregatedList;
import org.gudy.azureus2.plugins.utils.AggregatedListAcceptor;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.LocationProvider;
import org.gudy.azureus2.plugins.utils.LocationProviderListener;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.PowerManagementListener;
import org.gudy.azureus2.plugins.utils.ScriptProvider;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInitiator;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionException;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionManager;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Utilities {
    public String getAzureusUserDir();

    public String getAzureusProgramDir();

    public boolean isCVSVersion();

    public boolean isWindows();

    public boolean isLinux();

    public boolean isSolaris();

    public boolean isOSX();

    public boolean isUnix();

    public boolean isFreeBSD();

    public InputStream getImageAsStream(String var1);

    public Semaphore getSemaphore();

    public Monitor getMonitor();

    public ByteBuffer allocateDirectByteBuffer(int var1);

    public void freeDirectByteBuffer(ByteBuffer var1);

    public PooledByteBuffer allocatePooledByteBuffer(int var1);

    public PooledByteBuffer allocatePooledByteBuffer(byte[] var1);

    public PooledByteBuffer allocatePooledByteBuffer(Map var1) throws IOException;

    public Formatters getFormatters();

    public LocaleUtilities getLocaleUtilities();

    public UTTimer createTimer(String var1);

    public UTTimer createTimer(String var1, boolean var2);

    public UTTimer createTimer(String var1, int var2);

    public void createThread(String var1, Runnable var2);

    public void createProcess(String var1) throws PluginException;

    public ResourceDownloaderFactory getResourceDownloaderFactory();

    public ResourceUploaderFactory getResourceUploaderFactory();

    public SESecurityManager getSecurityManager();

    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory();

    public RSSFeed getRSSFeed(InputStream var1) throws SimpleXMLParserDocumentException;

    public RSSFeed getRSSFeed(URL var1, InputStream var2) throws SimpleXMLParserDocumentException;

    public RSSFeed getRSSFeed(URL var1) throws ResourceDownloaderException, SimpleXMLParserDocumentException;

    public RSSFeed getRSSFeed(ResourceDownloader var1) throws ResourceDownloaderException, SimpleXMLParserDocumentException;

    public RSSFeed getRSSFeed(URL var1, ResourceDownloader var2) throws ResourceDownloaderException, SimpleXMLParserDocumentException;

    public InetAddress getPublicAddress();

    public InetAddress getPublicAddress(boolean var1);

    public String reverseDNSLookup(InetAddress var1);

    public long getCurrentSystemTime();

    public ByteArrayWrapper createWrapper(byte[] var1);

    public AggregatedDispatcher createAggregatedDispatcher(long var1, long var3);

    public AggregatedList createAggregatedList(AggregatedListAcceptor var1, long var2, long var4);

    public Map readResilientBEncodedFile(File var1, String var2, boolean var3);

    public void writeResilientBEncodedFile(File var1, String var2, Map var3, boolean var4);

    public void deleteResilientBEncodedFile(File var1, String var2, boolean var3);

    public int compareVersions(String var1, String var2);

    public String normaliseFileName(String var1);

    public DelayedTask createDelayedTask(Runnable var1);

    public void registerSearchProvider(SearchProvider var1) throws SearchException;

    public void unregisterSearchProvider(SearchProvider var1) throws SearchException;

    public SearchInitiator getSearchInitiator() throws SearchException;

    public SubscriptionManager getSubscriptionManager() throws SubscriptionException;

    public FeatureManager getFeatureManager();

    public boolean supportsPowerStateControl(int var1);

    public void addPowerManagementListener(PowerManagementListener var1);

    public void removePowerManagementListener(PowerManagementListener var1);

    public List<LocationProvider> getLocationProviders();

    public void addLocationProvider(LocationProvider var1);

    public void removeLocationProvider(LocationProvider var1);

    public void addLocationProviderListener(LocationProviderListener var1);

    public void removeLocationProviderListener(LocationProviderListener var1);

    public void registerJSONRPCServer(JSONServer var1);

    public void unregisterJSONRPCServer(JSONServer var1);

    public void registerJSONRPCClient(JSONClient var1);

    public void unregisterJSONRPCClient(JSONClient var1);

    public List<DistributedDatabase> getDistributedDatabases(String[] var1);

    public List<DistributedDatabase> getDistributedDatabases(String[] var1, Map<String, Object> var2);

    public List<ScriptProvider> getScriptProviders();

    public void registerScriptProvider(ScriptProvider var1);

    public void unregisterScriptProvider(ScriptProvider var1);

    public void addScriptProviderListener(ScriptProvider.ScriptProviderListener var1);

    public void removeScriptProviderListener(ScriptProvider.ScriptProviderListener var1);

    public TagManager getTagManager();

    public Tag lookupTag(String var1);

    public static interface JSONClient {
        public void serverRegistered(JSONServer var1);

        public void serverUnregistered(JSONServer var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JSONServer {
        public String getName();

        public List<String> getSupportedMethods();

        public Map call(String var1, Map var2) throws PluginException;
    }
}

