/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.clientid;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.util.NetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;

public class ClientIDManagerImpl
implements ClientIDManager {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected static ClientIDManagerImpl singleton = new ClientIDManagerImpl();
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private static final int connect_timeout;
    private static final int read_timeout;
    private ClientIDGenerator generator;
    private volatile boolean use_filter;
    private boolean filter_override;
    private ThreadPool thread_pool;
    private Object filter_lock = new Object();
    private int filter_port;

    public static ClientIDManagerImpl getSingleton() {
        return singleton;
    }

    public void setGenerator(ClientIDGenerator _generator, boolean _use_filter) {
        this.generator = _generator;
        this.use_filter = _use_filter;
        if (!this.use_filter) {
            String http_proxy = System.getProperty("http.proxyHost");
            String socks_proxy = System.getProperty("socksProxyHost");
            NetworkAdmin network_admin = NetworkAdmin.getSingleton();
            if (network_admin.mustBind()) {
                this.filter_override = true;
                this.use_filter = true;
            } else {
                InetAddress bindIP = network_admin.getSingleHomedServiceBindAddress();
                if (!(http_proxy != null && http_proxy.trim().length() != 0 || socks_proxy != null && socks_proxy.trim().length() != 0 || bindIP == null || bindIP.isAnyLocalAddress())) {
                    int ips = 0;
                    try {
                        List<NetworkInterface> x = NetUtils.getNetworkInterfaces();
                        for (NetworkInterface network_interface : x) {
                            Enumeration<InetAddress> addresses = network_interface.getInetAddresses();
                            while (addresses.hasMoreElements()) {
                                InetAddress address = addresses.nextElement();
                                if (address.isLoopbackAddress()) continue;
                                ++ips;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LOGID, "", e));
                    }
                    if (ips > 1) {
                        this.filter_override = true;
                        this.use_filter = true;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "ClientIDManager: overriding filter option to support local bind IP"));
                        }
                    }
                }
            }
        }
        this.setupFilter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFilter(boolean force) {
        Object object = this.filter_lock;
        synchronized (object) {
            if (!this.use_filter) {
                if (force) {
                    this.use_filter = true;
                } else {
                    return;
                }
            }
            if (this.filter_port != 0) {
                return;
            }
            try {
                this.thread_pool = new ThreadPool("ClientIDManager", 32);
                int timeout = connect_timeout + read_timeout;
                this.thread_pool.setExecutionLimit(timeout);
                final ServerSocket ss = new ServerSocket(0, 1024, InetAddress.getByName("127.0.0.1"));
                this.filter_port = ss.getLocalPort();
                ss.setReuseAddress(true);
                new AEThread2("ClientIDManager::filterloop"){

                    public void run() {
                        long failed_accepts = 0L;
                        while (true) {
                            try {
                                while (true) {
                                    Socket socket = ss.accept();
                                    failed_accepts = 0L;
                                    ClientIDManagerImpl.this.thread_pool.run(new httpFilter(socket));
                                }
                            }
                            catch (Throwable e) {
                                ++failed_accepts;
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + ClientIDManagerImpl.this.filter_port, e));
                                if (failed_accepts <= 10L) continue;
                                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + ClientIDManagerImpl.this.filter_port, "TCP"});
                                ClientIDManagerImpl.this.use_filter = false;
                                return;
                            }
                            break;
                        }
                    }
                }.start();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener established on port " + this.filter_port));
                }
            }
            catch (Throwable e) {
                Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.filter_port});
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "ClientIDManager: listener failed on port " + this.filter_port, e));
                }
                this.use_filter = false;
            }
        }
    }

    public ClientIDGenerator getGenerator() {
        return this.generator;
    }

    public byte[] generatePeerID(byte[] hash, boolean for_tracker) throws ClientIDException {
        return this.generator.generatePeerID(hash, for_tracker);
    }

    public Object getProperty(byte[] hash, String property_name) {
        return this.generator.getProperty(hash, property_name);
    }

    public void generateHTTPProperties(byte[] hash, Properties properties) throws ClientIDException {
        URL url;
        boolean filter_it;
        Boolean sni_hack = (Boolean)properties.get("SNI-Hack");
        if (sni_hack != null && sni_hack.booleanValue() && !this.use_filter) {
            this.setupFilter(true);
        }
        if (filter_it = this.use_filter) {
            url = (URL)properties.get("URL");
            String protocol = url.getProtocol();
            String host = url.getHost();
            if (host.equals("127.0.0.1") || protocol.equals("ws") || protocol.equals("wss") || AENetworkClassifier.categoriseAddress(host) != "Public") {
                filter_it = false;
            } else {
                InetSocketAddress address;
                Proxy proxy = (Proxy)properties.get("Proxy");
                if (proxy != null && proxy.type() == Proxy.Type.SOCKS && (address = (InetSocketAddress)proxy.address()).getAddress().isLoopbackAddress()) {
                    filter_it = false;
                }
            }
        }
        this.generator.generateHTTPProperties(hash, properties);
        if (filter_it) {
            url = (URL)properties.get("URL");
            boolean is_ssl = url.getProtocol().toLowerCase().equals("https");
            try {
                String rem;
                String url_str = url.toString();
                String target_host = url.getHost();
                int target_port = url.getPort();
                if (target_port == -1) {
                    target_port = url.getDefaultPort();
                }
                String hash_str = hash == null ? "" : URLEncoder.encode(new String(hash, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
                int host_pos = url_str.indexOf(target_host);
                String new_url = url_str.substring(0, host_pos) + "127.0.0.1:" + this.filter_port;
                if (is_ssl) {
                    new_url = "http" + new_url.substring(new_url.indexOf(58));
                }
                if ((rem = url_str.substring(host_pos + target_host.length())).charAt(0) == ':') {
                    rem = rem.substring(("" + target_port).length() + 1);
                }
                int q_pos = rem.indexOf(63);
                String details = "cid=" + (is_ssl ? "." : "") + target_host + ":" + target_port + "+" + hash_str;
                new_url = q_pos == -1 ? new_url + rem + "?" + details : new_url + rem.substring(0, q_pos + 1) + details + "&" + rem.substring(q_pos + 1);
                properties.put("URL", new URL(new_url));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    static {
        String connect_timeout_str = System.getProperty("sun.net.client.defaultConnectTimeout");
        String read_timeout_str = System.getProperty("sun.net.client.defaultReadTimeout");
        int ct = 60000;
        int rt = 60000;
        try {
            ct = Integer.parseInt(connect_timeout_str);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            rt = Integer.parseInt(read_timeout_str);
        }
        catch (Throwable e) {
            // empty catch block
        }
        connect_timeout = ct;
        read_timeout = rt;
    }

    protected class httpFilter
    extends ThreadPoolTask {
        private Socket socket;

        protected httpFilter(Socket _socket) {
            this.socket = _socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void runSupport() {
            block63: {
                boolean looks_like_tracker_request;
                int written;
                String report_error;
                block61: {
                    String[] lines_out;
                    boolean is_ssl;
                    int len;
                    report_error = null;
                    written = 0;
                    looks_like_tracker_request = false;
                    this.setTaskState("reading header");
                    InputStream is = this.socket.getInputStream();
                    byte[] buffer = new byte[1024];
                    String header = "";
                    while ((len = is.read(buffer)) != -1 && !(header = header + new String(buffer, 0, len, "ISO-8859-1")).endsWith("\r\n\r\n") && header.indexOf("\r\n\r\n") == -1) {
                    }
                    ArrayList<String> lines = new ArrayList<String>();
                    int pos = 0;
                    while (true) {
                        int p1;
                        String line = (p1 = header.indexOf(ClientIDManagerImpl.NL, pos)) == -1 ? header.substring(pos) : header.substring(pos, p1);
                        if ((line = line.trim()).length() > 0) {
                            lines.add(line);
                        }
                        if (p1 == -1) break;
                        pos = p1 + 2;
                    }
                    String[] lines_in = new String[lines.size()];
                    lines.toArray(lines_in);
                    String get = lines_in[0];
                    int p1 = get.indexOf("?cid=");
                    int p2 = get.indexOf("&", p1);
                    if (p2 == -1) {
                        p2 = get.indexOf(32, p1);
                    }
                    String cid = get.substring(p1 + 5, p2);
                    int p3 = cid.lastIndexOf(":");
                    String target_host = cid.substring(0, p3);
                    String[] port_hash = cid.substring(p3 + 1).split("\\+");
                    int target_port = Integer.parseInt(port_hash[0]);
                    String hash_str = port_hash.length == 1 ? "" : port_hash[1];
                    byte[] hash = hash_str.length() == 0 ? null : URLDecoder.decode(port_hash[1], "ISO-8859-1").getBytes("ISO-8859-1");
                    boolean bl = looks_like_tracker_request = hash != null;
                    if (target_host.startsWith(".")) {
                        is_ssl = true;
                        target_host = target_host.substring(1);
                    } else {
                        is_ssl = false;
                    }
                    for (int i = 1; i < lines_in.length; ++i) {
                        String line = lines_in[i];
                        if (line.toLowerCase().indexOf("host:") == -1) continue;
                        lines_in[i] = "Host: " + target_host + ":" + target_port;
                        break;
                    }
                    lines_in[0] = get = get.substring(0, p1 + 1) + get.substring(p2 + 1);
                    if (ClientIDManagerImpl.this.filter_override) {
                        lines_out = lines_in;
                        Properties p = new Properties();
                        ClientIDManagerImpl.this.generator.generateHTTPProperties(hash, p);
                        String agent = p.getProperty("User-Agent");
                        if (agent != null) {
                            for (int i = 0; i < lines_out.length; ++i) {
                                if (!lines_out[i].toLowerCase().startsWith("user-agent")) continue;
                                lines_out[i] = "User-Agent: " + agent;
                            }
                        }
                        lines_out = ClientIDManagerImpl.this.generator.filterHTTP(hash, (String[])lines_out.clone());
                    } else {
                        lines_out = ClientIDManagerImpl.this.generator.filterHTTP(hash, lines_in);
                    }
                    String header_out = "";
                    for (int i = 0; i < lines_out.length; ++i) {
                        header_out = header_out + lines_out[i] + ClientIDManagerImpl.NL;
                    }
                    header_out = header_out + ClientIDManagerImpl.NL;
                    Socket target = UrlUtils.connectSocketAndWrite(is_ssl, target_host, target_port, header_out.getBytes("ISO-8859-1"), connect_timeout, read_timeout);
                    try {
                        int len2;
                        target.getOutputStream().flush();
                        InputStream target_is = target.getInputStream();
                        String reply_header = "";
                        byte[] temp = new byte[1];
                        do {
                            int len3;
                            if ((len3 = target_is.read(temp)) != 1) {
                                throw new ClientIDException("EOF while reading reply header");
                            }
                            reply_header = reply_header + new String(temp, "ISO-8859-1");
                        } while (temp[0] != 10 || !reply_header.endsWith("\r\n\r\n"));
                        String[] reply_lines = reply_header.trim().split(ClientIDManagerImpl.NL);
                        String line1 = reply_lines[0];
                        line1 = line1.substring(line1.indexOf(32) + 1).trim();
                        if (line1.startsWith("301") || line1.startsWith("302")) {
                            for (int i = 1; i < reply_lines.length; ++i) {
                                String line = reply_lines[i];
                                if (!line.toLowerCase(Locale.US).startsWith("location:")) continue;
                                String redirect_url = line.substring(9).trim();
                                String lc_redirect_url = redirect_url.toLowerCase(Locale.US);
                                if (!lc_redirect_url.startsWith("http:") && !lc_redirect_url.startsWith("https:")) {
                                    String prefix = "http" + (is_ssl ? "s" : "") + "://" + target_host + ":" + target_port;
                                    if (redirect_url.startsWith("/")) {
                                        redirect_url = prefix + redirect_url;
                                    } else {
                                        String get_line = (String)lines.get(0);
                                        get_line = get_line.substring(get_line.indexOf(32) + 1).trim();
                                        int x_pos = (get_line = get_line.substring(0, get_line.indexOf(32)).trim()).indexOf(63);
                                        if (x_pos != -1) {
                                            get_line = get_line.substring(0, x_pos);
                                        }
                                        redirect_url = (x_pos = get_line.lastIndexOf(47)) == -1 ? prefix + "/" + redirect_url : prefix + get_line.substring(0, x_pos + 1) + redirect_url;
                                    }
                                }
                                Properties http_properties = new Properties();
                                http_properties.put("URL", new URL(redirect_url));
                                ClientIDManagerImpl.this.generateHTTPProperties(hash, http_properties);
                                URL updated = (URL)http_properties.get("URL");
                                reply_lines[i] = "Location: " + updated.toExternalForm();
                            }
                        }
                        OutputStream os = this.socket.getOutputStream();
                        for (String str : reply_lines) {
                            os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                        }
                        os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                        while ((len2 = target_is.read(buffer)) != -1) {
                            os.write(buffer, 0, len2);
                            written += len2;
                        }
                        Object var37_52 = null;
                    }
                    catch (Throwable throwable) {
                        Object var37_53 = null;
                        target.close();
                        throw throwable;
                    }
                    target.close();
                    Object var39_55 = null;
                    if (report_error == null || written != 0 || !looks_like_tracker_request) break block61;
                    HashMap<String, String> failure = new HashMap<String, String>();
                    failure.put("failure reason", report_error);
                    try {
                        String[] reply_lines;
                        byte[] x = BEncoder.encode(failure);
                        OutputStream os = this.socket.getOutputStream();
                        for (String str : reply_lines = new String[]{"HTTP/1.1 200 OK", "Content-Length: " + x.length, "Connection: close"}) {
                            os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                        }
                        os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                        os.write(x);
                    }
                    catch (Throwable f) {
                        // empty catch block
                    }
                }
                try {
                    this.socket.getOutputStream().flush();
                    this.socket.close();
                }
                catch (Throwable f) {}
                break block63;
                {
                    catch (ClientIDException e) {
                        report_error = e.getMessage();
                        Object var39_56 = null;
                        if (report_error != null && written == 0 && looks_like_tracker_request) {
                            HashMap<String, String> failure = new HashMap<String, String>();
                            failure.put("failure reason", report_error);
                            try {
                                String[] reply_lines;
                                byte[] x = BEncoder.encode(failure);
                                OutputStream os = this.socket.getOutputStream();
                                for (String str : reply_lines = new String[]{"HTTP/1.1 200 OK", "Content-Length: " + x.length, "Connection: close"}) {
                                    os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                                }
                                os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                                os.write(x);
                            }
                            catch (Throwable f) {
                                // empty catch block
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable f) {}
                        break block63;
                    }
                    catch (UnknownHostException e) {
                        report_error = "Unknown host '" + e.getMessage() + "'";
                        Object var39_57 = null;
                        if (report_error != null && written == 0 && looks_like_tracker_request) {
                            HashMap<String, String> failure = new HashMap<String, String>();
                            failure.put("failure reason", report_error);
                            try {
                                String[] reply_lines;
                                byte[] x = BEncoder.encode(failure);
                                OutputStream os = this.socket.getOutputStream();
                                for (String str : reply_lines = new String[]{"HTTP/1.1 200 OK", "Content-Length: " + x.length, "Connection: close"}) {
                                    os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                                }
                                os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                                os.write(x);
                            }
                            catch (Throwable f) {
                                // empty catch block
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable f) {}
                        break block63;
                    }
                    catch (IOException e) {
                        report_error = e.getMessage();
                        Object var39_58 = null;
                        if (report_error != null && written == 0 && looks_like_tracker_request) {
                            HashMap<String, String> failure = new HashMap<String, String>();
                            failure.put("failure reason", report_error);
                            try {
                                String[] reply_lines;
                                byte[] x = BEncoder.encode(failure);
                                OutputStream os = this.socket.getOutputStream();
                                for (String str : reply_lines = new String[]{"HTTP/1.1 200 OK", "Content-Length: " + x.length, "Connection: close"}) {
                                    os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                                }
                                os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                                os.write(x);
                            }
                            catch (Throwable f) {
                                // empty catch block
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable f) {}
                        break block63;
                    }
                    catch (UnsupportedAddressTypeException e) {
                        report_error = e.getMessage();
                        Object var39_59 = null;
                        if (report_error != null && written == 0 && looks_like_tracker_request) {
                            HashMap<String, String> failure = new HashMap<String, String>();
                            failure.put("failure reason", report_error);
                            try {
                                String[] reply_lines;
                                byte[] x = BEncoder.encode(failure);
                                OutputStream os = this.socket.getOutputStream();
                                for (String str : reply_lines = new String[]{"HTTP/1.1 200 OK", "Content-Length: " + x.length, "Connection: close"}) {
                                    os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                                }
                                os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                                os.write(x);
                            }
                            catch (Throwable f) {
                                // empty catch block
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable f) {}
                        break block63;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        Object var39_60 = null;
                        if (report_error != null && written == 0 && looks_like_tracker_request) {
                            HashMap<String, String> failure = new HashMap<String, String>();
                            failure.put("failure reason", report_error);
                            try {
                                String[] reply_lines;
                                byte[] x = BEncoder.encode(failure);
                                OutputStream os = this.socket.getOutputStream();
                                for (String str : reply_lines = new String[]{"HTTP/1.1 200 OK", "Content-Length: " + x.length, "Connection: close"}) {
                                    os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                                }
                                os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                                os.write(x);
                            }
                            catch (Throwable f) {
                                // empty catch block
                            }
                        }
                        try {
                            this.socket.getOutputStream().flush();
                            this.socket.close();
                        }
                        catch (Throwable f) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var39_61 = null;
                    if (report_error != null && written == 0 && looks_like_tracker_request) {
                        HashMap<String, String> failure = new HashMap<String, String>();
                        failure.put("failure reason", report_error);
                        try {
                            String[] reply_lines;
                            byte[] x = BEncoder.encode(failure);
                            OutputStream os = this.socket.getOutputStream();
                            for (String str : reply_lines = new String[]{"HTTP/1.1 200 OK", "Content-Length: " + x.length, "Connection: close"}) {
                                os.write((str + ClientIDManagerImpl.NL).getBytes("ISO-8859-1"));
                            }
                            os.write(ClientIDManagerImpl.NL.getBytes("ISO-8859-1"));
                            os.write(x);
                        }
                        catch (Throwable f) {
                            // empty catch block
                        }
                    }
                    try {
                        this.socket.getOutputStream().flush();
                        this.socket.close();
                    }
                    catch (Throwable f) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        public void interruptTask() {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

