/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ddb;

import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import java.net.InetSocketAddress;
import java.util.Map;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKeyStats;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDBaseContactImpl
implements DistributedDatabaseContact {
    private DDBaseImpl ddb;
    private DHTPluginContact contact;

    protected DDBaseContactImpl(DDBaseImpl _ddb, DHTPluginContact _contact) {
        this.ddb = _ddb;
        this.contact = _contact;
    }

    @Override
    public byte[] getID() {
        return this.contact.getID();
    }

    @Override
    public String getName() {
        return this.contact.getName();
    }

    @Override
    public int getVersion() {
        return this.contact.getProtocolVersion();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.contact.getAddress();
    }

    @Override
    public int getDHT() {
        return this.contact.getNetwork() == 1 ? 2 : 1;
    }

    @Override
    public boolean isAlive(long timeout) {
        return this.contact.isAlive(timeout);
    }

    @Override
    public void isAlive(long timeout, final DistributedDatabaseListener listener) {
        this.contact.isAlive(timeout, new DHTPluginOperationListener(){

            public void starts(byte[] key) {
            }

            public boolean diversified() {
                return true;
            }

            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            public void complete(byte[] key, final boolean timeout_occurred) {
                listener.event(new DistributedDatabaseEvent(){

                    public int getType() {
                        return timeout_occurred ? 5 : 4;
                    }

                    public DistributedDatabaseKey getKey() {
                        return null;
                    }

                    public DistributedDatabaseKeyStats getKeyStats() {
                        return null;
                    }

                    public DistributedDatabaseValue getValue() {
                        return null;
                    }

                    public DistributedDatabaseContact getContact() {
                        return DDBaseContactImpl.this;
                    }
                });
            }
        });
    }

    @Override
    public boolean isOrHasBeenLocal() {
        return this.contact.isOrHasBeenLocal();
    }

    @Override
    public Map<String, Object> exportToMap() {
        return this.contact.exportToMap();
    }

    @Override
    public boolean openTunnel() {
        return this.contact.openTunnel() != null;
    }

    @Override
    public DistributedDatabaseValue call(DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseValue data, long timeout) throws DistributedDatabaseException {
        return this.ddb.call(this, listener, type, data, timeout);
    }

    @Override
    public void write(DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value, long timeout) throws DistributedDatabaseException {
        this.ddb.write(this, listener, type, key, value, timeout);
    }

    @Override
    public DistributedDatabaseValue read(DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        return this.ddb.read(this, listener, type, key, timeout);
    }

    protected DHTPluginContact getContact() {
        return this.contact;
    }
}

