/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ipc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCInterfaceImpl
implements IPCInterface {
    private Object target_use_accessor;
    private String plugin_class;
    private PluginInitializer plugin_initializer;

    public IPCInterfaceImpl(PluginInitializer _plugin_initializer, Plugin _target) {
        this.plugin_initializer = _plugin_initializer;
        this.target_use_accessor = _target;
        this.plugin_class = _target.getClass().getName();
    }

    public IPCInterfaceImpl(Object _target) {
        this.target_use_accessor = _target;
        this.plugin_class = _target.getClass().getName();
    }

    @Override
    public boolean canInvoke(String methodName, Object[] params) {
        try {
            Object target = this.getTarget();
            Method mtd = this.getMethod(target, methodName, params);
            mtd.setAccessible(true);
            if (mtd != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean canInvoke(String methodName, Class<?>[] params) {
        try {
            Object target = this.getTarget();
            Method mtd = this.getMethod(target, methodName, params);
            mtd.setAccessible(true);
            if (mtd != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object invoke(String methodName, Object[] params) throws IPCException {
        Object target = this.getTarget();
        try {
            Method mtd = this.getMethod(target, methodName, params);
            mtd.setAccessible(true);
            return mtd.invoke(target, params);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw new IPCException(e);
        }
    }

    protected Method getMethod(Object target, String methodName, Object[] params) throws Throwable {
        Method mtd;
        block6: {
            if (params == null) {
                params = new Object[]{};
            }
            Class[] paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = params[i] instanceof Boolean ? Boolean.TYPE : (params[i] instanceof Integer ? Integer.TYPE : (params[i] instanceof Long ? Long.TYPE : (params[i] instanceof Float ? Float.TYPE : (params[i] instanceof Double ? Double.TYPE : (params[i] instanceof Byte ? Byte.TYPE : (params[i] instanceof Character ? Character.TYPE : (params[i] instanceof Short ? Short.TYPE : params[i].getClass())))))));
            }
            mtd = null;
            try {
                mtd = target.getClass().getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                Method[] methods = target.getClass().getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    Class<?>[] method_params = method.getParameterTypes();
                    if (!method.getName().equals(methodName) || method_params.length != paramTypes.length) continue;
                    boolean ok = true;
                    for (int j = 0; j < method_params.length; ++j) {
                        Class<?> declared = method_params[j];
                        Class supplied = paramTypes[j];
                        if (declared.isAssignableFrom(supplied)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                    mtd = method;
                    break;
                }
                if (mtd != null) break block6;
                throw e;
            }
        }
        return mtd;
    }

    protected Method getMethod(Object target, String methodName, Class<?>[] paramTypes) throws Throwable {
        Method mtd;
        block5: {
            if (paramTypes == null) {
                paramTypes = new Class[]{};
            }
            mtd = null;
            try {
                mtd = target.getClass().getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                Method[] methods = target.getClass().getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    Class<?>[] method_params = method.getParameterTypes();
                    if (!method.getName().equals(methodName) || method_params.length != paramTypes.length) continue;
                    boolean ok = true;
                    for (int j = 0; j < method_params.length; ++j) {
                        Class<?> declared = method_params[j];
                        Class<?> supplied = paramTypes[j];
                        if (declared.isAssignableFrom(supplied)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                    mtd = method;
                    break;
                }
                if (mtd != null) break block5;
                throw e;
            }
        }
        return mtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getTarget() throws IPCException {
        IPCInterfaceImpl iPCInterfaceImpl = this;
        synchronized (iPCInterfaceImpl) {
            if (this.target_use_accessor == null) {
                PluginInterface[] pis = this.plugin_initializer.getPlugins();
                for (int i = 0; i < pis.length; ++i) {
                    PluginInterface pi = pis[i];
                    if (!pi.getPlugin().getClass().getName().equals(this.plugin_class)) continue;
                    this.target_use_accessor = pi.getPlugin();
                    break;
                }
            }
            if (this.target_use_accessor == null) {
                throw new IPCException("Plugin has been unloaded");
            }
            return this.target_use_accessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        IPCInterfaceImpl iPCInterfaceImpl = this;
        synchronized (iPCInterfaceImpl) {
            this.target_use_accessor = null;
        }
    }
}

