/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderDelayedFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderAlternateImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderDelayedImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFileImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderMetaRefreshImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderRetryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderTimeoutImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderTorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderURLImpl;

public class ResourceDownloaderFactoryImpl
implements ResourceDownloaderFactory {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static ResourceDownloaderFactoryImpl singleton = new ResourceDownloaderFactoryImpl();
    private static final String[] SF_MIRRORS = new String[]{"jaist", "nchc", "keihanna", "optusnet", "peterhost", "ovh", "puzzle", "switch", "mesh", "kent", "surfnet", "heanet", "citkit", "internap", "cogent", "umn", "easynews", "ufpr"};

    public static ResourceDownloaderFactory getSingleton() {
        return singleton;
    }

    public ResourceDownloader create(File file) {
        return new ResourceDownloaderFileImpl(null, file);
    }

    public ResourceDownloader create(URL url) {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            try {
                return new ResourceDownloaderFileImpl(null, new File(new URI(url.toString())));
            }
            catch (Throwable e) {
                return new ResourceDownloaderURLImpl(null, url);
            }
        }
        return new ResourceDownloaderURLImpl(null, url);
    }

    public ResourceDownloader createWithAutoPluginProxy(URL url) {
        ResourceDownloader rd = this.create(url);
        if (rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setAutoPluginProxy();
        }
        return rd;
    }

    public ResourceDownloader create(URL url, boolean force_no_proxy) {
        ResourceDownloader rd = this.create(url);
        if (force_no_proxy && rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setForceNoProxy(force_no_proxy);
        }
        return rd;
    }

    public ResourceDownloader create(URL url, Proxy proxy) {
        ResourceDownloader rd = this.create(url);
        if (proxy != null && rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setForceProxy(proxy);
        }
        return rd;
    }

    public ResourceDownloader create(URL url, String postData) {
        return new ResourceDownloaderURLImpl(null, url, postData.getBytes(), false, null, null);
    }

    public ResourceDownloader create(URL url, String postData, Proxy proxy) {
        ResourceDownloader rd = this.create(url, postData);
        if (proxy != null && rd instanceof ResourceDownloaderURLImpl) {
            ((ResourceDownloaderURLImpl)rd).setForceProxy(proxy);
        }
        return rd;
    }

    public ResourceDownloader create(URL url, byte[] postData) {
        return new ResourceDownloaderURLImpl(null, url, postData, false, null, null);
    }

    public ResourceDownloader create(URL url, String user_name, String password) {
        return new ResourceDownloaderURLImpl(null, url, user_name, password);
    }

    public ResourceDownloader create(ResourceDownloaderDelayedFactory factory) {
        return new ResourceDownloaderDelayedImpl(null, factory);
    }

    public ResourceDownloader getRetryDownloader(ResourceDownloader downloader, int retry_count) {
        ResourceDownloaderRetryImpl res = new ResourceDownloaderRetryImpl(null, downloader, retry_count);
        return res;
    }

    public ResourceDownloader getTimeoutDownloader(ResourceDownloader downloader, int timeout_millis) {
        ResourceDownloaderTimeoutImpl res = new ResourceDownloaderTimeoutImpl(null, downloader, timeout_millis);
        return res;
    }

    public ResourceDownloader getAlternateDownloader(ResourceDownloader[] downloaders) {
        return this.getAlternateDownloader(downloaders, -1, false);
    }

    public ResourceDownloader getAlternateDownloader(ResourceDownloader[] downloaders, int max_to_try) {
        return this.getAlternateDownloader(downloaders, max_to_try, false);
    }

    public ResourceDownloader getRandomDownloader(ResourceDownloader[] downloaders) {
        return this.getAlternateDownloader(downloaders, -1, true);
    }

    public ResourceDownloader getRandomDownloader(ResourceDownloader[] downloaders, int max_to_try) {
        return this.getAlternateDownloader(downloaders, max_to_try, true);
    }

    protected ResourceDownloader getAlternateDownloader(ResourceDownloader[] downloaders, int max_to_try, boolean random) {
        ResourceDownloaderAlternateImpl res = new ResourceDownloaderAlternateImpl(null, downloaders, max_to_try, random);
        return res;
    }

    public ResourceDownloader getMetaRefreshDownloader(ResourceDownloader downloader) {
        ResourceDownloaderMetaRefreshImpl res = new ResourceDownloaderMetaRefreshImpl(null, downloader);
        return res;
    }

    public ResourceDownloader getTorrentDownloader(ResourceDownloader downloader, boolean persistent) {
        return this.getTorrentDownloader(downloader, persistent, null);
    }

    public ResourceDownloader getTorrentDownloader(ResourceDownloader downloader, boolean persistent, File download_directory) {
        return new ResourceDownloaderTorrentImpl(null, downloader, persistent, download_directory);
    }

    public ResourceDownloader getSuffixBasedDownloader(ResourceDownloader _downloader) {
        ResourceDownloaderBaseImpl dl = (ResourceDownloaderBaseImpl)_downloader;
        URL target = null;
        while (true) {
            List kids;
            if ((kids = dl.getChildren()).size() == 0) break;
            dl = (ResourceDownloaderBaseImpl)kids.get(0);
        }
        target = ((ResourceDownloaderURLImpl)dl).getURL();
        if (target == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "ResourceDownloader: suffix based downloader failed to find leaf"));
            }
            return _downloader;
        }
        if (target.getPath().toLowerCase().endsWith(".torrent")) {
            return this.getTorrentDownloader(_downloader, true);
        }
        return _downloader;
    }

    public ResourceDownloader[] getSourceforgeDownloaders(String project_name, String filename) {
        String template = "http://%s.dl.sourceforge.net/sourceforge/" + project_name + "/" + filename;
        ResourceDownloader[] result = new ResourceDownloader[SF_MIRRORS.length];
        for (int i = 0; i < result.length; ++i) {
            String url = template.replaceFirst("%s", SF_MIRRORS[i]);
            try {
                result[i] = this.create(new URL(url));
                continue;
            }
            catch (MalformedURLException me) {
                throw new RuntimeException(me);
            }
        }
        return result;
    }

    public ResourceDownloader getSourceforgeDownloader(String project_name, String filename) {
        return this.getRandomDownloader(this.getSourceforgeDownloaders(project_name, filename));
    }
}

