/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPObjectNoLongerExistsException;

public class RPObject
implements Serializable {
    protected static transient Map object_registry = new WeakHashMap();
    protected static transient Map object_registry_reverse = new WeakHashMap();
    protected static transient long next_key = new Random().nextLong();
    public Long _object_id;
    protected transient Object __delegate;
    protected transient RPRequestDispatcher _dispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RPObject _lookupLocal(Object key) {
        Map map = object_registry;
        synchronized (map) {
            RPObject res = (RPObject)object_registry.get(key);
            if (res != null) {
                res._setLocal();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPObject _lookupLocal(long object_id) {
        Map map = object_registry;
        synchronized (map) {
            Object res = object_registry_reverse.get(new Long(object_id));
            if (res == null) {
                throw new RPObjectNoLongerExistsException();
            }
            RPObject obj = (RPObject)object_registry.get(res);
            if (obj == null) {
                throw new RPObjectNoLongerExistsException();
            }
            return obj;
        }
    }

    public RPObject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPObject(Object key) {
        Map map = object_registry;
        synchronized (map) {
            RPObject existing = (RPObject)object_registry.get(key);
            if (existing != null) {
                this._object_id = existing._object_id;
            } else {
                this._object_id = new Long(next_key++);
                object_registry.put(key, this);
                object_registry_reverse.put(this._object_id, key);
            }
        }
        this.__delegate = key;
        this._setDelegate(this.__delegate);
    }

    public long _getOID() {
        return this._object_id;
    }

    protected void _setDelegate(Object _delegate) {
        throw new RuntimeException("you've got to implement this - " + _delegate);
    }

    public Object _getDelegate() {
        return this.__delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _fixupLocal() throws RPException {
        Object res;
        Map map = object_registry;
        synchronized (map) {
            res = object_registry_reverse.get(this._object_id);
        }
        if (res == null) {
            throw new RPObjectNoLongerExistsException();
        }
        this._setDelegate(res);
        return res;
    }

    public void _setRemote(RPRequestDispatcher __dispatcher) {
        this._dispatcher = __dispatcher;
    }

    protected RPRequestDispatcher getDispatcher() {
        return this._dispatcher;
    }

    public RPReply _process(RPRequest request2) {
        throw new RuntimeException("you've got to implement this - " + request2);
    }

    public Object _setLocal() {
        throw new RuntimeException("you've got to implement this");
    }

    public void _refresh() {
        RPObject res = (RPObject)this._dispatcher.dispatch(new RPRequest(this, "_refresh", null)).getResponse();
        this._setDelegate(res);
    }

    public String _getName() {
        String str = this.getClass().getName();
        int dp = str.lastIndexOf(46);
        if (dp != -1) {
            str = str.substring(dp + 1);
        }
        if (str.startsWith("RP")) {
            str = str.substring(2);
        }
        return str;
    }

    public void notSupported() {
        throw new RuntimeException("RPObject:: method not supported");
    }

    public void notSupported(Object o) {
        throw new RuntimeException("RPObject:: method not supported - " + o);
    }
}

