/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.BadIp;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class BlockedIpsWindow {
    static AzureusCore azureus_core;
    static Shell instance;

    private BlockedIpsWindow() {
    }

    public static void show(AzureusCore _azureus_core, Display display, String ipsBlocked, String ipsBanned) {
        if (instance == null || instance.isDisposed()) {
            instance = BlockedIpsWindow.create(_azureus_core, display, ipsBlocked, ipsBanned);
            instance.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event2) {
                    instance = null;
                }
            });
        } else {
            instance.open();
        }
    }

    private static Shell create(AzureusCore _azureus_core, Display display, String ipsBlocked, String ipsBanned) {
        azureus_core = _azureus_core;
        int styles = Constants.isOSX ? 1264 : 68720;
        final Shell window = ShellFactory.createShell(display, styles);
        Messages.setLanguageText((Widget)window, "ConfigView.section.ipfilter.list.title");
        Utils.setShellIcon(window);
        FormLayout layout = new FormLayout();
        try {
            layout.spacing = 5;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        window.setLayout((Layout)layout);
        final StyledText textBlocked = new StyledText((Composite)window, 2816);
        Button btnClear = new Button((Composite)window, 8);
        textBlocked.setEditable(false);
        final StyledText textBanned = new StyledText((Composite)window, 2816);
        Button btnOk = new Button((Composite)window, 8);
        Button btnReset = new Button((Composite)window, 8);
        textBanned.setEditable(false);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(40, 0);
        Utils.setLayoutData((Control)textBlocked, formData);
        textBlocked.setText(ipsBlocked);
        Label blockedInfo = new Label((Composite)window, 0);
        Messages.setLanguageText((Widget)blockedInfo, "ConfigView.section.ipfilter.blockedinfo");
        formData = new FormData();
        formData.top = new FormAttachment((Control)textBlocked);
        formData.right = new FormAttachment((Control)btnClear);
        formData.left = new FormAttachment(0, 0);
        Utils.setLayoutData((Control)blockedInfo, formData);
        Messages.setLanguageText((Widget)btnClear, "Button.clear");
        formData = new FormData();
        formData.top = new FormAttachment((Control)textBlocked);
        formData.right = new FormAttachment(95, 0);
        formData.width = 70;
        Utils.setLayoutData((Control)btnClear, formData);
        btnClear.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                azureus_core.getIpFilterManager().getIPFilter().clearBlockedIPs();
                textBlocked.setText("");
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)btnClear);
        formData.bottom = new FormAttachment((Control)btnOk);
        Utils.setLayoutData((Control)textBanned, formData);
        textBanned.setText(ipsBanned);
        Label bannedInfo = new Label((Composite)window, 0);
        Messages.setLanguageText((Widget)bannedInfo, "ConfigView.section.ipfilter.bannedinfo");
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnReset);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        Utils.setLayoutData((Control)bannedInfo, formData);
        Messages.setLanguageText((Widget)btnReset, "Button.reset");
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnOk);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        Utils.setLayoutData((Control)btnReset, formData);
        btnReset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                azureus_core.getIpFilterManager().getIPFilter().clearBannedIps();
                azureus_core.getIpFilterManager().getBadIps().clearBadIps();
                textBanned.setText("");
            }
        });
        Messages.setLanguageText((Widget)btnOk, "Button.ok");
        formData = new FormData();
        formData.right = new FormAttachment(95, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        Utils.setLayoutData((Control)btnOk, formData);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                window.dispose();
            }
        });
        window.setDefaultButton(btnOk);
        window.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        });
        if (!Utils.linkShellMetricsToConfig(window, "BlockedIpsWindow")) {
            window.setSize(620, 450);
            if (!Constants.isOSX) {
                Utils.centreWindow(window);
            }
        }
        window.layout();
        window.open();
        return window;
    }

    public static void showBlockedIps(AzureusCore azureus_core, Shell mainWindow) {
        StringBuffer sbBlocked = new StringBuffer();
        StringBuffer sbBanned = new StringBuffer();
        BlockedIp[] blocked = azureus_core.getIpFilterManager().getIPFilter().getBlockedIps();
        String inRange = MessageText.getString("ConfigView.section.ipfilter.list.inrange");
        String notInRange = MessageText.getString("ConfigView.section.ipfilter.list.notinrange");
        String bannedMessage = MessageText.getString("ConfigView.section.ipfilter.list.banned");
        String badDataMessage = MessageText.getString("ConfigView.section.ipfilter.list.baddata");
        for (int i = 0; i < blocked.length; ++i) {
            BlockedIp bIp = blocked[i];
            if (!bIp.isLoggable()) continue;
            sbBlocked.append(DisplayFormatters.formatTimeStamp(bIp.getBlockedTime()));
            sbBlocked.append("\t[");
            sbBlocked.append(bIp.getTorrentName());
            sbBlocked.append("] \t");
            sbBlocked.append(bIp.getBlockedIp());
            IpRange range = bIp.getBlockingRange();
            if (range == null) {
                sbBlocked.append(' ');
                sbBlocked.append(notInRange);
                sbBlocked.append('\n');
                continue;
            }
            sbBlocked.append(' ');
            sbBlocked.append(inRange);
            sbBlocked.append(range.toString());
            sbBlocked.append('\n');
        }
        BannedIp[] banned_ips = azureus_core.getIpFilterManager().getIPFilter().getBannedIps();
        for (int i = 0; i < banned_ips.length; ++i) {
            BannedIp bIp = banned_ips[i];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getBanningTime()));
            sbBanned.append("\t[");
            sbBanned.append(bIp.getTorrentName());
            sbBanned.append("] \t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(bannedMessage);
            sbBanned.append("\n");
        }
        BadIp[] bad_ips = azureus_core.getIpFilterManager().getBadIps().getBadIps();
        for (int i = 0; i < bad_ips.length; ++i) {
            BadIp bIp = bad_ips[i];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getLastTime()));
            sbBanned.append("\t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(badDataMessage);
            sbBanned.append(" ");
            sbBanned.append(bIp.getNumberOfWarnings());
            sbBanned.append("\n");
        }
        if (mainWindow == null || mainWindow.isDisposed()) {
            return;
        }
        BlockedIpsWindow.show(azureus_core, mainWindow.getDisplay(), sbBlocked.toString(), sbBanned.toString());
    }
}

