/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.BrowserWrapperFake;
import org.gudy.azureus2.ui.swt.BrowserWrapperSWT;

public abstract class BrowserWrapper {
    public static BrowserWrapper createBrowser(Composite composite, int style) {
        AEDiagnostics.waitForDumpChecks(10000L);
        boolean use_fake = COConfigurationManager.getBooleanParameter("browser.internal.disable");
        if (use_fake) {
            return new BrowserWrapperFake(composite, style, null);
        }
        try {
            return new BrowserWrapperSWT(composite, style);
        }
        catch (SWTError error) {
            return new BrowserWrapperFake(composite, style, error);
        }
    }

    protected BrowserWrapper() {
    }

    public abstract boolean isFake();

    public abstract Composite getControl();

    public abstract void setBrowser(WindowEvent var1);

    public abstract void setVisible(boolean var1);

    public abstract boolean isVisible();

    public abstract boolean isDisposed();

    public abstract void dispose();

    public abstract boolean execute(String var1);

    public abstract boolean isBackEnabled();

    public abstract String getUrl();

    public abstract void setUrl(String var1);

    public abstract void setText(String var1);

    public abstract void setData(String var1, Object var2);

    public abstract Object getData(String var1);

    public abstract void back();

    public abstract void refresh();

    public abstract void update();

    public abstract Shell getShell();

    public abstract Display getDisplay();

    public abstract Composite getParent();

    public abstract Object getLayoutData();

    public abstract void setLayoutData(Object var1);

    public abstract void setFocus();

    public abstract void addListener(int var1, Listener var2);

    public abstract void addLocationListener(LocationListener var1);

    public abstract void removeLocationListener(LocationListener var1);

    public abstract void addTitleListener(TitleListener var1);

    public abstract void addProgressListener(ProgressListener var1);

    public abstract void removeProgressListener(ProgressListener var1);

    public abstract void addOpenWindowListener(OpenWindowListener var1);

    public abstract void addCloseWindowListener(CloseWindowListener var1);

    public abstract void addDisposeListener(DisposeListener var1);

    public abstract void removeDisposeListener(DisposeListener var1);

    public abstract void addStatusTextListener(StatusTextListener var1);

    public abstract void removeStatusTextListener(StatusTextListener var1);

    public abstract BrowserFunction addBrowserFunction(String var1, BrowserFunction var2);

    public static abstract class BrowserFunction {
        private BrowserFunction delegate;

        protected void bind(BrowserFunction _delegate) {
            this.delegate = _delegate;
        }

        public abstract Object function(Object[] var1);

        public boolean isDisposed() {
            if (this.delegate != null) {
                return this.delegate.isDisposed();
            }
            Debug.out("wrong");
            return false;
        }

        public void dispose() {
            if (this.delegate != null) {
                this.delegate.dispose();
            }
            Debug.out("wrong");
        }
    }
}

