/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.impl.AzureusCoreSingleInstanceClient;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;

public class StartServer {
    private static final LogIDs LOGID = LogIDs.GUI;
    private ServerSocket socket;
    private int state;
    private boolean bContinue;
    public static final int STATE_FAULTY = 0;
    public static final int STATE_LISTENING = 1;
    protected List queued_torrents = new ArrayList();
    protected boolean core_started = false;
    protected AEMonitor this_mon = new AEMonitor("StartServer");

    public StartServer() {
        try {
            this.socket = new ServerSocket(Constants.INSTANCE_PORT, 50, InetAddress.getByName("127.0.0.1"));
            this.state = 1;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "StartServer: listening on 127.0.0.1:" + Constants.INSTANCE_PORT + " for passed torrent info"));
            }
        }
        catch (Throwable t) {
            this.state = 0;
            String reason = t.getMessage() == null ? "<>" : t.getMessage();
            System.out.println("StartServer ERROR: unable to bind to 127.0.0.1:" + Constants.INSTANCE_PORT + " listening" + " for passed torrent info: " + reason);
        }
    }

    public void pollForConnections(final AzureusCore azureus_core) {
        azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof UIFunctionsSWT) {
                    StartServer.this.openQueuedTorrents();
                }
            }
        });
        if (this.socket != null) {
            AEThread t = new AEThread("Start Server"){

                public void runSupport() {
                    StartServer.this.pollForConnectionsSupport(azureus_core);
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void pollForConnectionsSupport(AzureusCore core) {
        this.bContinue = true;
        while (this.bContinue) {
            BufferedReader br = null;
            Socket sck = this.socket.accept();
            AzureusCoreSingleInstanceClient.sendReply(sck);
            String address = sck.getInetAddress().getHostAddress();
            if (address.equals("localhost") || address.equals("127.0.0.1")) {
                String[] args;
                br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                String line = br.readLine();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Main::startServer: received '" + line + "'"));
                }
                if (line != null && (args = StartServer.parseArgs(line)) != null && args.length > 0) {
                    String debug_str = args[0];
                    for (int i = 1; i < args.length; ++i) {
                        debug_str = debug_str + " ; " + args[i];
                    }
                    Logger.log(new LogEvent(LOGID, "Main::startServer: decoded to '" + debug_str + "'"));
                    this.processArgs(core, args);
                }
            }
            sck.close();
            Object var10_10 = null;
            try {
                if (br == null) continue;
                br.close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (Exception e) {
                    if (!(e instanceof SocketException)) {
                        Debug.printStackTrace(e);
                    }
                    var10_10 = null;
                    try {
                        if (br == null) continue;
                        br.close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_10 = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static String[] parseArgs(String line) {
        if (!line.startsWith("Azureus Start Server Access;")) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        boolean escape_mode = false;
        for (int i = "Azureus Start Server Access".length() + 1; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (escape_mode) {
                buf.append(c);
                escape_mode = false;
                continue;
            }
            if (c == '&') {
                escape_mode = true;
                continue;
            }
            if (c == ';') {
                parts.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            parts.add(buf.toString());
        }
        return parts.toArray(new String[parts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processArgs(AzureusCore core, String[] args) {
        if (args.length < 1 || !args[0].equals("args")) {
            return;
        }
        boolean showMainWindow = args.length == 1 || COConfigurationManager.getBooleanParameter("Activate Window On External Download");
        boolean open = true;
        for (int i = 1; i < args.length; ++i) {
            Object var14_14;
            String magnet_uri;
            String file_name;
            File file;
            String arg = args[i];
            if (i == 1) {
                UIFunctions uiFunctions;
                if (arg.equalsIgnoreCase("--closedown") || arg.equalsIgnoreCase("--shutdown")) {
                    try {
                        UpdateInstaller[] installers;
                        UpdateManager um = core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
                        for (UpdateInstaller installer : installers = um.getInstallers()) {
                            installer.destroy();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if ((uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                        uiFunctions.dispose(false, false);
                    }
                    return;
                }
                if (arg.equalsIgnoreCase("--restart")) {
                    uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.dispose(true, false);
                    }
                    return;
                }
                if (arg.equalsIgnoreCase("--open")) {
                    showMainWindow = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("--share")) {
                    showMainWindow = true;
                    open = false;
                    continue;
                }
            }
            if (!(file = new File(file_name = arg)).exists() && !this.isURI(file_name) && (magnet_uri = UrlUtils.normaliseMagnetURI(file_name)) != null) {
                file_name = magnet_uri;
            }
            if (this.isURI(file_name)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "StartServer: args[" + i + "] handling as a URI: " + file_name));
                }
            } else {
                try {
                    if (!file.exists()) {
                        throw new Exception("File not found");
                    }
                    file_name = file.getCanonicalPath();
                    Logger.log(new LogEvent(LOGID, "StartServer: file = " + file_name));
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(true, 3, "Failed to access torrent file '" + file_name + "'. Ensure sufficient temporary file space " + "available (check browser cache usage)."));
                }
            }
            boolean queued = false;
            try {
                this.this_mon.enter();
                if (!this.core_started) {
                    this.queued_torrents.add(new Object[]{file_name, new Boolean(open)});
                    queued = true;
                }
                var14_14 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var14_14 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (queued) continue;
            this.handleFile(file_name, open);
        }
        if (showMainWindow) {
            this.showMainWindow();
        }
    }

    protected boolean isURI(String file_name) {
        String file_name_lower = file_name.toLowerCase();
        return file_name_lower.startsWith("http:") || file_name_lower.startsWith("https:") || file_name_lower.startsWith("magnet:") || file_name_lower.startsWith("maggot:") || file_name_lower.startsWith("bc:") || file_name_lower.startsWith("bctp:") || file_name_lower.startsWith("dht:");
    }

    protected void handleFile(String file_name, boolean open) {
        try {
            if (open) {
                TorrentOpener.openTorrent(file_name);
            } else {
                File f = new File(file_name);
                if (f.isDirectory()) {
                    ShareUtils.shareDir(file_name);
                } else {
                    ShareUtils.shareFile(file_name);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openQueuedTorrents() {
        try {
            this.this_mon.enter();
            this.core_started = true;
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < this.queued_torrents.size(); ++i) {
            Object[] entry = (Object[])this.queued_torrents.get(i);
            String file_name = (String)entry[0];
            boolean open = (Boolean)entry[1];
            this.handleFile(file_name, open);
        }
    }

    protected void showMainWindow() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.bringToFront();
        }
    }

    public void stopIt() {
        this.bContinue = false;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getState() {
        return this.state;
    }

    public static void main(String[] args) {
        String[] input_tests = new String[]{"a;b;c", "test", "Azureus Start Server Access;b;c;d", "Azureus Start Server Access;b;c&;d;e", "Azureus Start Server Access;b;c&&;d;e", "Azureus Start Server Access;b;c&&&;d;e"};
        String[][] output_results = new String[][]{null, null, {"b", "c", "d"}, {"b", "c;d", "e"}, {"b", "c&", "d", "e"}, {"b", "c&;d", "e"}};
        for (int i = 0; i < input_tests.length; ++i) {
            System.out.println("Testing: " + input_tests[i]);
            Object[] result = StartServer.parseArgs(input_tests[i]);
            if (result == output_results[i] || Arrays.equals(result, output_results[i])) continue;
            System.out.println("TEST FAILED");
            System.out.println("  Expected: " + Arrays.asList(output_results[i]));
            System.out.println("  Decoded : " + Arrays.asList(result));
            System.exit(1);
        }
        System.out.println("Done.");
    }
}

