/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;

public class UserAlerts {
    private AudioClip audio_clip = null;
    private String audio_resource = "";
    private AEMonitor this_mon = new AEMonitor("UserAlerts");
    private boolean startup = true;
    private long last_error_speech;
    private long last_error_sound;

    public UserAlerts(GlobalManager global_manager) {
        final DownloadManagerAdapter download_manager_listener = new DownloadManagerAdapter(){

            public void downloadComplete(DownloadManager manager) {
                UserAlerts.this.activityFinished(manager, null);
            }

            public void stateChanged(final DownloadManager manager, int state) {
                boolean lowNoise = manager.getDownloadState().getFlag(16L);
                if (lowNoise) {
                    return;
                }
                if (state == 50 || state == 60) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            boolean complete = manager.isDownloadComplete(false);
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Details") || complete && COConfigurationManager.getBooleanParameter("Open Seeding Details")) {
                                UIFunctionsManager.getUIFunctions().getMDI().loadEntryByID("DMDetails", false, false, manager);
                            }
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Bar Incomplete") || complete && COConfigurationManager.getBooleanParameter("Open Bar Complete")) {
                                DownloadBar.open(manager, Utils.findAnyShell());
                            }
                        }
                    });
                }
                boolean error_reported = manager.getDownloadState().getFlag(2048L);
                if (state == 100) {
                    if (!error_reported) {
                        manager.getDownloadState().setFlag(2048L, true);
                        UserAlerts.this.reportError(manager);
                    }
                } else if ((state == 50 || state == 60) && error_reported) {
                    manager.getDownloadState().setFlag(2048L, false);
                }
            }
        };
        final DiskManagerListener disk_listener = new DiskManagerListener(){

            public void stateChanged(int oldState, int newState) {
            }

            public void filePriorityChanged(DiskManagerFileInfo file) {
            }

            public void pieceDoneChanged(DiskManagerPiece piece) {
            }

            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                DownloadManager dm = file.getDownloadManager();
                if (dm != null && old_mode == 2 && new_mode == 1 && file.getDownloaded() == file.getLength()) {
                    UserAlerts.this.activityFinished(dm, file);
                }
            }
        };
        final DownloadManagerDiskListener dm_disk_listener = new DownloadManagerDiskListener(){

            public void diskManagerAdded(DiskManager dm) {
                dm.addListener(disk_listener);
            }

            public void diskManagerRemoved(DiskManager dm) {
                dm.removeListener(disk_listener);
            }
        };
        global_manager.addListener(new GlobalManagerAdapter(){

            public void downloadManagerAdded(DownloadManager manager) {
                boolean bPopup;
                if (!UserAlerts.this.startup && manager.isPersistent() && (bPopup = COConfigurationManager.getBooleanParameter("Popup Download Added")) && !manager.getDownloadState().getFlag(16L)) {
                    String popup_text = MessageText.getString("popup.download.added", new String[]{manager.getDisplayName()});
                    UIFunctionsManager.getUIFunctions().forceNotify(0, null, popup_text, null, new Object[]{manager}, -1);
                }
                manager.addListener(download_manager_listener);
                manager.addDiskListener(dm_disk_listener);
            }

            public void downloadManagerRemoved(DownloadManager manager) {
                manager.removeListener(download_manager_listener);
                manager.removeDiskListener(dm_disk_listener);
            }

            public void destroyed() {
                UserAlerts.this.tidyUp();
            }
        });
        this.startup = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void activityFinished(DownloadManager manager, DiskManagerFileInfo dm_file) {
        String popup_def_text;
        String popup_enabler;
        String speech_text;
        String speech_enabler;
        String sound_file;
        String sound_enabler;
        String item_name;
        Object relatedObject;
        boolean download;
        DownloadManagerState dm_state = manager.getDownloadState();
        if (dm_state.getFlag(16L)) {
            return;
        }
        boolean bl = download = dm_file == null;
        if (download) {
            relatedObject = manager;
            item_name = manager.getDisplayName();
        } else {
            relatedObject = dm_file.getDiskManager();
            item_name = dm_file.getFile(true).getName();
        }
        String default_sound = "org/gudy/azureus2/ui/icons/downloadFinished.wav";
        if (download) {
            sound_enabler = "Play Download Finished";
            sound_file = "Play Download Finished File";
            speech_enabler = "Play Download Finished Announcement";
            speech_text = "Play Download Finished Announcement Text";
            popup_enabler = "Popup Download Finished";
            popup_def_text = "popup.download.finished";
        } else {
            sound_enabler = "Play File Finished";
            sound_file = "Play File Finished File";
            speech_enabler = "Play File Finished Announcement";
            speech_text = "Play File Finished Announcement Text";
            popup_enabler = "Popup File Finished";
            popup_def_text = "popup.file.finished";
        }
        Map dl_file_alerts = dm_state.getMapAttribute("df_alerts");
        String dlf_prefix = download ? "" : String.valueOf(dm_file.getIndex()) + ".";
        try {
            block21: {
                try {
                    this.this_mon.enter();
                    if (COConfigurationManager.getBooleanParameter(popup_enabler) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, popup_enabler)) {
                        String popup_text = MessageText.getString(popup_def_text, new String[]{item_name});
                        UIFunctionsManager.getUIFunctions().forceNotify(0, null, popup_text, null, new Object[]{relatedObject}, -1);
                    }
                    if (Constants.isOSX && (COConfigurationManager.getBooleanParameter(speech_enabler) || this.isDLFEnabled(dl_file_alerts, dlf_prefix, speech_enabler))) {
                        new AEThread2("SaySound"){

                            public void run() {
                                try {
                                    Runtime.getRuntime().exec(new String[]{"say", COConfigurationManager.getStringParameter(speech_text)});
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                    if (!COConfigurationManager.getBooleanParameter(sound_enabler, false) && !this.isDLFEnabled(dl_file_alerts, dlf_prefix, sound_enabler)) break block21;
                    String file = COConfigurationManager.getStringParameter(sound_file);
                    if ((file = file.trim()).startsWith("<")) {
                        file = "";
                    }
                    if (this.audio_clip == null || !file.equals(this.audio_resource)) {
                        block23: {
                            this.audio_clip = null;
                            if (file.length() != 0) {
                                File f = new File(file);
                                try {
                                    block22: {
                                        try {
                                            if (!f.exists()) break block22;
                                            URL file_url = f.toURI().toURL();
                                            this.audio_clip = Applet.newAudioClip(file_url);
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            Object var20_22 = null;
                                            if (this.audio_clip == null) {
                                                Logger.log(new LogAlert(relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                                            }
                                            break block23;
                                        }
                                    }
                                    Object var20_21 = null;
                                    if (this.audio_clip != null) break block23;
                                }
                                catch (Throwable throwable) {
                                    Object var20_23 = null;
                                    if (this.audio_clip != null) throw throwable;
                                    Logger.log(new LogAlert(relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                                    throw throwable;
                                }
                                Logger.log(new LogAlert(relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                            }
                        }
                        if (this.audio_clip == null) {
                            this.audio_clip = Applet.newAudioClip(UserAlerts.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/downloadFinished.wav"));
                        }
                        this.audio_resource = file;
                    }
                    if (this.audio_clip != null) {
                        new AEThread2("DownloadSound"){

                            public void run() {
                                try {
                                    UserAlerts.this.audio_clip.play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Object var22_26 = null;
                    this.this_mon.exit();
                    return;
                }
            }
            Object var22_25 = null;
            this.this_mon.exit();
            return;
        }
        catch (Throwable throwable) {
            Object var22_27 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reportError(DownloadManager manager) {
        final DownloadManager relatedObject = manager;
        final String item_name = manager.getDisplayName();
        String default_sound = "org/gudy/azureus2/ui/icons/downloadFinished.wav";
        String sound_enabler = "Play Download Error";
        String sound_file = "Play Download Error File";
        String speech_enabler = "Play Download Error Announcement";
        String speech_text = "Play Download Error Announcement Text";
        String popup_enabler = "Popup Download Error";
        String popup_def_text = "popup.download.error";
        try {
            block16: {
                try {
                    this.this_mon.enter();
                    if (COConfigurationManager.getBooleanParameter("Popup Download Error")) {
                        UIFunctionsManager.execWithUIFunctions(new UIFunctionsManager.UIFCallback(){

                            public void run(UIFunctions functions) {
                                String popup_text = MessageText.getString("popup.download.error", new String[]{item_name});
                                functions.forceNotify(2, null, popup_text, null, new Object[]{relatedObject}, -1);
                            }
                        });
                    }
                    long now = SystemTime.getMonotonousTime();
                    if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Play Download Error Announcement") && (this.last_error_speech == 0L || now - this.last_error_speech > 5000L)) {
                        this.last_error_speech = now;
                        new AEThread2("SaySound"){

                            public void run() {
                                try {
                                    Runtime.getRuntime().exec(new String[]{"say", COConfigurationManager.getStringParameter("Play Download Error Announcement Text")});
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                    if (!COConfigurationManager.getBooleanParameter("Play Download Error", false) || this.last_error_sound != 0L && now - this.last_error_sound <= 5000L) break block16;
                    this.last_error_sound = now;
                    String file = COConfigurationManager.getStringParameter("Play Download Error File");
                    if ((file = file.trim()).startsWith("<")) {
                        file = "";
                    }
                    if (this.audio_clip == null || !file.equals(this.audio_resource)) {
                        block18: {
                            this.audio_clip = null;
                            if (file.length() != 0) {
                                File f = new File(file);
                                try {
                                    block17: {
                                        try {
                                            if (!f.exists()) break block17;
                                            URL file_url = f.toURI().toURL();
                                            this.audio_clip = Applet.newAudioClip(file_url);
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            Object var17_18 = null;
                                            if (this.audio_clip == null) {
                                                Logger.log(new LogAlert((Object)relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                                            }
                                            break block18;
                                        }
                                    }
                                    Object var17_17 = null;
                                    if (this.audio_clip != null) break block18;
                                }
                                catch (Throwable throwable) {
                                    Object var17_19 = null;
                                    if (this.audio_clip != null) throw throwable;
                                    Logger.log(new LogAlert((Object)relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                                    throw throwable;
                                }
                                Logger.log(new LogAlert((Object)relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                            }
                        }
                        if (this.audio_clip == null) {
                            this.audio_clip = Applet.newAudioClip(UserAlerts.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/downloadFinished.wav"));
                        }
                        this.audio_resource = file;
                    }
                    if (this.audio_clip != null) {
                        new AEThread2("DownloadSound"){

                            public void run() {
                                try {
                                    UserAlerts.this.audio_clip.play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Object var19_22 = null;
                    this.this_mon.exit();
                    return;
                }
            }
            Object var19_21 = null;
            this.this_mon.exit();
            return;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    private boolean isDLFEnabled(Map map, String prefix, String key) {
        if (map == null) {
            return false;
        }
        key = prefix + key;
        return map.containsKey(key);
    }

    protected void tidyUp() {
        try {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            Thread[] threadList = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadList);
            for (int i = 0; i < threadList.length; ++i) {
                if (threadList[i] == null || !"Java Sound event dispatcher".equals(threadList[i].getName())) continue;
                threadList[i].interrupt();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void requestUserAttention(int type, Object data) {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (pm.hasCapability(PlatformManagerCapabilities.RequestUserAttention)) {
            try {
                pm.requestUserAttention(type, data);
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

