/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.bouncycastle.util.encoders.Base64;

public class AuthenticatorWindow
implements SEPasswordListener {
    private static final String CONFIG_PARAM = "swt.auth.persistent.cache";
    protected Map auth_cache = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("AuthWind");

    public AuthenticatorWindow() {
        SESecurityManager.addPasswordListener(this);
        Map cache = COConfigurationManager.getMapParameter(CONFIG_PARAM, new HashMap());
        try {
            for (Map.Entry entry : cache.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                String user = new String((byte[])value.get("user"), "UTF-8");
                char[] pw = new String((byte[])value.get("pw"), "UTF-8").toCharArray();
                this.auth_cache.put(key, new authCache(key, new PasswordAuthentication(user, pw), true));
            }
        }
        catch (Throwable e) {
            COConfigurationManager.setParameter(CONFIG_PARAM, new HashMap());
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAuthCache() {
        try {
            this.this_mon.enter();
            HashMap map = new HashMap();
            for (authCache value : this.auth_cache.values()) {
                if (!value.isPersistent()) continue;
                try {
                    HashMap<String, byte[]> entry_map = new HashMap<String, byte[]>();
                    entry_map.put("user", value.getAuth().getUserName().getBytes("UTF-8"));
                    entry_map.put("pw", new String(value.getAuth().getPassword()).getBytes("UTF-8"));
                    map.put(value.getKey(), entry_map);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            COConfigurationManager.setParameter(CONFIG_PARAM, map);
            Object var6_6 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPasswords() {
        try {
            this.this_mon.enter();
            this.auth_cache = new HashMap();
            this.saveAuthCache();
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        try {
            this.this_mon.enter();
            PasswordAuthentication passwordAuthentication = this.getAuthentication(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort());
            Object var5_4 = null;
            this.this_mon.exit();
            return passwordAuthentication;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
        try {
            this.this_mon.enter();
            this.setAuthenticationOutcome(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort(), success);
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationOutcome(String realm, String protocol, String host, int port, boolean success) {
        try {
            this.this_mon.enter();
            String tracker = protocol + "://" + host + ":" + port + "/";
            String auth_key = realm + ":" + tracker;
            authCache cache = (authCache)this.auth_cache.get(auth_key);
            if (cache != null) {
                cache.setOutcome(success);
            }
            Object var10_9 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        PasswordAuthentication passwordAuthentication;
        block11: {
            PasswordAuthentication passwordAuthentication2;
            block10: {
                PasswordAuthentication passwordAuthentication3;
                block9: {
                    try {
                        boolean save_pw;
                        boolean old_entry_existed;
                        PasswordAuthentication auth;
                        String auth_key;
                        authCache cache;
                        String tracker;
                        block8: {
                            this.this_mon.enter();
                            tracker = protocol + "://" + host + ":" + port + "/";
                            InetAddress bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                            String self_addr = bind_ip == null || bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
                            if (host.equals(self_addr) || host.equals(COConfigurationManager.getStringParameter("Tracker IP", ""))) {
                                PasswordAuthentication passwordAuthentication4;
                                try {
                                    byte[] pw = COConfigurationManager.getByteParameter("Tracker Password", new byte[0]);
                                    String str_pw = new String(Base64.encode(pw));
                                    passwordAuthentication4 = new PasswordAuthentication("<internal>", str_pw.toCharArray());
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    break block8;
                                }
                                Object var16_15 = null;
                                this.this_mon.exit();
                                return passwordAuthentication4;
                            }
                        }
                        if ((cache = (authCache)this.auth_cache.get(auth_key = realm + ":" + tracker)) != null && (auth = cache.getAuth()) != null) {
                            passwordAuthentication3 = auth;
                            break block9;
                        }
                        String[] res = this.getAuthenticationDialog(realm, tracker);
                        if (res == null) {
                            passwordAuthentication2 = null;
                            break block10;
                        }
                        PasswordAuthentication auth2 = new PasswordAuthentication(res[0], res[1].toCharArray());
                        boolean bl = old_entry_existed = this.auth_cache.put(auth_key, new authCache(auth_key, auth2, save_pw = res[2].equals("true"))) != null;
                        if (save_pw || old_entry_existed) {
                            this.saveAuthCache();
                        }
                        passwordAuthentication = auth2;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var16_19 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                Object var16_16 = null;
                this.this_mon.exit();
                return passwordAuthentication3;
            }
            Object var16_17 = null;
            this.this_mon.exit();
            return passwordAuthentication2;
        }
        Object var16_18 = null;
        this.this_mon.exit();
        return passwordAuthentication;
    }

    protected String[] getAuthenticationDialog(final String realm, final String location) {
        String persist;
        String details;
        boolean is_tracker;
        final Display display = SWTThread.getInstance().getDisplay();
        if (display.isDisposed()) {
            return null;
        }
        final AESemaphore sem = new AESemaphore("SWTAuth");
        final authDialog[] dialog = new authDialog[1];
        TOTorrent torrent = TorrentUtils.getTLSTorrent();
        if (torrent == null) {
            is_tracker = false;
            details = TorrentUtils.getTLSDescription();
        } else {
            details = TorrentUtils.getLocalisedName(torrent);
            is_tracker = true;
        }
        try {
            if (display.getThread() == Thread.currentThread()) {
                dialog[0] = new authDialog(sem, display, realm, is_tracker, location, details);
                while (!display.isDisposed() && !sem.isReleasedForever()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (display.isDisposed()) {
                    return null;
                }
            } else {
                display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        dialog[0] = new authDialog(sem, display, realm, is_tracker, location, details);
                    }
                });
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
        sem.reserve();
        String user = dialog[0].getUsername();
        String pw = dialog[0].getPassword();
        String string = persist = dialog[0].savePassword() ? "true" : "false";
        if (user == null) {
            return null;
        }
        return new String[]{user, pw == null ? "" : pw, persist};
    }

    protected class authCache {
        private String key;
        private PasswordAuthentication auth;
        private boolean persist;
        private int life = 5;
        private boolean succeeded;

        protected authCache(String _key, PasswordAuthentication _auth, boolean _persist) {
            this.key = _key;
            this.auth = _auth;
            this.persist = _persist;
        }

        protected String getKey() {
            return this.key;
        }

        protected boolean isPersistent() {
            return this.persist;
        }

        protected void setOutcome(boolean success) {
            if (success) {
                this.succeeded = true;
            } else {
                if (this.persist) {
                    this.persist = false;
                    AuthenticatorWindow.this.saveAuthCache();
                }
                if (!this.succeeded) {
                    this.auth = null;
                }
            }
        }

        protected PasswordAuthentication getAuth() {
            if (this.succeeded) {
                return this.auth;
            }
            --this.life;
            if (this.life >= 0) {
                return this.auth;
            }
            if (this.persist) {
                this.persist = false;
                AuthenticatorWindow.this.saveAuthCache();
            }
            return null;
        }
    }

    protected class authDialog {
        private Shell shell;
        private AESemaphore sem;
        private String username;
        private String password;
        private boolean persist;

        protected authDialog(AESemaphore _sem, Display display, String realm, boolean is_tracker, String target, String details) {
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.releaseForever();
                return;
            }
            final String ignore_key = "IgnoreAuth:" + realm + ":" + target + ":" + details.hashCode();
            if (RememberedDecisionsManager.getRememberedDecision(ignore_key) == 1) {
                Debug.out("Authentication for " + realm + "/" + target + "/" + details + " ignored as told not to ask again");
                this.sem.releaseForever();
                return;
            }
            String old_ignore_key = "IgnoreAuth:" + realm + ":" + target + ":" + details;
            int old_decision = RememberedDecisionsManager.getRememberedDecision(old_ignore_key);
            if (old_decision >= 0) {
                RememberedDecisionsManager.setRemembered(old_ignore_key, -1);
            }
            if (old_decision == 1) {
                Debug.out("Authentication for " + realm + "/" + target + "/" + details + " ignored as told not to ask again");
                this.sem.releaseForever();
                return;
            }
            this.shell = ShellFactory.createMainShell(67680);
            Utils.setShellIcon(this.shell);
            Messages.setLanguageText((Widget)this.shell, "authenticator.title");
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label realm_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)realm_label, "authenticator.realm");
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)realm_label, gridData);
            Label realm_value = new Label((Composite)this.shell, 0);
            realm_value.setText(realm.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)realm_value, gridData);
            Label target_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)target_label, is_tracker ? "authenticator.tracker" : "authenticator.location");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)target_label, gridData);
            Label target_value = new Label((Composite)this.shell, 0);
            target_value.setText(target.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)target_value, gridData);
            if (details != null) {
                Label details_label = new Label((Composite)this.shell, 0);
                Messages.setLanguageText((Widget)details_label, is_tracker ? "authenticator.torrent" : "authenticator.details");
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                Utils.setLayoutData((Control)details_label, gridData);
                Label details_value = new Label((Composite)this.shell, 0);
                details_value.setText(details.replaceAll("&", "&&"));
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                Utils.setLayoutData((Control)details_value, gridData);
            }
            Label user_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)user_label, "authenticator.user");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)user_label, gridData);
            final Text user_value = new Text((Composite)this.shell, 2048);
            user_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)user_value, gridData);
            user_value.addListener(24, new Listener(){

                public void handleEvent(Event event2) {
                    authDialog.this.username = user_value.getText();
                }
            });
            Label password_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)password_label, "authenticator.password");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)password_label, gridData);
            final Text password_value = new Text((Composite)this.shell, 2048);
            password_value.setEchoChar('*');
            password_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)password_value, gridData);
            password_value.addListener(24, new Listener(){

                public void handleEvent(Event event2) {
                    authDialog.this.password = password_value.getText();
                }
            });
            Label blank_label = new Label((Composite)this.shell, 0);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)blank_label, gridData);
            final Button checkBox = new Button((Composite)this.shell, 32);
            checkBox.setText(MessageText.getString("authenticator.savepassword"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)checkBox, gridData);
            checkBox.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    authDialog.this.persist = checkBox.getSelection();
                }
            });
            final Button dontAsk = new Button((Composite)this.shell, 32);
            dontAsk.setText(MessageText.getString("general.dont.ask.again"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            Utils.setLayoutData((Control)dontAsk, gridData);
            dontAsk.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RememberedDecisionsManager.setRemembered(ignore_key, dontAsk.getSelection() ? 1 : 0);
                }
            });
            Label labelSeparator = new Label((Composite)this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            Utils.setLayoutData((Control)labelSeparator, gridData);
            new Label((Composite)this.shell, 0);
            Button bOk = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bOk, "Button.ok");
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bOk, gridData);
            bOk.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    authDialog.this.close(true);
                }
            });
            Button bCancel = new Button((Composite)this.shell, 8);
            Messages.setLanguageText((Widget)bCancel, "Button.cancel");
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            Utils.setLayoutData((Control)bCancel, gridData);
            bCancel.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    authDialog.this.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        authDialog.this.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            if (ok) {
                if (this.username == null) {
                    this.username = "";
                }
                if (this.password == null) {
                    this.password = "";
                }
            } else {
                this.username = null;
                this.password = null;
            }
            this.shell.dispose();
            this.sem.releaseForever();
        }

        protected String getUsername() {
            return this.username;
        }

        protected String getPassword() {
            return this.password;
        }

        protected boolean savePassword() {
            return this.persist;
        }
    }
}

