/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.ui.swt.Utils;

public class BubbleTextBox {
    private Text textWidget;
    private Composite cBubble;
    private static final int PADDING_VERTICAL = 2;
    private int WIDTH_OVAL;
    private int HEIGHT_OVAL;
    private int INDENT_OVAL;
    private int HEIGHT_ICON_MAX;
    private int WIDTH_CLEAR;
    private int WIDTH_PADDING;
    private String text = "";

    public BubbleTextBox(Composite parent, int style) {
        this.cBubble = new Composite(parent, 0x20000000);
        this.cBubble.setLayout((Layout)new FormLayout());
        this.textWidget = new Text(this.cBubble, style & 0xFFFFF77F);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 2);
        fd.bottom = new FormAttachment(100, -2);
        fd.left = new FormAttachment(0, 17);
        fd.right = new FormAttachment(100, -15);
        Utils.setLayoutData((Control)this.textWidget, fd);
        this.WIDTH_OVAL = Utils.adjustPXForDPI(7);
        this.HEIGHT_OVAL = Utils.adjustPXForDPI(6);
        this.INDENT_OVAL = Utils.adjustPXForDPI(6);
        this.HEIGHT_ICON_MAX = Utils.adjustPXForDPI(12);
        this.WIDTH_CLEAR = Utils.adjustPXForDPI(7);
        this.WIDTH_PADDING = Utils.adjustPXForDPI(6);
        this.cBubble.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                boolean textIsBlank;
                Rectangle clientArea = BubbleTextBox.this.cBubble.getClientArea();
                if (Utils.isGTK) {
                    e.gc.setBackground(e.display.getSystemColor(25));
                } else {
                    e.gc.setBackground(BubbleTextBox.this.textWidget.getBackground());
                }
                e.gc.setAdvanced(true);
                e.gc.setAntialias(1);
                e.gc.fillRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, clientArea.height, clientArea.height);
                e.gc.setAlpha(127);
                e.gc.drawRoundRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1, clientArea.height, clientArea.height);
                e.gc.setAlpha(255);
                e.gc.setLineCap(1);
                int iconHeight = clientArea.height - Utils.adjustPXForDPI(9);
                if (iconHeight > BubbleTextBox.this.HEIGHT_ICON_MAX) {
                    iconHeight = BubbleTextBox.this.HEIGHT_ICON_MAX;
                }
                int iconY = clientArea.y + (clientArea.height - iconHeight + 1) / 2;
                Color colorClearX = e.display.getSystemColor(18);
                e.gc.setForeground(colorClearX);
                e.gc.setLineWidth(Utils.adjustPXForDPI(2));
                e.gc.drawOval(clientArea.x + BubbleTextBox.this.INDENT_OVAL, iconY, BubbleTextBox.this.WIDTH_OVAL, BubbleTextBox.this.HEIGHT_OVAL);
                e.gc.drawPolyline(new int[]{clientArea.x + BubbleTextBox.this.INDENT_OVAL + BubbleTextBox.this.INDENT_OVAL, iconY + BubbleTextBox.this.INDENT_OVAL, clientArea.x + (int)((double)BubbleTextBox.this.INDENT_OVAL * 2.6), iconY + iconHeight});
                boolean bl = textIsBlank = BubbleTextBox.this.textWidget.getText().length() == 0;
                if (!textIsBlank) {
                    int YADJ = (clientArea.height - (BubbleTextBox.this.WIDTH_CLEAR + BubbleTextBox.this.WIDTH_PADDING + BubbleTextBox.this.WIDTH_PADDING)) / 2;
                    e.gc.setLineCap(2);
                    Rectangle rXArea = new Rectangle(clientArea.x + clientArea.width - (BubbleTextBox.this.WIDTH_CLEAR + BubbleTextBox.this.WIDTH_PADDING), clientArea.y + BubbleTextBox.this.WIDTH_PADDING / 2, BubbleTextBox.this.WIDTH_CLEAR + BubbleTextBox.this.WIDTH_PADDING / 2, clientArea.height - BubbleTextBox.this.WIDTH_PADDING);
                    BubbleTextBox.this.cBubble.setData("XArea", (Object)rXArea);
                    e.gc.drawPolyline(new int[]{clientArea.x + clientArea.width - BubbleTextBox.this.WIDTH_PADDING, clientArea.y + BubbleTextBox.this.WIDTH_PADDING + YADJ, clientArea.x + clientArea.width - (BubbleTextBox.this.WIDTH_PADDING + BubbleTextBox.this.WIDTH_CLEAR), clientArea.y + BubbleTextBox.this.WIDTH_PADDING + BubbleTextBox.this.WIDTH_CLEAR + YADJ});
                    e.gc.drawPolyline(new int[]{clientArea.x + clientArea.width - BubbleTextBox.this.WIDTH_PADDING, clientArea.y + BubbleTextBox.this.WIDTH_PADDING + BubbleTextBox.this.WIDTH_CLEAR + YADJ, clientArea.x + clientArea.width - (BubbleTextBox.this.WIDTH_PADDING + BubbleTextBox.this.WIDTH_CLEAR), clientArea.y + BubbleTextBox.this.WIDTH_PADDING + YADJ});
                }
            }
        });
        this.cBubble.addListener(3, new Listener(){

            public void handleEvent(Event event2) {
                Rectangle r = (Rectangle)event2.widget.getData("XArea");
                if (r != null && r.contains(event2.x, event2.y)) {
                    BubbleTextBox.this.textWidget.setText("");
                }
            }
        });
        this.textWidget.addPaintListener(new PaintListener(){
            private Color existing_bg;

            public void paintControl(PaintEvent arg0) {
                Color current_bg = BubbleTextBox.this.textWidget.getBackground();
                if (!current_bg.equals((Object)this.existing_bg)) {
                    this.existing_bg = current_bg;
                    BubbleTextBox.this.cBubble.redraw();
                }
            }
        });
        this.textWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean textIsBlank;
                boolean textWasBlank = BubbleTextBox.this.text.length() == 0;
                BubbleTextBox.this.text = BubbleTextBox.this.textWidget.getText();
                boolean bl = textIsBlank = BubbleTextBox.this.text.length() == 0;
                if (textWasBlank != textIsBlank && BubbleTextBox.this.cBubble != null) {
                    BubbleTextBox.this.cBubble.redraw();
                }
            }
        });
    }

    public Composite getParent() {
        return this.cBubble;
    }

    public Text getTextWidget() {
        return this.textWidget;
    }
}

