/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class LinkArea {
    private StyledText styled_text;
    private ArrayList links = new ArrayList();
    private int ofs;
    private String relative_url_base = "";

    public LinkArea(Composite comp2) {
        this.styled_text = new StyledText(comp2, 2824);
        this.styled_text.setWordWrap(true);
        this.styled_text.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                if (LinkArea.this.links.size() == 0) {
                    return;
                }
                try {
                    int ofs = LinkArea.this.styled_text.getOffsetAtLocation(new Point(event2.x, event2.y));
                    for (int i = 0; i < LinkArea.this.links.size(); ++i) {
                        linkInfo linkInfo2 = (linkInfo)LinkArea.this.links.get(i);
                        if (ofs < linkInfo2.ofsStart || ofs > linkInfo2.ofsEnd) continue;
                        Utils.launch(linkInfo2.url);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        final Cursor handCursor = new Cursor((Device)comp2.getDisplay(), 21);
        this.styled_text.addListener(5, new Listener(){
            Cursor curCursor = null;

            public void handleEvent(Event event2) {
                if (LinkArea.this.links.size() == 0) {
                    return;
                }
                boolean onLink = false;
                try {
                    int ofs = LinkArea.this.styled_text.getOffsetAtLocation(new Point(event2.x, event2.y));
                    for (int i = 0; i < LinkArea.this.links.size(); ++i) {
                        linkInfo linkInfo2 = (linkInfo)LinkArea.this.links.get(i);
                        if (ofs < linkInfo2.ofsStart || ofs > linkInfo2.ofsEnd) continue;
                        onLink = true;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Cursor cursor;
                    Cursor cursor2 = cursor = onLink ? handCursor : null;
                    if (this.curCursor != cursor) {
                        LinkArea.this.styled_text.setCursor(cursor);
                        this.curCursor = cursor;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.styled_text.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                LinkArea.this.styled_text.setCursor(null);
                handCursor.dispose();
            }
        });
    }

    public Composite getComponent() {
        return this.styled_text;
    }

    public void reset() {
        if (this.styled_text.isDisposed()) {
            return;
        }
        this.ofs = 0;
        this.styled_text.setText("");
        this.links.clear();
    }

    public void setRelativeURLBase(String str) {
        this.relative_url_base = str;
    }

    public void addLine(String line) {
        if (this.styled_text.isDisposed()) {
            return;
        }
        try {
            line = HTMLUtils.expand(line);
            Object[] url_details = HTMLUtils.getLinks(line);
            String modified_line = (String)url_details[0];
            this.styled_text.append(modified_line + "\n");
            List urls = (List)url_details[1];
            for (int i = 0; i < urls.size(); ++i) {
                Object[] entry = (Object[])urls.get(i);
                String url = (String)entry[0];
                int[] det = (int[])entry[1];
                if (!url.toLowerCase().startsWith("http") && this.relative_url_base.length() > 0) {
                    url = this.relative_url_base + url;
                }
                linkInfo info = new linkInfo(this.ofs + det[0], this.ofs + det[0] + det[1], url);
                this.links.add(info);
                StyleRange sr = new StyleRange();
                sr.start = info.ofsStart;
                sr.length = info.ofsEnd - info.ofsStart;
                sr.underline = true;
                sr.foreground = Colors.blue;
                this.styled_text.setStyleRange(sr);
            }
            this.ofs += modified_line.length() + 1;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.styled_text.append(line + "\n");
        }
    }

    public static class linkInfo {
        int ofsStart;
        int ofsEnd;
        String url;

        linkInfo(int s, int e, String url) {
            this.ofsStart = s;
            this.ofsEnd = e;
            this.url = url;
        }
    }
}

