/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class LinkLabel {
    private final Label linkLabel;

    public LinkLabel(Composite composite, String resource, String link) {
        this(composite, new GridData(), resource, link);
    }

    public LinkLabel(Composite composite, GridData gridData, String resource, String link) {
        this.linkLabel = new Label(composite, 0);
        Messages.setLanguageText((Widget)this.linkLabel, resource);
        this.linkLabel.setLayoutData((Object)gridData);
        LinkLabel.makeLinkedLabel(this.linkLabel, link);
    }

    public Label getlabel() {
        return this.linkLabel;
    }

    public static void makeLinkedLabel(Label label, String hyperlink) {
        label.setData((Object)hyperlink);
        String tooltip = label.getToolTipText();
        if (tooltip == null && !hyperlink.equals(label.getText())) {
            label.setToolTipText(hyperlink.replaceAll("&", "&&"));
        }
        label.setCursor(label.getDisplay().getSystemCursor(21));
        label.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            public void mouseUp(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
        ClipboardCopy.addCopyToClipMenu((Control)label);
    }

    public static void updateLinkedLabel(Label label, String hyperlink) {
        label.setData((Object)hyperlink);
        label.setToolTipText(hyperlink);
    }
}

