/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.ui.swt.components.graphics.Graphic;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class BackGroundGraphic
implements Graphic {
    protected Canvas drawCanvas;
    protected Image bufferBackground;
    protected Color lightGrey;
    protected Color lightGrey2;
    protected Color colorWhite;
    protected AEMonitor this_mon = new AEMonitor("BackGroundGraphic");
    private boolean isSIIECSensitive;

    protected void setSIIECSensitive(boolean b) {
        this.isSIIECSensitive = b;
    }

    public void initialize(Canvas canvas) {
        this.drawCanvas = canvas;
        this.lightGrey = ColorCache.getColor((Device)canvas.getDisplay(), 250, 250, 250);
        this.lightGrey2 = ColorCache.getColor((Device)canvas.getDisplay(), 233, 233, 233);
        this.colorWhite = ColorCache.getColor((Device)canvas.getDisplay(), 255, 255, 255);
        Menu menu = new Menu((Control)canvas);
        final MenuItem mi_binary = new MenuItem(menu, 32);
        mi_binary.setText(MessageText.getString("label.binary.scale.basis"));
        mi_binary.setSelection(COConfigurationManager.getBooleanParameter("ui.scaled.graphics.binary.based"));
        mi_binary.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                COConfigurationManager.setParameter("ui.scaled.graphics.binary.based", mi_binary.getSelection());
            }
        });
        if (this.isSIIECSensitive) {
            final MenuItem mi_iec = new MenuItem(menu, 32);
            mi_iec.setText(MessageText.getString("ConfigView.section.style.useSIUnits"));
            mi_iec.setSelection(COConfigurationManager.getBooleanParameter("config.style.useSIUnits"));
            mi_iec.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    COConfigurationManager.setParameter("config.style.useSIUnits", mi_iec.getSelection());
                }
            });
        }
        canvas.setMenu(menu);
    }

    public void refresh(boolean force) {
    }

    protected void drawBackGround(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        if (sizeChanged || this.bufferBackground == null) {
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.height < 30 || bounds.width < 100) {
                return;
            }
            if (this.bufferBackground != null && !this.bufferBackground.isDisposed()) {
                this.bufferBackground.dispose();
            }
            if (bounds.width > 10000 || bounds.height > 10000) {
                return;
            }
            this.bufferBackground = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            Color[] colors = new Color[]{this.colorWhite, this.lightGrey, this.lightGrey2, this.lightGrey};
            GC gcBuffer = new GC((Drawable)this.bufferBackground);
            for (int i = 0; i < bounds.height - 2; ++i) {
                gcBuffer.setForeground(colors[i % 4]);
                gcBuffer.drawLine(1, i + 1, bounds.width - 1, i + 1);
            }
            gcBuffer.setForeground(Colors.black);
            gcBuffer.drawLine(bounds.width - 70, 0, bounds.width - 70, bounds.height - 1);
            gcBuffer.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            gcBuffer.dispose();
        }
    }

    public void dispose() {
        if (this.bufferBackground != null && !this.bufferBackground.isDisposed()) {
            this.bufferBackground.dispose();
        }
    }

    public void setColors(Color color1, Color color2, Color color3) {
        this.colorWhite = color1;
        this.lightGrey = color2;
        this.lightGrey2 = color3;
        this.drawCanvas.redraw();
    }
}

