/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;

public class Scale {
    private static boolean wantBinary;
    private static boolean useSI;
    private int pixelsPerLevel = 50;
    private int max = 1;
    private int nbLevels;
    private int displayedMax;
    private int nbPixels = 1;
    boolean isSIIECSensitive;
    private int[] scaleValues = new int[0];

    public Scale() {
        this(true);
    }

    public Scale(boolean _isSIIECSensitive) {
        this.isSIIECSensitive = _isSIIECSensitive;
    }

    public boolean isSIIECSensitive() {
        return this.isSIIECSensitive;
    }

    public void setMax(int max) {
        this.max = max;
        if (max < 1) {
            max = 1;
        }
        this.computeValues();
    }

    public int getMax() {
        return this.max;
    }

    public void setNbPixels(int nbPixels) {
        this.nbPixels = nbPixels;
        if (nbPixels < 1) {
            nbPixels = 1;
        }
        this.computeValues();
    }

    private void computeValues() {
        double scaleFactor;
        double scaleMax;
        int targetNbLevels = this.nbPixels / this.pixelsPerLevel;
        if (targetNbLevels < 1) {
            targetNbLevels = 1;
        }
        long powFactor = 1L;
        int scaleThing = wantBinary ? 2 : 10;
        double d = scaleMax = wantBinary ? 4.0 : 5.0;
        for (scaleFactor = (double)(this.max / targetNbLevels); scaleFactor >= (double)scaleThing; scaleFactor /= (double)scaleThing) {
            powFactor = (long)scaleThing * powFactor;
        }
        scaleFactor = scaleFactor >= scaleMax ? scaleMax : (scaleFactor >= 2.0 ? scaleMax / 2.0 : 1.0);
        long increment = (long)(scaleFactor * (double)powFactor);
        if (this.isSIIECSensitive) {
            int divBy = 0;
            int multBy = 0;
            if (useSI && !wantBinary) {
                divBy = 1000;
                multBy = 1024;
            } else if (!useSI && wantBinary) {
                divBy = 1024;
                multBy = 1000;
            }
            if (divBy > 0) {
                long temp = increment;
                int pow = -1;
                while (temp > 0L) {
                    temp /= (long)divBy;
                    ++pow;
                }
                long temp2 = 1L;
                long temp3 = 1L;
                for (int i = 0; i < pow; ++i) {
                    temp2 *= (long)multBy;
                    temp3 *= (long)divBy;
                }
                increment = (long)((double)increment / (double)temp3 * (double)temp2);
            }
        }
        this.nbLevels = (int)((long)this.max / increment + 1L);
        this.displayedMax = (int)(increment * (long)this.nbLevels);
        int[] result = new int[this.nbLevels + 1];
        for (int i = 0; i < this.nbLevels + 1; ++i) {
            result[i] = (int)((long)i * increment);
        }
        this.scaleValues = result;
    }

    public int[] getScaleValues() {
        return this.scaleValues;
    }

    public int getScaledValue(int value) {
        return (int)((long)value * (long)this.nbPixels / (long)this.displayedMax);
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"ui.scaled.graphics.binary.based", "config.style.useSIUnits", "config.style.forceSIValues"}, new ParameterListener(){

            public void parameterChanged(String name) {
                wantBinary = COConfigurationManager.getBooleanParameter("ui.scaled.graphics.binary.based");
                boolean wantSI = COConfigurationManager.getBooleanParameter("config.style.useSIUnits");
                boolean forceSI = COConfigurationManager.getBooleanParameter("config.style.forceSIValues");
                useSI = wantSI || forceSI;
            }
        });
    }
}

