/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.shell;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public final class ShellFactory {
    public static Shell createMainShell(int styles) {
        Shell parent = null;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            parent = uiFunctions.getMainShell();
        }
        if (parent == null) {
            return ShellFactory.createShell(SWTThread.getInstance().getDisplay());
        }
        return ShellFactory.createShell(parent, styles);
    }

    public static Shell createShell(Display disp, int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(disp, styles));
    }

    public static Shell createShell(Display disp) {
        return ShellFactory.getRegisteredShell(new AEShell(disp));
    }

    public static Shell createShell(Shell parent, int styles) {
        if (parent != null && parent.isDisposed()) {
            return null;
        }
        return ShellFactory.getRegisteredShell(new AEShell(parent, styles));
    }

    public static Shell createShell(Shell parent) {
        return ShellFactory.getRegisteredShell(new AEShell(parent));
    }

    public static Shell createShell(int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(styles));
    }

    private static Shell getRegisteredShell(Shell toRegister) {
        if (null == toRegister) {
            return null;
        }
        if (Constants.isOSX) {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions == null) {
                System.err.println("Main window is not initialized yet");
            } else {
                uiFunctions.createMainMenu(toRegister);
            }
        }
        ShellManager.sharedManager().addWindow(toRegister);
        return toRegister;
    }

    public static class AEShell
    extends Shell {
        private boolean inSetSize = false;

        private AEShell(int styles) {
            super(styles);
        }

        private AEShell(Display display) {
            super(display);
        }

        private AEShell(Display display, int styles) {
            super(display, AEShell.fixupStyle(styles));
        }

        private AEShell(Shell parent) {
            super(parent);
        }

        private AEShell(Shell parent, int styles) {
            super(parent, AEShell.fixupStyle(styles));
        }

        private static int fixupStyle(int style) {
            UIFunctionsSWT uiFunctions;
            if ((style & 0x38000) != 0 && Utils.anyShellHaveStyle(16416) && (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && uiFunctions.getMainShell() != null) {
                style |= 0x4000;
            }
            return style;
        }

        protected void checkSubclass() {
        }

        public void setImage(Image image) {
            if (!Constants.isOSX) {
                super.setImage(image);
            }
        }

        public void setImages(Image[] images) {
            if (!Constants.isOSX) {
                super.setImages(images);
            }
        }

        public Point computeSize(int wHint, int hHint) {
            if (!this.inSetSize && wHint > 0 && hHint == -1) {
                this.inSetSize = true;
                return super.computeSize(Utils.adjustPXForDPI(wHint), hHint);
            }
            return super.computeSize(wHint, hHint);
        }

        public void setAdjustPXforDPI(boolean adjust) {
            this.inSetSize = !adjust;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSize(int width, int height) {
            if (this.inSetSize) {
                super.setSize(width, height);
                return;
            }
            this.inSetSize = true;
            try {
                width = Utils.adjustPXForDPI(width);
                height = Utils.adjustPXForDPI(height);
                super.setSize(width, height);
                Object var4_3 = null;
                this.inSetSize = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.inSetSize = false;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pack() {
            this.inSetSize = true;
            try {
                super.pack();
                Object var2_1 = null;
                this.inSetSize = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.inSetSize = false;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSize(Point size) {
            if (this.inSetSize) {
                super.setSize(size);
                return;
            }
            this.inSetSize = true;
            try {
                super.setSize(Utils.adjustPXForDPI(size));
                Object var3_2 = null;
                this.inSetSize = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.inSetSize = false;
                throw throwable;
            }
        }

        public void open() {
            Shell firstShellWithStyle;
            Shell mainShell;
            Boolean bringToFront;
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null && ((bringToFront = (Boolean)this.getData("bringToFront")) == null || bringToFront.booleanValue()) && (mainShell = uiFunctions.getMainShell()) != null && mainShell.getMinimized()) {
                uiFunctions.bringToFront();
            }
            if ((firstShellWithStyle = Utils.findFirstShellWithStyle(65536)) != null && firstShellWithStyle != this) {
                firstShellWithStyle.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            public void runSupport() {
                                AEShell.this.open();
                            }
                        });
                    }
                });
                firstShellWithStyle.setVisible(true);
                firstShellWithStyle.forceActive();
            } else if (!this.isDisposed()) {
                super.open();
            }
        }
    }
}

