/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class IntListParameter
extends Parameter {
    Combo list;
    private final int[] values;
    private final String name;

    public IntListParameter(Composite composite, String name, String[] labels, int[] values) {
        this(composite, name, COConfigurationManager.getIntParameter(name), labels, values);
    }

    public IntListParameter(Composite composite, String name, int defaultValue, String[] labels, int[] values) {
        super(name);
        this.name = name;
        this.values = values;
        if (labels.length != values.length) {
            return;
        }
        int value = COConfigurationManager.getIntParameter(name, defaultValue);
        int index = this.findIndex(value, values);
        this.list = new Combo(composite, 12);
        for (int i = 0; i < labels.length; ++i) {
            this.list.add(labels[i]);
        }
        this.setIndex(index);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IntListParameter.this.setIndex(IntListParameter.this.list.getSelectionIndex());
            }
        });
    }

    protected void setIndex(final int index) {
        int selected_value = this.values[index];
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (IntListParameter.this.list == null || IntListParameter.this.list.isDisposed()) {
                    return;
                }
                if (IntListParameter.this.list.getSelectionIndex() != index) {
                    IntListParameter.this.list.select(index);
                }
            }
        });
        if (COConfigurationManager.getIntParameter(this.name) != selected_value) {
            COConfigurationManager.setParameter(this.name, selected_value);
        }
    }

    private int findIndex(int value, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            return i;
        }
        return 0;
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.list.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.list;
    }

    public void setValue(Object value) {
        if (value instanceof Number) {
            int i = ((Number)value).intValue();
            this.setIndex(this.findIndex(i, this.values));
        }
    }

    public Object getValueObject() {
        return new Integer(COConfigurationManager.getIntParameter(this.name));
    }
}

