/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class IpFilterEditor {
    AzureusCore azureus_core;
    IpRange range;
    boolean newRange;

    public IpFilterEditor(AzureusCore _azureus_core, Shell parent, IpRange _range) {
        this.azureus_core = _azureus_core;
        this.range = _range;
        if (this.range == null) {
            this.newRange = true;
            this.range = this.azureus_core.getIpFilterManager().getIPFilter().createRange(false);
        }
        final Shell shell = ShellFactory.createShell(parent, 67680);
        Messages.setLanguageText((Widget)shell, "ConfigView.section.ipfilter.editFilter");
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.ipfilter.description");
        final Text textDescription = new Text((Composite)shell, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 300;
        Utils.setLayoutData((Control)textDescription, gridData);
        label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.ipfilter.start");
        final Text textStartIp = new Text((Composite)shell, 2048);
        gridData = new GridData();
        gridData.widthHint = 120;
        Utils.setLayoutData((Control)textStartIp, gridData);
        label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.ipfilter.end");
        final Text textEndIp = new Text((Composite)shell, 2048);
        gridData = new GridData();
        gridData.widthHint = 120;
        Utils.setLayoutData((Control)textEndIp, gridData);
        final Button ok = new Button((Composite)shell, 8);
        Messages.setLanguageText((Widget)ok, "Button.ok");
        shell.setDefaultButton(ok);
        gridData = new GridData(896);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 100;
        Utils.setLayoutData((Control)ok, gridData);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                IpFilterEditor.this.range.setDescription(textDescription.getText());
                IpFilterEditor.this.range.setStartIp(textStartIp.getText());
                IpFilterEditor.this.range.setEndIp(textEndIp.getText());
                IpFilterEditor.this.range.checkValid();
                if (IpFilterEditor.this.newRange) {
                    IpFilterEditor.this.azureus_core.getIpFilterManager().getIPFilter().addRange(IpFilterEditor.this.range);
                }
                shell.dispose();
            }
        });
        textStartIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event2) {
                IpFilterEditor.this.range.setStartIp(textStartIp.getText());
                IpFilterEditor.this.range.checkValid();
                if (IpFilterEditor.this.range.isValid()) {
                    ok.setEnabled(true);
                } else {
                    ok.setEnabled(false);
                }
            }
        });
        textEndIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event2) {
                IpFilterEditor.this.range.setEndIp(textEndIp.getText());
                IpFilterEditor.this.range.checkValid();
                if (IpFilterEditor.this.range.isValid()) {
                    ok.setEnabled(true);
                } else {
                    ok.setEnabled(false);
                }
            }
        });
        if (this.range != null) {
            textDescription.setText(this.range.getDescription());
            textStartIp.setText(this.range.getStartIp());
            textEndIp.setText(this.range.getEndIp());
        }
        shell.pack();
        Utils.centerWindowRelativeTo(shell, (Control)parent);
        shell.open();
    }
}

