/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;

public class StringListParameter
extends Parameter {
    Control list;
    final String name;
    final String default_value;
    private final String[] values;
    private final boolean useCombo;

    public StringListParameter(Composite composite, String _name, String[] labels, String[] values, boolean bUseCombo) {
        this(composite, _name, COConfigurationManager.getStringParameter(_name), labels, values, bUseCombo);
    }

    public StringListParameter(Composite composite, String _name, String[] labels, String[] values) {
        this(composite, _name, COConfigurationManager.getStringParameter(_name), labels, values, true);
    }

    public StringListParameter(Composite composite, String _name, String defaultValue, String[] labels, String[] values) {
        this(composite, _name, defaultValue, labels, values, true);
    }

    public StringListParameter(Composite composite, String _name, String defaultValue, String[] labels, String[] values, final boolean bUseCombo) {
        super(_name);
        this.name = _name;
        this.default_value = defaultValue;
        this.values = values;
        this.useCombo = bUseCombo;
        if (labels.length != values.length) {
            return;
        }
        String value = COConfigurationManager.getStringParameter(this.name, defaultValue);
        int index = this.findIndex(value, values);
        this.list = bUseCombo ? new Combo(composite, 12) : new List(composite, 2820){

            public void checkSubclass() {
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Object ld;
                if (hHint == 0 && !this.isVisible()) {
                    return new Point(0, 0);
                }
                Point pt = super.computeSize(wHint, hHint, changed);
                if (hHint == -1 && (ld = this.getLayoutData()) instanceof GridData && ((GridData)ld).grabExcessVerticalSpace) {
                    pt.y = 20;
                }
                return pt;
            }
        };
        for (int i = 0; i < labels.length; ++i) {
            if (bUseCombo) {
                ((Combo)this.list).add(labels[i]);
                continue;
            }
            ((List)this.list).add(labels[i]);
        }
        this.setIndex(index);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = bUseCombo ? ((Combo)StringListParameter.this.list).getSelectionIndex() : ((List)StringListParameter.this.list).getSelectionIndex();
                StringListParameter.this.setIndex(index);
                if (StringListParameter.this.change_listeners != null) {
                    for (int i = 0; i < StringListParameter.this.change_listeners.size(); ++i) {
                        ((ParameterChangeListener)StringListParameter.this.change_listeners.get(i)).parameterChanged(StringListParameter.this, false);
                    }
                }
            }
        });
    }

    private int findIndex(String value, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    protected void setIndex(final int index) {
        if (index < 0) {
            COConfigurationManager.removeParameter(this.name);
            String defValue = COConfigurationManager.getStringParameter(this.name);
            int i = this.findIndex(defValue, this.values);
            if (i >= 0) {
                this.setIndex(i);
            } else {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (StringListParameter.this.list == null || StringListParameter.this.list.isDisposed()) {
                            return;
                        }
                        if (StringListParameter.this.useCombo) {
                            ((Combo)StringListParameter.this.list).deselectAll();
                        } else {
                            ((List)StringListParameter.this.list).deselectAll();
                        }
                    }
                });
            }
            return;
        }
        String selected_value = this.values[index];
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (StringListParameter.this.list == null || StringListParameter.this.list.isDisposed()) {
                    return;
                }
                if (StringListParameter.this.useCombo) {
                    if (((Combo)StringListParameter.this.list).getSelectionIndex() != index) {
                        ((Combo)StringListParameter.this.list).select(index);
                    }
                } else if (((List)StringListParameter.this.list).getSelectionIndex() != index) {
                    ((List)StringListParameter.this.list).select(index);
                }
            }
        });
        if (!COConfigurationManager.getStringParameter(this.name).equals(selected_value)) {
            COConfigurationManager.setParameter(this.name, selected_value);
        }
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.list.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.list;
    }

    public String getValue() {
        return COConfigurationManager.getStringParameter(this.name, this.default_value);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            this.setIndex(this.findIndex(s, this.values));
        }
    }

    public Object getValueObject() {
        return this.getValue();
    }
}

