/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;

public class StringParameter
extends Parameter {
    private String name;
    private Text inputField;
    private String defaultValue;

    public StringParameter(Composite composite, String name) {
        this(composite, name, COConfigurationManager.getStringParameter(name));
    }

    public StringParameter(Composite composite, String name, boolean generateIntermediateEvents) {
        this(composite, name, COConfigurationManager.getStringParameter(name), generateIntermediateEvents);
    }

    public StringParameter(Composite composite, String name, String defaultValue) {
        this(composite, name, defaultValue, true);
    }

    public StringParameter(Composite composite, final String name, String defaultValue, boolean generateIntermediateEvents) {
        super(name);
        this.name = name;
        this.defaultValue = defaultValue;
        this.inputField = new Text(composite, 2048){

            public void checkSubclass() {
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Object ld;
                if (hHint == 0 && !this.isVisible()) {
                    return new Point(0, 0);
                }
                Point pt = super.computeSize(wHint, hHint, changed);
                if (wHint == -1 && (ld = this.getLayoutData()) instanceof GridData && ((GridData)ld).grabExcessHorizontalSpace) {
                    pt.x = 10;
                }
                return pt;
            }
        };
        String value = COConfigurationManager.getStringParameter(name, defaultValue);
        try {
            this.inputField.setText(value);
        }
        catch (IllegalArgumentException e) {
            Debug.out("IllegalArgumentException for value of " + name);
        }
        this.inputField.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                e.doit = COConfigurationManager.verifyParameter(name, e.text);
            }
        });
        if (generateIntermediateEvents) {
            this.inputField.addListener(24, new Listener(){

                public void handleEvent(Event event2) {
                    StringParameter.this.checkValue();
                }
            });
        }
        this.inputField.addListener(16, new Listener(){

            public void handleEvent(Event event2) {
                StringParameter.this.checkValue();
            }
        });
    }

    protected void checkValue() {
        String new_value;
        String old_value = COConfigurationManager.getStringParameter(this.name, this.defaultValue);
        if (!old_value.equals(new_value = this.inputField.getText())) {
            COConfigurationManager.setParameter(this.name, new_value);
            if (this.change_listeners != null) {
                for (int i = 0; i < this.change_listeners.size(); ++i) {
                    ((ParameterChangeListener)this.change_listeners.get(i)).parameterChanged(this, false);
                }
            }
        }
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.inputField.setLayoutData(layoutData);
    }

    public void setValue(final String value) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (StringParameter.this.inputField == null || StringParameter.this.inputField.isDisposed() || StringParameter.this.inputField.getText().equals(value)) {
                    return;
                }
                StringParameter.this.inputField.setText(value);
            }
        });
        if (!COConfigurationManager.getStringParameter(this.name).equals(value)) {
            COConfigurationManager.setParameter(this.name, value);
        }
    }

    public String getValue() {
        return this.inputField.getText();
    }

    public Control getControl() {
        return this.inputField;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
        }
    }

    public Object getValueObject() {
        return COConfigurationManager.getStringParameter(this.name);
    }
}

