/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.generic;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class GenericFloatParameter {
    Text inputField;
    float fMinValue = 0.0f;
    float fMaxValue = -1.0f;
    boolean allowZero = false;
    private GenericParameterAdapter adapter;
    private String name;

    public GenericFloatParameter(GenericParameterAdapter adapter, Composite composite, String name) {
        adapter.getFloatValue(name);
        this.initialize(adapter, composite, name);
    }

    public GenericFloatParameter(GenericParameterAdapter adapter, Composite composite, String name, float minValue, float maxValue, boolean allowZero, int digitsAfterDecimal) {
        adapter.getFloatValue(name);
        this.initialize(adapter, composite, name);
        this.fMinValue = minValue;
        this.fMaxValue = maxValue;
        this.allowZero = allowZero;
    }

    public void initialize(final GenericParameterAdapter adapter, Composite composite, final String name) {
        this.adapter = adapter;
        this.name = name;
        this.inputField = new Text(composite, 133120);
        float value = adapter.getFloatValue(name);
        this.inputField.setText(String.valueOf(value));
        this.inputField.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] >= '0' && chars[i] <= '9' || chars[i] == '.') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        this.inputField.addListener(24, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    float val = Float.parseFloat(GenericFloatParameter.this.inputField.getText());
                    if (val < GenericFloatParameter.this.fMinValue && (!GenericFloatParameter.this.allowZero || val != 0.0f)) {
                        val = GenericFloatParameter.this.fMinValue;
                    }
                    if (val > GenericFloatParameter.this.fMaxValue && GenericFloatParameter.this.fMaxValue > -1.0f) {
                        val = GenericFloatParameter.this.fMaxValue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.inputField.addListener(16, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    float val = Float.parseFloat(GenericFloatParameter.this.inputField.getText());
                    if (val < GenericFloatParameter.this.fMinValue && (!GenericFloatParameter.this.allowZero || val != 0.0f)) {
                        GenericFloatParameter.this.inputField.setText(String.valueOf(GenericFloatParameter.this.fMinValue));
                        val = GenericFloatParameter.this.fMinValue;
                    }
                    if (val > GenericFloatParameter.this.fMaxValue && GenericFloatParameter.this.fMaxValue > -1.0f) {
                        GenericFloatParameter.this.inputField.setText(String.valueOf(GenericFloatParameter.this.fMaxValue));
                        val = GenericFloatParameter.this.fMaxValue;
                    }
                    adapter.setFloatValue(name, val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setValue(final float value) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!GenericFloatParameter.this.inputField.isDisposed()) {
                    GenericFloatParameter.this.inputField.setText(String.valueOf(value));
                }
            }
        });
    }

    public float getValue() {
        return this.adapter.getFloatValue(this.name);
    }

    public void refresh() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!GenericFloatParameter.this.inputField.isDisposed()) {
                    GenericFloatParameter.this.inputField.setText(String.valueOf(GenericFloatParameter.this.adapter.getFloatValue(GenericFloatParameter.this.name)));
                }
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.inputField.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.inputField;
    }
}

