/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.generic;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class GenericStringListParameter {
    private GenericParameterAdapter adapter;
    private Control list;
    private final String name;
    private final String default_value;
    private final String[] values;
    private final boolean useCombo;

    public GenericStringListParameter(GenericParameterAdapter adapter, Composite composite, String _name, String[] labels, String[] values, boolean bUseCombo) {
        this(adapter, composite, _name, adapter.getStringListValue(_name), labels, values, bUseCombo);
    }

    public GenericStringListParameter(GenericParameterAdapter adapter, Composite composite, String _name, String[] labels, String[] values) {
        this(adapter, composite, _name, adapter.getStringListValue(_name), labels, values, true);
    }

    public GenericStringListParameter(GenericParameterAdapter adapter, Composite composite, String _name, String defaultValue, String[] labels, String[] values) {
        this(adapter, composite, _name, defaultValue, labels, values, true);
    }

    public GenericStringListParameter(GenericParameterAdapter _adapter, Composite composite, String _name, String defaultValue, String[] labels, String[] values, final boolean bUseCombo) {
        this.adapter = _adapter;
        this.name = _name;
        this.default_value = defaultValue;
        this.values = values;
        this.useCombo = bUseCombo;
        if (labels.length != values.length) {
            return;
        }
        String value = this.adapter.getStringListValue(this.name, defaultValue);
        int index = this.findIndex(value, values);
        this.list = bUseCombo ? new Combo(composite, 12) : new List(composite, 2820){

            public void checkSubclass() {
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Object ld;
                if (hHint == 0 && !this.isVisible()) {
                    return new Point(0, 0);
                }
                Point pt = super.computeSize(wHint, hHint, changed);
                if (hHint == -1 && (ld = this.getLayoutData()) instanceof GridData && ((GridData)ld).grabExcessVerticalSpace) {
                    pt.y = 20;
                }
                return pt;
            }
        };
        for (int i = 0; i < labels.length; ++i) {
            if (bUseCombo) {
                ((Combo)this.list).add(labels[i]);
                continue;
            }
            ((List)this.list).add(labels[i]);
        }
        this.setIndex(index);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = bUseCombo ? ((Combo)GenericStringListParameter.this.list).getSelectionIndex() : ((List)GenericStringListParameter.this.list).getSelectionIndex();
                GenericStringListParameter.this.setIndex(index);
            }
        });
    }

    private int findIndex(String value, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    protected void setIndex(final int index) {
        if (index < 0) {
            this.adapter.setStringListValue(this.name, null);
            String defValue = this.adapter.getStringListValue(this.name);
            int i = this.findIndex(defValue, this.values);
            if (i >= 0) {
                this.setIndex(i);
            } else {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (GenericStringListParameter.this.list == null || GenericStringListParameter.this.list.isDisposed()) {
                            return;
                        }
                        if (GenericStringListParameter.this.useCombo) {
                            ((Combo)GenericStringListParameter.this.list).deselectAll();
                        } else {
                            ((List)GenericStringListParameter.this.list).deselectAll();
                        }
                    }
                });
            }
            return;
        }
        String selected_value = this.values[index];
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (GenericStringListParameter.this.list == null || GenericStringListParameter.this.list.isDisposed()) {
                    return;
                }
                if (GenericStringListParameter.this.useCombo) {
                    if (((Combo)GenericStringListParameter.this.list).getSelectionIndex() != index) {
                        ((Combo)GenericStringListParameter.this.list).select(index);
                    }
                } else if (((List)GenericStringListParameter.this.list).getSelectionIndex() != index) {
                    ((List)GenericStringListParameter.this.list).select(index);
                }
            }
        });
        if (!this.adapter.getStringListValue(this.name).equals(selected_value)) {
            this.adapter.setStringListValue(this.name, selected_value);
        }
    }

    public void setLayoutData(Object layoutData) {
        Utils.adjustPXForDPI(layoutData);
        this.list.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.list;
    }

    public String getValue() {
        return this.adapter.getStringListValue(this.name, this.default_value);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            this.setIndex(this.findIndex(s, this.values));
        }
    }

    public Object getValueObject() {
        return this.getValue();
    }
}

