/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.debug;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.debug.ObfusticateShell;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.bouncycastle.util.encoders.Base64;

public class UIDebugGenerator {
    public static void generate(String sourceRef, String additionalText) {
        final GeneratedResults gr = UIDebugGenerator.generate(null, false, "UIDebugGenerator.messageask");
        if (gr != null) {
            AZ3Functions.provider az3 = AZ3Functions.getProvider();
            if (az3 != null && gr.sendNow) {
                FeatureManager.FeatureDetails[] featureDetails;
                if (gr.email != null && gr.email.length() > 0) {
                    additionalText = additionalText + "\n" + gr.email;
                }
                ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                String url = az3.getDefaultContentNetworkURL(27, new Object[]{"/debugSender.start", true});
                StringBuffer postData = new StringBuffer();
                PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
                FeatureManager featman = pi.getUtilities().getFeatureManager();
                if (featman != null && (featureDetails = featman.getFeatureDetails("dvdburn")) != null && featureDetails.length > 0) {
                    FeatureManager.FeatureDetails bestDetails = featureDetails[0];
                    postData.append("license=");
                    postData.append(UrlUtils.encode(bestDetails.getLicence().getKey()));
                    postData.append("&");
                }
                postData.append("message=");
                postData.append(UrlUtils.encode(gr.message));
                postData.append("&error=");
                postData.append(UrlUtils.encode(additionalText));
                postData.append("&sourceRef=");
                postData.append(UrlUtils.encode(sourceRef));
                if (gr.email != null && gr.email.length() > 0) {
                    postData.append("&email=");
                    postData.append(UrlUtils.encode(gr.email));
                }
                postData.append("&debug_zip=");
                try {
                    byte[] fileArray = FileUtil.readFileAsByteArray(gr.file);
                    postData.append(UrlUtils.encode(new String(Base64.encode(fileArray))));
                    ResourceDownloader rd = rdf.create(new URL(url), postData.toString());
                    rd.addListener(new ResourceDownloaderListener(){

                        public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                        }

                        public void reportAmountComplete(ResourceDownloader downloader, long amount) {
                        }

                        public void reportActivity(ResourceDownloader downloader, String activity) {
                        }

                        public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                            Debug.out(e);
                        }

                        public boolean completed(ResourceDownloader downloader, InputStream data) {
                            try {
                                int i = data.available();
                                byte[] b = new byte[i];
                                data.read(b);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return true;
                        }
                    });
                    rd.asyncDownload();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            } else {
                MessageBoxShell mb = new MessageBoxShell(65826, "UIDebugGenerator.complete", new String[]{gr.file.toString()});
                mb.open(new UserPrompterResultListener(){

                    public void prompterClosed(int result) {
                        if (result == 32) {
                            try {
                                PlatformManagerFactory.getPlatformManager().showFile(gr.file.getAbsolutePath());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneratedResults generate(File[] extraLogDirs, boolean allowEmpty, String msgPrefix) {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Shell activeShell = display.getActiveShell();
        if (activeShell != null) {
            activeShell.setCursor(display.getSystemCursor(1));
        }
        while (display.readAndDispatch()) {
        }
        Shell[] shells = display.getShells();
        if (shells == null || shells.length == 0) {
            return null;
        }
        final File path = new File(SystemProperties.getUserPath(), "debug");
        if (!path.isDirectory()) {
            path.mkdir();
        } else {
            try {
                File[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int i = 0; i < shells.length; ++i) {
            try {
                Shell shell = shells[i];
                Image image = null;
                if (shell.isDisposed() || !shell.isVisible()) continue;
                if (shell.getData("class") instanceof ObfusticateShell) {
                    ObfusticateShell shellClass = (ObfusticateShell)shell.getData("class");
                    try {
                        image = shellClass.generateObfusticatedImage();
                    }
                    catch (Exception e) {
                        Debug.out("Obfuscating shell " + shell, e);
                    }
                } else {
                    Object var13_24;
                    Rectangle clientArea = shell.getClientArea();
                    image = new Image((Device)display, clientArea.width, clientArea.height);
                    GC gc = new GC((Drawable)shell);
                    try {
                        gc.copyArea(image, clientArea.x, clientArea.y);
                        var13_24 = null;
                    }
                    catch (Throwable throwable) {
                        var13_24 = null;
                        gc.dispose();
                        throw throwable;
                    }
                    gc.dispose();
                    {
                    }
                }
                if (image == null) continue;
                File file = new File(path, "image-" + i + ".vpg");
                String sFileName = file.getAbsolutePath();
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(sFileName, 4);
                continue;
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LogIDs.GUI, "Creating Obfusticated Image", e));
            }
        }
        GeneratedResults gr = new GeneratedResults();
        if (activeShell != null) {
            activeShell.setCursor(null);
        }
        UIDebugGenerator.promptUser(allowEmpty, gr);
        if (gr.message == null) {
            return null;
        }
        OutputStreamWriter fw = null;
        try {
            File fUserMessage = new File(path, "usermessage.txt");
            fw = new FileWriter(fUserMessage);
            fw.write(gr.message + "\n" + gr.email);
            fw.close();
            fw = null;
        }
        catch (Throwable e) {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Throwable f) {
                    // empty catch block
                }
            }
            e.printStackTrace();
        }
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.createOperation(3, new AzureusCoreOperationTask(){

                    public void run(AzureusCoreOperation operation) {
                        try {
                            File fEvidence = new File(path, "evidence.log");
                            PrintWriter pw = new PrintWriter(fEvidence, "UTF-8");
                            AEDiagnostics.generateEvidence(pw);
                            pw.close();
                        }
                        catch (IOException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            }
        });
        try {
            File loggingFile;
            File diagReportspath;
            File outFile = new File(SystemProperties.getUserPath(), "debug.zip");
            if (outFile.exists()) {
                outFile.delete();
            }
            AEDiagnostics.flushPendingLogs();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
            File logPath = new File(SystemProperties.getUserPath(), "logs");
            File[] files = logPath.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".log");
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            File userPath = new File(SystemProperties.getUserPath());
            files = userPath.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".log");
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            files = path.listFiles();
            UIDebugGenerator.addFilesToZip(out, files);
            final long ago = SystemTime.getCurrentTime() - 7776000000L;
            File azureusPath = new File(SystemProperties.getApplicationPath());
            files = azureusPath.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().startsWith("hs_err") && pathname.lastModified() > ago;
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            try {
                File temp_file = File.createTempFile("AZU", "tmp");
                files = temp_file.getParentFile().listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().startsWith("hs_err") && pathname.lastModified() > ago;
                    }
                });
                UIDebugGenerator.addFilesToZip(out, files);
                temp_file.delete();
            }
            catch (Throwable e) {
                // empty catch block
            }
            File javaLogPath = new File(System.getProperty("user.home"), "Library" + File.separator + "Logs" + File.separator + "Java");
            if (javaLogPath.isDirectory()) {
                files = javaLogPath.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith("log") && pathname.lastModified() > ago;
                    }
                });
                UIDebugGenerator.addFilesToZip(out, files);
            }
            if ((diagReportspath = new File(System.getProperty("user.home"), "Library" + File.separator + "Logs" + File.separator + "DiagnosticReports")).isDirectory()) {
                files = diagReportspath.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith("crash") && pathname.lastModified() > ago;
                    }
                });
                UIDebugGenerator.addFilesToZip(out, files);
            }
            boolean bLogToFile = COConfigurationManager.getBooleanParameter("Logging Enable");
            String sLogDir = COConfigurationManager.getStringParameter("Logging Dir", "");
            if (bLogToFile && sLogDir != null && (loggingFile = new File(sLogDir, "az.log")).isFile()) {
                UIDebugGenerator.addFilesToZip(out, new File[]{loggingFile});
            }
            if (extraLogDirs != null) {
                for (File file : extraLogDirs) {
                    files = file.listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.getName().endsWith("stackdump") || pathname.getName().endsWith("log");
                        }
                    });
                    UIDebugGenerator.addFilesToZip(out, files);
                }
            }
            out.close();
            if (outFile.exists()) {
                gr.file = outFile;
                return gr;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void promptUser(final boolean allowEmpty, GeneratedResults gr) {
        final Shell shell = ShellFactory.createShell(Utils.findAnyShell(), 1264);
        final String[] text = new String[]{null, null};
        final int[] sendMode = new int[]{-1};
        Utils.setShellIcon(shell);
        Messages.setLanguageText((Widget)shell, "UIDebugGenerator.messageask.title");
        shell.setLayout((Layout)new FormLayout());
        Label lblText = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)lblText, "UIDebugGenerator.messageask.text");
        final Text textMessage = new Text((Composite)shell, 2114);
        final Text textEmail = new Text((Composite)shell, 2048);
        textEmail.setMessage("optional@email.here");
        Composite cButtonsSuper = new Composite((Composite)shell, 0);
        GridLayout gl = new GridLayout();
        cButtonsSuper.setLayout((Layout)gl);
        Composite cButtons = new Composite(cButtonsSuper, 0);
        cButtons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        Utils.setLayout(cButtons, new RowLayout());
        Button btnSendNow = new Button(cButtons, 8);
        btnSendNow.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (UIDebugGenerator.emptyCheck(textMessage, allowEmpty)) {
                    text[0] = textMessage.getText();
                    text[1] = textEmail.getText();
                    sendMode[0] = 0;
                }
                shell.dispose();
            }
        });
        Button btnSendLater = new Button(cButtons, 8);
        btnSendLater.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (UIDebugGenerator.emptyCheck(textMessage, allowEmpty)) {
                    text[0] = textMessage.getText();
                    text[1] = textEmail.getText();
                    sendMode[0] = 1;
                }
                shell.dispose();
            }
        });
        Button btnCancel = new Button(cButtons, 8);
        btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.dispose();
            }
        });
        if (Constants.isOSX) {
            btnCancel.moveAbove(null);
        }
        Messages.setLanguageText((Widget)btnCancel, "Button.cancel");
        Messages.setLanguageText((Widget)btnSendNow, "Button.sendNow");
        Messages.setLanguageText((Widget)btnSendLater, "Button.sendManual");
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        lblText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lblText, 10);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)textEmail, -10);
        textMessage.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)cButtonsSuper, -2);
        textEmail.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -1);
        cButtonsSuper.setLayoutData((Object)fd);
        textMessage.setFocus();
        shell.setSize(500, 300);
        shell.layout();
        Utils.centreWindow(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
        if (sendMode[0] != -1) {
            gr.message = text[0];
            gr.email = text[1];
        }
        gr.sendNow = sendMode[0] == 0;
    }

    protected static boolean emptyCheck(Text textMessage, boolean allowEmpty) {
        if (allowEmpty) {
            return true;
        }
        if (textMessage.getText().length() > 0) {
            return true;
        }
        new MessageBoxShell(32, "UIDebugGenerator.message.cancel", (String[])null).open(null);
        return false;
    }

    private static void addFilesToZip(ZipOutputStream out, File[] files) {
        byte[] buf = new byte[1024];
        if (files == null) {
            return;
        }
        for (int j = 0; j < files.length; ++j) {
            FileInputStream in;
            File file = files[j];
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                continue;
            }
            try {
                int len;
                ZipEntry entry = new ZipEntry(file.getName());
                entry.setTime(file.lastModified());
                out.putNextEntry(entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                in.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obfusticateArea(Image image, Rectangle bounds) {
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(image.getDevice().getSystemColor(1));
            gc.setForeground(image.getDevice().getSystemColor(3));
            gc.fillRectangle(bounds);
            gc.drawRectangle(bounds);
            int x2 = bounds.x + bounds.width;
            int y2 = bounds.y + bounds.height;
            gc.drawLine(bounds.x, bounds.y, x2, y2);
            gc.drawLine(x2, bounds.y, bounds.x, y2);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obfusticateArea(Image image, Rectangle bounds, String text) {
        if (bounds.isEmpty()) {
            return;
        }
        if (text == null || text.length() == 0) {
            UIDebugGenerator.obfusticateArea(image, bounds);
            return;
        }
        GC gc = new GC((Drawable)image);
        try {
            Device device = image.getDevice();
            gc.setBackground(device.getSystemColor(1));
            gc.setForeground(device.getSystemColor(3));
            gc.fillRectangle(bounds);
            gc.drawRectangle(bounds);
            Utils.setClipping(gc, bounds);
            gc.drawText(text, bounds.x + 2, bounds.y + 1);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
    }

    public static void obfusticateArea(Image image, Control control, String text) {
        if (control.isDisposed()) {
            return;
        }
        Rectangle bounds = control.getBounds();
        Point location = Utils.getLocationRelativeToShell(control);
        bounds.x = location.x;
        bounds.y = location.y;
        UIDebugGenerator.obfusticateArea(image, bounds, text);
    }

    public static class GeneratedResults {
        File file;
        String message;
        boolean sendNow;
        public String email;
    }
}

