/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.help;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class HealthHelpWindow {
    public static void show(Display display) {
        final ArrayList<String> imagesToRelease = new ArrayList<String>();
        final Shell window = ShellFactory.createShell(display, 67680);
        Utils.setShellIcon(window);
        window.setText(MessageText.getString("MyTorrentsView.menu.health"));
        LinkedHashMap<String, String> mapIDs = new LinkedHashMap<String, String>();
        mapIDs.put("grey", "st_stopped");
        mapIDs.put("red", "st_ko");
        mapIDs.put("blue", "st_no_tracker");
        mapIDs.put("yellow", "st_no_remote");
        mapIDs.put("green", "st_ok");
        mapIDs.put("error", "st_error");
        mapIDs.put("share", "st_shared");
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        try {
            layout.verticalSpacing = 3;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        window.setLayout((Layout)layout);
        ImageLoader imageLoader = ImageLoader.getInstance();
        for (String key : mapIDs.keySet()) {
            String value = (String)mapIDs.get(key);
            Image img = imageLoader.getImage(value);
            imagesToRelease.add(value);
            CLabel lbl = new CLabel((Composite)window, 0);
            lbl.setImage(img);
            lbl.setText(MessageText.getString("health.explain." + key));
        }
        Button btnOk = new Button((Composite)window, 8);
        btnOk.setText(MessageText.getString("Button.ok"));
        GridData gridData = new GridData(64);
        gridData.widthHint = 70;
        Utils.setLayoutData((Control)btnOk, gridData);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                window.dispose();
            }
        });
        window.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    window.dispose();
                }
            }
        });
        window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                for (String id : imagesToRelease) {
                    imageLoader.releaseImage(id);
                }
            }
        });
        window.pack();
        window.open();
    }
}

