/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.ipchecker;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.ipchecker.IpCheckerWizard;
import org.gudy.azureus2.ui.swt.ipchecker.IpSetterCallBack;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class ProgressPanel
extends AbstractWizardPanel
implements ExternalIPCheckerServiceListener {
    Text tasks;
    Display display;

    public ProgressPanel(IpCheckerWizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    public void show() {
        this.display = this.wizard.getDisplay();
        this.wizard.setTitle(MessageText.getString("ipCheckerWizard.progresstitle"));
        this.wizard.setCurrentInfo("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        Utils.setLayoutData((Control)panel, gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.tasks = new Text(panel, 2058);
        this.tasks.setBackground(this.display.getSystemColor(1));
        gridData = new GridData(1808);
        gridData.heightHint = 120;
        Utils.setLayoutData((Control)this.tasks, gridData);
    }

    public void finish() {
        ((IpCheckerWizard)this.wizard).selectedService.addListener(this);
        ((IpCheckerWizard)this.wizard).selectedService.initiateCheck(10000L);
    }

    public void checkComplete(ExternalIPCheckerService service, String ip) {
        this.reportProgress(service, MessageText.getString("ipCheckerWizard.checkComplete") + ip);
        IpSetterCallBack callBack = ((IpCheckerWizard)this.wizard).callBack;
        if (callBack != null) {
            callBack.setIp(ip);
        }
        this.wizard.switchToClose();
    }

    public void checkFailed(ExternalIPCheckerService service, String reason) {
        this.reportProgress(service, MessageText.getString("ipCheckerWizard.checkFailed") + reason);
        this.wizard.switchToClose();
    }

    public void reportProgress(final ExternalIPCheckerService service, final String message) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (ProgressPanel.this.tasks != null && !ProgressPanel.this.tasks.isDisposed()) {
                    ProgressPanel.this.tasks.append(service.getName() + " : " + message + Text.DELIMITER);
                }
            }
        });
    }
}

