/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.HSLColor;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class Colors
implements ParameterListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static Colors instance = null;
    public static final int BLUES_LIGHTEST = 0;
    public static final int BLUES_DARKEST = 9;
    public static final int BLUES_MIDLIGHT = 2;
    public static final int BLUES_MIDDARK = 7;
    public static final int FADED_LIGHTEST = 0;
    public static final int FADED_DARKEST = 9;
    public static Color[] blues = new Color[10];
    public static Color[] faded = new Color[10];
    public static Color colorProgressBar;
    public static Color colorInverse;
    public static Color colorShiftLeft;
    public static Color colorShiftRight;
    public static Color colorError;
    public static Color colorErrorBG;
    public static Color colorAltRow;
    public static Color colorWarning;
    public static Color black;
    public static Color light_grey;
    public static Color dark_grey;
    public static Color blue;
    public static Color green;
    public static Color fadedGreen;
    public static Color grey;
    public static Color red;
    public static Color fadedRed;
    public static Color yellow;
    public static Color fadedYellow;
    public static Color white;
    public static Color background;
    public static Color red_ConsoleView;
    private static AEMonitor class_mon;
    public static int diffHue;
    public static float diffSatPct;
    public static float diffLumPct;
    static List<ParameterListener> listeners;
    private Display display;

    private void allocateBlues() {
        int r = 0;
        int g = 128;
        int b = 255;
        try {
            r = COConfigurationManager.getIntParameter("Color Scheme.red", r);
            g = COConfigurationManager.getIntParameter("Color Scheme.green", g);
            b = COConfigurationManager.getIntParameter("Color Scheme.blue", b);
            boolean bGrayScale = r == b && b == g;
            HSLColor hslDefault = new HSLColor();
            hslDefault.initHSLbyRGB(0, 128, 255);
            HSLColor hslScheme = new HSLColor();
            hslScheme.initHSLbyRGB(r, g, b);
            diffHue = hslScheme.getHue() - hslDefault.getHue();
            diffSatPct = hslScheme.getSaturation() == 0 ? 0.0f : (float)hslDefault.getSaturation() / (float)hslScheme.getSaturation();
            diffLumPct = hslScheme.getLuminence() == 0 ? 0.0f : (float)hslDefault.getLuminence() / (float)hslScheme.getLuminence();
            HSLColor hslColor = new HSLColor();
            Color colorTables = this.display.getSystemColor(25);
            int tR = colorTables.getRed();
            int tG = colorTables.getGreen();
            int tB = colorTables.getBlue();
            for (int i = 0; i < blues.length; ++i) {
                hslColor.initHSLbyRGB(r, g, b);
                float blendBy = i == 0 ? 1.0f : 1.0f - (float)i / (float)(blues.length - 1);
                hslColor.blend(tR, tG, tB, blendBy);
                Colors.blues[i] = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                int iSat = hslColor.getSaturation();
                int luminence = hslColor.getLuminence();
                if (luminence < 20) {
                    if (iSat > 10) {
                        hslColor.setSaturation(iSat / 2);
                        hslColor.brighten(1.25f);
                    } else if (bGrayScale) {
                        hslColor.brighten(1.2f);
                    }
                } else if (iSat > 10) {
                    hslColor.setSaturation(iSat / 2);
                    hslColor.brighten(0.75f);
                } else if (bGrayScale) {
                    hslColor.brighten(0.8f);
                }
                Colors.faded[i] = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            }
            if (bGrayScale) {
                b = b > 200 ? (b -= 20) : (b += 20);
            }
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.reverseColor();
            colorInverse = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() + 25);
            colorShiftRight = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() - 25);
            colorShiftLeft = ColorCache.getColor((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error allocating colors", e));
        }
    }

    private void allocateColorProgressBar() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        colorProgressBar = new AllocateColor("progressBar", colorShiftRight, colorProgressBar).getColor();
    }

    private void allocateColorErrorBG() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                Color colorTables = Colors.this.display.getSystemColor(25);
                HSLColor hslColor = new HSLColor();
                hslColor.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslColor.getLuminence();
                int sat = hslColor.getSaturation();
                lum = (int)(lum > 127 ? (double)lum * 0.8 : (double)lum * 1.3);
                if (sat == 0) {
                    sat = 80;
                }
                hslColor.initRGBbyHSL(0, sat, lum);
                colorErrorBG = new AllocateColor("errorBG", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorErrorBG).getColor();
            }
        }, false);
    }

    private void allocateColorError() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        colorError = new AllocateColor("error", new RGB(255, 68, 68), colorError).getColor();
    }

    private void allocateColorWarning() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                Color colorTables = Colors.this.display.getSystemColor(25);
                HSLColor hslBG = new HSLColor();
                hslBG.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslBG.getLuminence();
                HSLColor hslColor = new HSLColor();
                hslColor.initRGBbyHSL(25, 200, 128 + (lum < 160 ? 10 : -10));
                colorWarning = new AllocateColor("warning", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorWarning).getColor();
            }
        }, false);
    }

    private void allocateColorAltRow() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                Color colorTables = Colors.this.display.getSystemColor(25);
                HSLColor hslColor = new HSLColor();
                hslColor.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslColor.getLuminence();
                int sat = hslColor.getSaturation();
                int hue = hslColor.getHue();
                if (lum > 127) {
                    lum -= 10;
                    sat = 127;
                    hue = 155;
                } else {
                    lum += 30;
                }
                hslColor.setLuminence(lum);
                hslColor.setHue(hue);
                hslColor.setSaturation(sat);
                colorAltRow = new AllocateColor("altRow", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorAltRow).getColor();
            }
        }, false);
    }

    private void allocateDynamicColors(final boolean first_time) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                Colors.this.allocateBlues();
                Colors.this.allocateColorProgressBar();
                Colors.this.allocateColorErrorBG();
                if (!first_time) {
                    ColorCache.reset();
                }
            }
        }, false);
    }

    private void allocateNonDynamicColors() {
        this.allocateColorWarning();
        this.allocateColorError();
        this.allocateColorAltRow();
        black = ColorCache.getColor((Device)this.display, 0, 0, 0);
        light_grey = ColorCache.getColor((Device)this.display, 192, 192, 192);
        dark_grey = ColorCache.getColor((Device)this.display, 96, 96, 96);
        blue = ColorCache.getColor((Device)this.display, 0, 0, 170);
        green = ColorCache.getColor((Device)this.display, 0, 170, 0);
        fadedGreen = ColorCache.getColor((Device)this.display, 96, 160, 96);
        grey = ColorCache.getColor((Device)this.display, 170, 170, 170);
        red = ColorCache.getColor((Device)this.display, 255, 0, 0);
        fadedRed = ColorCache.getColor((Device)this.display, 160, 96, 96);
        yellow = ColorCache.getColor((Device)this.display, 255, 255, 0);
        fadedYellow = ColorCache.getColor((Device)this.display, 255, 255, 221);
        white = ColorCache.getColor((Device)this.display, 255, 255, 255);
        background = ColorCache.getColor((Device)this.display, 248, 248, 248);
        red_ConsoleView = ColorCache.getColor((Device)this.display, 255, 192, 192);
    }

    private Colors() {
        instance = this;
        try {
            this.display = SWTThread.getInstance().getDisplay();
        }
        catch (Exception e) {
            this.display = Display.getDefault();
        }
        this.allocateDynamicColors(true);
        this.allocateNonDynamicColors();
        this.addColorsChangedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Colors getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new Colors();
            }
            Colors colors = instance;
            Object var2_1 = null;
            class_mon.exit();
            return colors;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColorsChangedListener(ParameterListener l) {
        List<ParameterListener> list = listeners;
        synchronized (list) {
            listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColorsChangedListener(ParameterListener l) {
        List<ParameterListener> list = listeners;
        synchronized (list) {
            listeners.remove(l);
        }
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Color Scheme")) {
            this.allocateDynamicColors(false);
        }
        if (parameterName.startsWith("Colors.progressBar")) {
            this.allocateColorProgressBar();
        }
        if (parameterName.startsWith("Colors.error")) {
            this.allocateColorError();
        }
        if (parameterName.startsWith("Colors.warning")) {
            this.allocateColorWarning();
        }
        if (parameterName.startsWith("Colors.altRow")) {
            this.allocateColorAltRow();
        }
    }

    static {
        class_mon = new AEMonitor("Colors");
        listeners = new ArrayList<ParameterListener>();
        ParameterListener l = new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String parameterName) {
                ArrayList<ParameterListener> copy;
                List<ParameterListener> list = listeners;
                synchronized (list) {
                    copy = new ArrayList<ParameterListener>(listeners);
                }
                for (ParameterListener l : copy) {
                    try {
                        l.parameterChanged(parameterName);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        COConfigurationManager.addParameterListener("Color Scheme", l);
        COConfigurationManager.addParameterListener("Colors.progressBar.override", l);
        COConfigurationManager.addParameterListener("Colors.progressBar", l);
        COConfigurationManager.addParameterListener("Colors.error.override", l);
        COConfigurationManager.addParameterListener("Colors.error", l);
        COConfigurationManager.addParameterListener("Colors.warning.override", l);
        COConfigurationManager.addParameterListener("Colors.warning", l);
        COConfigurationManager.addParameterListener("Colors.altRow.override", l);
        COConfigurationManager.addParameterListener("Colors.altRow", l);
    }

    private class AllocateColor
    extends AERunnable {
        private String sName;
        private RGB rgbDefault;
        private Color newColor;

        public AllocateColor(String sName, RGB rgbDefault, Color colorOld) {
            this.sName = sName;
            this.rgbDefault = rgbDefault;
        }

        public AllocateColor(String sName, final Color colorDefault, Color colorOld) {
            this.sName = sName;
            Utils.execSWTThread((Runnable)new AERunnable(){

                public void runSupport() {
                    if (!colorDefault.isDisposed()) {
                        AllocateColor.this.rgbDefault = colorDefault.getRGB();
                    } else {
                        AllocateColor.this.rgbDefault = new RGB(0, 0, 0);
                    }
                }
            }, false);
        }

        public Color getColor() {
            Utils.execSWTThread((Runnable)this, false);
            return this.newColor;
        }

        public void runSupport() {
            if (COConfigurationManager.getBooleanParameter("Colors." + this.sName + ".override")) {
                this.newColor = ColorCache.getColor((Device)Colors.this.display, COConfigurationManager.getIntParameter("Colors." + this.sName + ".red", this.rgbDefault.red), COConfigurationManager.getIntParameter("Colors." + this.sName + ".green", this.rgbDefault.green), COConfigurationManager.getIntParameter("Colors." + this.sName + ".blue", this.rgbDefault.blue));
            } else {
                this.newColor = ColorCache.getColor((Device)Colors.this.display, this.rgbDefault.red, this.rgbDefault.green, this.rgbDefault.blue);
                COConfigurationManager.setRGBParameter("Colors." + this.sName, this.rgbDefault.red, this.rgbDefault.green, this.rgbDefault.blue);
            }
        }
    }
}

