/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.shells.SpeedScaleShell;

public class SelectableSpeedMenu {
    private static final int[] increases = new int[]{5, 10, 35, 50, 50, 50, 100};
    private static Map parseSpeedPartitionStringCache = new HashMap();

    public static void generateMenuItems(final Menu parent, AzureusCore core, final GlobalManager globalManager, final boolean up_menu) {
        int kInB = 1024;
        MenuItem[] oldItems = parent.getItems();
        for (int i = 0; i < oldItems.length; ++i) {
            oldItems[i].dispose();
        }
        final String configKey = up_menu ? TransferSpeedValidator.getActiveUploadParameter(globalManager) : "Max Download Speed KBs";
        int speedPartitions = 12;
        int maxBandwidth = COConfigurationManager.getIntParameter(configKey);
        boolean unlim = maxBandwidth == 0;
        maxBandwidth = SelectableSpeedMenu.adjustMaxBandWidth(maxBandwidth, globalManager, up_menu, 1024);
        boolean auto = false;
        if (up_menu) {
            final String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
            auto = TransferSpeedValidator.isAutoSpeedActive(globalManager);
            final MenuItem auto_item = new MenuItem(parent, 32);
            auto_item.setText(MessageText.getString("ConfigView.auto"));
            auto_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    COConfigurationManager.setParameter(configAutoKey, auto_item.getSelection());
                    COConfigurationManager.save();
                }
            });
            if (auto) {
                auto_item.setSelection(true);
            }
            auto_item.setEnabled(TransferSpeedValidator.isAutoUploadAvailable(core));
            new MenuItem(parent, 2);
        }
        MenuItem item = new MenuItem(parent, 16);
        item.setText(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
        item.setData("maxkb", (Object)new Integer(0));
        item.setSelection(unlim && !auto);
        item.addListener(13, SelectableSpeedMenu.getLimitMenuItemListener(up_menu, parent, globalManager, configKey));
        Integer[] speed_limits = null;
        String config_prefix = "config.ui.speed.partitions.manual." + (up_menu ? "upload" : "download") + ".";
        if (COConfigurationManager.getBooleanParameter(config_prefix + "enabled", false)) {
            speed_limits = SelectableSpeedMenu.parseSpeedPartitionString(COConfigurationManager.getStringParameter(config_prefix + "values", ""));
        }
        if (speed_limits == null) {
            speed_limits = SelectableSpeedMenu.getGenericSpeedList(12, maxBandwidth);
        }
        for (int i = 0; i < speed_limits.length; ++i) {
            Integer i_value = speed_limits[i];
            int value = i_value;
            if (value < 5) continue;
            item = new MenuItem(parent, 16);
            item.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value * 1024, true));
            item.setData("maxkb", (Object)i_value);
            item.addListener(13, SelectableSpeedMenu.getLimitMenuItemListener(up_menu, parent, globalManager, configKey));
            item.setSelection(!unlim && value == maxBandwidth && !auto);
        }
        new MenuItem(parent, 2);
        MenuItem itemDownSpeedManual = new MenuItem(parent, 8);
        Messages.setLanguageText((Widget)itemDownSpeedManual, "MyTorrentsView.menu.manual");
        itemDownSpeedManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String kbps_str = MessageText.getString("MyTorrentsView.dialog.setNumber.inKbps", new String[]{DisplayFormatters.getRateUnit(1)});
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
                entryWindow.initTexts("MyTorrentsView.dialog.setSpeed.title", new String[]{MessageText.getString(up_menu ? "MyTorrentsView.dialog.setNumber.upload" : "MyTorrentsView.dialog.setNumber.download")}, "MyTorrentsView.dialog.setNumber.text", new String[]{kbps_str, MessageText.getString(up_menu ? "MyTorrentsView.dialog.setNumber.upload" : "MyTorrentsView.dialog.setNumber.download")});
                entryWindow.prompt(new UIInputReceiverListener(){

                    public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                        int newSpeed;
                        if (!entryWindow.hasSubmittedInput()) {
                            return;
                        }
                        String sReturn = entryWindow.getSubmittedInput();
                        if (sReturn == null) {
                            return;
                        }
                        try {
                            newSpeed = (int)Double.valueOf(sReturn).doubleValue();
                        }
                        catch (NumberFormatException er) {
                            MessageBox mb = new MessageBox(parent.getShell(), 33);
                            mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                            mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                            mb.open();
                            return;
                        }
                        if (up_menu) {
                            String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
                            COConfigurationManager.setParameter(configAutoKey, false);
                        }
                        int cValue = (Integer)new TransferSpeedValidator(configKey, new Integer(newSpeed)).getValue();
                        COConfigurationManager.setParameter(configKey, cValue);
                        COConfigurationManager.save();
                    }
                });
            }
        });
    }

    private static int adjustMaxBandWidth(int maxBandwidth, GlobalManager globalManager, boolean up_menu, int kInB) {
        if (maxBandwidth == 0 && !up_menu) {
            GlobalManagerStats stats2 = globalManager.getStats();
            int dataReceive = stats2.getDataReceiveRate();
            maxBandwidth = dataReceive < kInB ? 275 : dataReceive / kInB;
        }
        return maxBandwidth;
    }

    private static synchronized Integer[] parseSpeedPartitionString(String s) {
        Integer[] result = (Integer[])parseSpeedPartitionStringCache.get(s);
        if (result == null) {
            try {
                result = SelectableSpeedMenu.parseSpeedPartitionString0(s);
            }
            catch (NumberFormatException nfe) {
                result = new Integer[]{};
            }
            parseSpeedPartitionStringCache.put(s, result);
        }
        if (result.length == 0) {
            return null;
        }
        return result;
    }

    private static Integer[] parseSpeedPartitionString0(String s) {
        StringTokenizer tokeniser = new StringTokenizer(s.trim(), ",");
        TreeSet<Integer> values = new TreeSet<Integer>();
        while (tokeniser.hasMoreTokens()) {
            values.add(new Integer(Integer.parseInt(tokeniser.nextToken().trim())));
        }
        return values.toArray(new Integer[values.size()]);
    }

    private static final Listener getLimitMenuItemListener(final boolean up_menu, final Menu parent, final GlobalManager globalManager, final String configKey) {
        return new Listener(){

            public void handleEvent(Event event2) {
                MenuItem[] items = parent.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] == event2.widget) {
                        items[i].setSelection(true);
                        if (up_menu) {
                            String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
                            COConfigurationManager.setParameter(configAutoKey, false);
                        }
                        int cValue = (Integer)new TransferSpeedValidator(configKey, (Number)items[i].getData("maxkb")).getValue();
                        COConfigurationManager.setParameter(configKey, cValue);
                        COConfigurationManager.save();
                        continue;
                    }
                    items[i].setSelection(false);
                }
            }
        };
    }

    public static Integer[] getGenericSpeedList(int speedPartitions, int maxBandwidth) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        int delta = 0;
        int increaseLevel = 0;
        for (int i = 0; i < speedPartitions; ++i) {
            int[] valuePair = delta == 0 ? new int[]{maxBandwidth} : new int[]{maxBandwidth - delta * (maxBandwidth <= 1024 ? 1 : 1024), maxBandwidth + delta * (maxBandwidth < 1024 ? 1 : 1024)};
            for (int j = 0; j < valuePair.length; ++j) {
                if (j == 0) {
                    l.add(0, new Integer(valuePair[j]));
                    continue;
                }
                l.add(new Integer(valuePair[j]));
            }
            delta += increases[increaseLevel];
            if (increaseLevel >= increases.length - 1) continue;
            ++increaseLevel;
        }
        return l.toArray(new Integer[l.size()]);
    }

    public static void invokeSlider(Control cClickedFrom, AzureusCore core, boolean isUpSpeed) {
        int max;
        GlobalManagerStats stats2;
        int dataReceive;
        boolean unlim;
        final String prefix = MessageText.getString(isUpSpeed ? "GeneralView.label.maxuploadspeed" : "GeneralView.label.maxdownloadspeed");
        GlobalManager gm = core.getGlobalManager();
        String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(gm);
        boolean auto = COConfigurationManager.getBooleanParameter(configAutoKey);
        String configKey = isUpSpeed ? TransferSpeedValidator.getActiveUploadParameter(gm) : "Max Download Speed KBs";
        int maxBandwidth = COConfigurationManager.getIntParameter(configKey);
        boolean bl = unlim = maxBandwidth == 0;
        if (unlim && !isUpSpeed && (dataReceive = (stats2 = gm.getStats()).getDataReceiveRate()) >= 1024) {
            maxBandwidth = dataReceive / 1024;
        }
        SpeedScaleShell speedScale = new SpeedScaleShell(){

            public String getStringValue(int value, String sValue) {
                if (sValue != null) {
                    return prefix + ": " + sValue;
                }
                if (value == 0) {
                    return MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited");
                }
                if (value == -1) {
                    return MessageText.getString("ConfigView.auto");
                }
                return prefix + ": " + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.getValue() * 1024, true);
            }
        };
        int n = unlim ? (isUpSpeed ? 100 : 800) : (max = maxBandwidth * 5);
        if (max < 50) {
            max = 50;
        }
        speedScale.setMaxValue(max);
        speedScale.setMaxTextValue(9999999);
        String config_prefix = "config.ui.speed.partitions.manual." + (isUpSpeed ? "upload" : "download") + ".";
        int lastValue = COConfigurationManager.getIntParameter(config_prefix + "last", -10);
        Integer[] speed_limits = COConfigurationManager.getBooleanParameter(config_prefix + "enabled", false) ? SelectableSpeedMenu.parseSpeedPartitionString(COConfigurationManager.getStringParameter(config_prefix + "values", "")) : SelectableSpeedMenu.getGenericSpeedList(6, maxBandwidth);
        if (speed_limits != null) {
            for (int i = 0; i < speed_limits.length; ++i) {
                int value = speed_limits[i];
                if (value <= 0) continue;
                speedScale.addOption(DisplayFormatters.formatByteCountToKiBEtcPerSec(value * 1024, true), value);
                if (value != lastValue) continue;
                lastValue = -10;
            }
        }
        speedScale.addOption(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"), 0);
        speedScale.addOption(MessageText.getString("ConfigView.auto"), -1);
        if (lastValue > 0) {
            speedScale.addOption(DisplayFormatters.formatByteCountToKiBEtcPerSec(lastValue * 1024, true), lastValue);
        }
        if (speedScale.open(cClickedFrom, auto ? -1 : maxBandwidth, true)) {
            int value = speedScale.getValue();
            if (!speedScale.wasMenuChosen() || lastValue == value) {
                COConfigurationManager.setParameter(config_prefix + "last", maxBandwidth);
            }
            if (value >= 0) {
                if (auto) {
                    COConfigurationManager.setParameter(configAutoKey, false);
                }
                COConfigurationManager.setParameter(configKey, value);
                COConfigurationManager.save();
            } else {
                COConfigurationManager.setParameter(configAutoKey, true);
                COConfigurationManager.save();
            }
        }
    }

    public static void invokeSlider(Control cClickedFrom, AzureusCore core, DownloadManager[] dms, boolean isUpSpeed, Shell parentShell) {
        int max;
        final String prefix = MessageText.getString(isUpSpeed ? "GeneralView.label.maxuploadspeed" : "GeneralView.label.maxdownloadspeed");
        GlobalManager gm = core.getGlobalManager();
        final int kInB = DisplayFormatters.getKinB();
        int maxBandwidth = 0;
        for (DownloadManager dm : dms) {
            int bandwidth = (isUpSpeed ? dm.getStats().getUploadRateLimitBytesPerSecond() : dm.getStats().getDownloadRateLimitBytesPerSecond()) / kInB;
            if (bandwidth <= maxBandwidth && bandwidth != 0) continue;
            maxBandwidth = bandwidth;
        }
        boolean unlim = maxBandwidth == 0;
        final int num_entries = dms.length;
        SpeedScaleShell speedScale = new SpeedScaleShell(){

            public String getStringValue(int value, String sValue) {
                if (sValue != null) {
                    return prefix + ": " + sValue;
                }
                if (value == 0) {
                    return MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited");
                }
                if (value == -1) {
                    return MessageText.getString("ConfigView.auto");
                }
                String speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(value * kInB, true);
                if (num_entries > 1) {
                    speed = MessageText.getString("MyTorrentsView.menu.setSpeed.multi", new String[]{DisplayFormatters.formatByteCountToKiBEtcPerSec(value * kInB * num_entries), String.valueOf(num_entries), speed});
                }
                return prefix + ": " + speed;
            }
        };
        int n = unlim ? (isUpSpeed ? 100 : 800) : (max = maxBandwidth * 5);
        if (max < 50) {
            max = 50;
        }
        speedScale.setMaxValue(max);
        speedScale.setMaxTextValue(9999999);
        speedScale.setParentShell(parentShell);
        String config_prefix = "config.ui.speed.partitions.manual." + (isUpSpeed ? "upload" : "download") + ".";
        int lastValue = COConfigurationManager.getIntParameter(config_prefix + "last", -10);
        Integer[] speed_limits = COConfigurationManager.getBooleanParameter(config_prefix + "enabled", false) ? SelectableSpeedMenu.parseSpeedPartitionString(COConfigurationManager.getStringParameter(config_prefix + "values", "")) : SelectableSpeedMenu.getGenericSpeedList(6, maxBandwidth);
        if (speed_limits != null) {
            for (int i = 0; i < speed_limits.length; ++i) {
                int value = speed_limits[i];
                if (value <= 0) continue;
                int total = value * num_entries;
                String speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(total * kInB, true);
                if (num_entries > 1) {
                    speed = MessageText.getString("MyTorrentsView.menu.setSpeed.multi", new String[]{speed, String.valueOf(num_entries), DisplayFormatters.formatByteCountToKiBEtcPerSec(value * kInB)});
                }
                speedScale.addOption(speed, value);
                if (value != lastValue) continue;
                lastValue = -10;
            }
        }
        speedScale.addOption(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"), 0);
        if (lastValue > 0) {
            speedScale.addOption(DisplayFormatters.formatByteCountToKiBEtcPerSec(lastValue * kInB, true), lastValue);
        }
        if (speedScale.open(cClickedFrom, maxBandwidth, true)) {
            int value = speedScale.getValue();
            if (!speedScale.wasMenuChosen() || lastValue == value) {
                COConfigurationManager.setParameter(config_prefix + "last", maxBandwidth);
            }
            if (value >= 0) {
                for (DownloadManager dm : dms) {
                    if (isUpSpeed) {
                        dm.getStats().setUploadRateLimitBytesPerSecond(value * kInB);
                        continue;
                    }
                    dm.getStats().setDownloadRateLimitBytesPerSecond(value * kInB);
                }
            }
        }
    }
}

