/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.maketorrent.SavePathPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BYOPanel
extends AbstractWizardPanel<NewTorrentWizard> {
    private Tree tree;

    public BYOPanel(NewTorrentWizard wizard, IWizardPanel<NewTorrentWizard> previous) {
        super(wizard, previous);
        wizard.byo_map = null;
    }

    @Override
    public void show() {
        List list;
        ((NewTorrentWizard)this.wizard).setTitle(MessageText.getString("wizard.newtorrent.byo"));
        ((NewTorrentWizard)this.wizard).setCurrentInfo(MessageText.getString("wizard.newtorrent.byo.info"));
        Composite panel = ((NewTorrentWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.tree = new Tree(panel, 2050);
        this.tree.setHeaderVisible(true);
        TreeColumn treeColumn = new TreeColumn(this.tree, 0);
        Messages.setLanguageText((Widget)treeColumn, "label.torrent.structure");
        treeColumn.setWidth(Utils.adjustPXForDPI(180));
        treeColumn = new TreeColumn(this.tree, 0);
        Messages.setLanguageText((Widget)treeColumn, "label.original.file");
        treeColumn.setWidth(Utils.adjustPXForDPI(500));
        GridData gridData = new GridData(1808);
        this.tree.setLayoutData((Object)gridData);
        this.createDropTarget(this.tree);
        this.createDragSource(this.tree);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                BYOPanel.this.editSelected();
                e.doit = false;
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    BYOPanel.this.editSelected();
                } else if (e.keyCode == 127) {
                    TreeItem[] selection;
                    for (TreeItem treeItem : selection = BYOPanel.this.tree.getSelection()) {
                        Object data = treeItem.getData();
                        treeItem.dispose();
                    }
                }
            }
        });
        Composite cButtons = new Composite(panel, 0);
        Utils.setLayout(cButtons, new RowLayout());
        cButtons.setLayoutData((Object)new GridData(768));
        Button btnAddContainer = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnAddContainer, "button.add.container");
        btnAddContainer.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("wizard.newtorrent.byo.addcontainer.title", "wizard.newtorrent.byo.addcontainer.text");
                entryWindow.setPreenteredText("files", true);
                entryWindow.prompt();
                if (entryWindow.hasSubmittedInput()) {
                    BYOPanel.this.createContainer(null, entryWindow.getSubmittedInput());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnAddFiles = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnAddFiles, "OpenTorrentWindow.addFiles");
        btnAddFiles.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fDialog = new FileDialog(Utils.findAnyShell(), 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathData());
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                if (fDialog.open() != null) {
                    String[] fileNames = fDialog.getFileNames();
                    File last_file = null;
                    for (String fileName : fileNames) {
                        File f = new File(fDialog.getFilterPath(), fileName);
                        BYOPanel.this.addFilename(f);
                        last_file = f;
                    }
                    if (last_file != null) {
                        TorrentOpener.setFilterPathData(last_file.getAbsolutePath());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnAddFolder = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnAddFolder, "OpenTorrentWindow.addFiles.Folder");
        btnAddFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fDialog = new DirectoryDialog(Utils.findAnyShell(), 0);
                fDialog.setFilterPath(TorrentOpener.getFilterPathData());
                fDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.folder"));
                String path = fDialog.open();
                if (path != null) {
                    File f = new File(path);
                    BYOPanel.this.addFilename(f);
                    if (f.isDirectory()) {
                        TorrentOpener.setFilterPathData(f.getAbsolutePath());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (((NewTorrentWizard)this.wizard).byo_map != null && (list = (List)((NewTorrentWizard)this.wizard).byo_map.get("file_map")) != null) {
            for (Map map : list) {
                String target = MapUtils.getMapString(map, "target", null);
                List path = MapUtils.getMapList(map, "logical_path", null);
                if (target == null || path == null) continue;
                File targetFile = new File(target);
                if (path.size() == 1) {
                    this.addFilename(targetFile, (String)path.get(0), null, true);
                    continue;
                }
                TreeItem[] items = this.tree.getItems();
                TreeItem parent = null;
                for (int i = 0; i < path.size() - 1; ++i) {
                    TreeItem lastParent = parent;
                    String name = (String)path.get(i);
                    boolean found = false;
                    for (TreeItem item : items) {
                        if (!item.getText().equals(name)) continue;
                        parent = item;
                        found = true;
                        break;
                    }
                    if (!found) {
                        parent = this.createContainer(lastParent, name);
                    }
                    items = parent.getItems();
                }
                String name = (String)path.get(path.size() - 1);
                this.addFilename(targetFile, name, parent, false);
            }
        }
    }

    private void createDragSource(final Tree tree) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 2;
        final DragSource source = new DragSource((Control)tree, operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event2) {
                TreeItem[] selection = tree.getSelection();
                event2.doit = selection.length > 0;
                tree.setData("dragging", (Object)1);
            }

            public void dragSetData(DragSourceEvent event2) {
                event2.data = "drag";
                event2.detail = 2;
            }

            public void dragFinished(DragSourceEvent event2) {
                tree.setData("dragging", null);
            }
        });
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                source.dispose();
            }
        });
    }

    protected void editSelected() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length == 1) {
            SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("wizard.newtorrent.byo.editname.title", "wizard.newtorrent.byo.editname.text");
            entryWindow.setPreenteredText(selection[0].getText(), false);
            entryWindow.prompt();
            if (entryWindow.hasSubmittedInput()) {
                selection[0].setText(entryWindow.getSubmittedInput());
            }
        }
    }

    private void createDropTarget(final Tree tree) {
        final DropTarget dropTarget = new DropTarget((Control)tree, 6);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event2) {
                event2.detail = 16;
                event2.feedback = 24;
                if (event2.item instanceof TreeItem) {
                    TreeItem item = (TreeItem)event2.item;
                    if (tree.getData("dragging") != null) {
                        TreeItem[] selection = tree.getSelection();
                        boolean ok = true;
                        for (TreeItem treeItem : selection) {
                            if (treeItem == item) {
                                ok = false;
                                break;
                            }
                            if (item.getData() == null) {
                                if (treeItem.getParentItem() != item) continue;
                                ok = false;
                                break;
                            }
                            if (treeItem.getParentItem() != item.getParentItem()) continue;
                            ok = false;
                            break;
                        }
                        if (!ok) {
                            event2.detail = 0;
                            return;
                        }
                    }
                    event2.feedback = item.getData() == null ? (event2.feedback |= 1) : (event2.feedback |= 4);
                }
            }

            public void drop(DropTargetEvent event2) {
                block5: {
                    TreeItem[] selection;
                    block4: {
                        if (!(event2.data instanceof String[])) break block4;
                        String[] sourceNames = (String[])event2.data;
                        if (sourceNames == null) {
                            event2.detail = 0;
                        }
                        if (event2.detail == 0) {
                            return;
                        }
                        for (String droppedFileStr : sourceNames) {
                            File droppedFile = new File(droppedFileStr);
                            BYOPanel.this.addFilename(droppedFile, (TreeItem)event2.item);
                        }
                        break block5;
                    }
                    if (!"drag".equals(event2.data)) break block5;
                    for (TreeItem treeItem : selection = tree.getSelection()) {
                        if (treeItem.isDisposed()) continue;
                        BYOPanel.this.moveItem(treeItem, (TreeItem)event2.item);
                    }
                }
            }
        });
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dropTarget.dispose();
            }
        });
    }

    protected void addFilename(File file) {
        this.addFilename(file, file.getName(), null, false);
    }

    protected void addFilename(File file, TreeItem parent) {
        this.addFilename(file, file.getName(), parent, false);
    }

    protected void addFilename(File file, String name, TreeItem parent, boolean init) {
        TreeItem firstItem;
        if (parent != null && parent.getData() != null) {
            parent = parent.getParentItem();
        }
        TreeItem treeItem = firstItem = this.tree.getItemCount() > 0 ? this.tree.getItem(0) : null;
        if (firstItem != null && firstItem.getData() != null) {
            parent = this.createContainer(null, file.getParentFile().getName());
        } else if (parent == null) {
            parent = firstItem;
        }
        if (!file.exists()) {
            this.createContainer(null, name);
        }
        TreeItem treeItem2 = parent == null ? new TreeItem(this.tree, 0) : new TreeItem(parent, 0);
        treeItem2.setText(new String[]{name, file.getAbsolutePath()});
        treeItem2.setData((Object)file);
        if (parent != null) {
            parent.setExpanded(true);
        }
        ((NewTorrentWizard)this.wizard).setNextEnabled(this.tree.getItemCount() >= 1);
    }

    private TreeItem createContainer(TreeItem parent, String name) {
        TreeItem[] selection = this.tree.getSelection();
        if (parent == null) {
            if (selection.length == 1 && selection[0].getData() == null) {
                parent = selection[0];
            } else if (selection.length > 0) {
                parent = selection[0].getParentItem();
            } else {
                TreeItem firstItem;
                TreeItem treeItem = firstItem = this.tree.getItemCount() > 0 ? this.tree.getItem(0) : null;
                if (firstItem != null && firstItem.getData() == null) {
                    parent = firstItem;
                }
            }
        }
        TreeItem item = parent == null ? new TreeItem(this.tree, 0, 0) : new TreeItem(parent, 0, 0);
        item.setText(new String[]{name, MessageText.getString("label.container.display")});
        while (this.tree.getItemCount() > 1) {
            TreeItem itemToMove = this.tree.getItem(1);
            this.moveItem(itemToMove, item);
        }
        item.setExpanded(true);
        return item;
    }

    private void moveItem(TreeItem itemToMove, TreeItem parent) {
        File parentFile;
        if (parent == null) {
            if (this.tree.getItemCount() == 0) {
                return;
            }
            parent = this.tree.getItem(0);
        }
        if ((parentFile = (File)parent.getData()) != null && !parentFile.isDirectory()) {
            parent = parent.getParentItem();
        }
        TreeItem itemNew = new TreeItem(parent, 0);
        for (int i = 0; i < this.tree.getColumnCount(); ++i) {
            itemNew.setText(i, itemToMove.getText(i));
        }
        File file = (File)itemToMove.getData();
        itemNew.setData((Object)file);
        while (itemToMove.getItemCount() > 0) {
            TreeItem subitemToMove = itemToMove.getItem(0);
            this.moveItem(subitemToMove, itemNew);
        }
        itemToMove.dispose();
    }

    @Override
    public IWizardPanel<NewTorrentWizard> getNextPanel() {
        if (this.tree.getItemCount() == 1) {
            TreeItem item = this.tree.getItem(0);
            String name = item.getText();
            File file = (File)item.getData();
            if (file != null && file.getName().equals(name) && file.exists()) {
                String parent = file.getParent();
                if (parent != null) {
                    ((NewTorrentWizard)this.wizard).setDefaultOpenDir(parent);
                }
                if (file.isDirectory()) {
                    ((NewTorrentWizard)this.wizard).directoryPath = file.getAbsolutePath();
                    NewTorrentWizard cfr_ignored_0 = (NewTorrentWizard)this.wizard;
                    ((NewTorrentWizard)this.wizard).create_mode = 2;
                    return new SavePathPanel((NewTorrentWizard)this.wizard, this);
                }
                ((NewTorrentWizard)this.wizard).singlePath = file.getAbsolutePath();
                NewTorrentWizard cfr_ignored_1 = (NewTorrentWizard)this.wizard;
                ((NewTorrentWizard)this.wizard).create_mode = 1;
                return new SavePathPanel((NewTorrentWizard)this.wizard, this);
            }
        }
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        map.put("file_map", list);
        this.buildList(list, this.tree.getItems());
        ((NewTorrentWizard)this.wizard).byo_map = map;
        try {
            ((NewTorrentWizard)this.wizard).byo_desc_file = AETemporaryFileHandler.createTempFile();
            FileUtil.writeBytesAsFile(((NewTorrentWizard)this.wizard).byo_desc_file.getAbsolutePath(), BEncoder.encode(map));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return new SavePathPanel((NewTorrentWizard)this.wizard, this);
    }

    private void buildList(List list, TreeItem[] items) {
        for (TreeItem treeItem : items) {
            if (treeItem == null || treeItem.isDisposed()) continue;
            TreeItem[] subItems = treeItem.getItems();
            File file = (File)treeItem.getData();
            if (file != null) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                list.add(m);
                ArrayList<String> path = new ArrayList<String>();
                do {
                    path.add(0, treeItem.getText());
                } while ((treeItem = treeItem.getParentItem()) != null);
                m.put("logical_path", path);
                m.put("target", file.getAbsolutePath());
            }
            if (subItems.length <= 0) continue;
            this.buildList(list, subItems);
        }
    }
}

