/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIInstanceFactory;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerEvent;
import org.gudy.azureus2.plugins.ui.UIManagerEventListener;
import org.gudy.azureus2.plugins.ui.UIMessage;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarItem;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.IMainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginConfigImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIMessageImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTStatusEntryImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarManagerCore;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISWTInstanceImpl
implements UIInstanceFactory,
UISWTInstance,
UIManagerEventListener {
    private Map<BasicPluginConfigModel, BasicPluginConfigImpl> config_view_map = new WeakHashMap<BasicPluginConfigModel, BasicPluginConfigImpl>();
    private Map<String, Map<String, UISWTViewEventListenerHolder>> views = new HashMap<String, Map<String, UISWTViewEventListenerHolder>>();
    private Map<PluginInterface, UIInstance> plugin_map = new WeakHashMap<PluginInterface, UIInstance>();
    private boolean bUIAttaching;
    private final UIFunctionsSWT uiFunctions;
    private List<SWTViewListener> listSWTViewListeners = new ArrayList<SWTViewListener>(0);

    public UISWTInstanceImpl() {
        this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
    }

    @Override
    public int getUIType() {
        return 1;
    }

    public void init(IUIIntializer init) {
        UIManager ui_manager = PluginInitializer.getDefaultInterface().getUIManager();
        ui_manager.addUIEventListener(this);
        this.bUIAttaching = true;
        ((UIManagerImpl)ui_manager).attachUI(this, init);
        this.bUIAttaching = false;
    }

    @Override
    public UIInstance getInstance(PluginInterface plugin_interface) {
        UIInstance instance = this.plugin_map.get(plugin_interface);
        if (instance == null) {
            instance = new instanceWrapper(plugin_interface, this.uiFunctions, this);
            this.plugin_map.put(plugin_interface, instance);
        }
        return instance;
    }

    @Override
    public boolean eventOccurred(UIManagerEvent event2) {
        boolean done = true;
        final Object data = event2.getData();
        switch (event2.getType()) {
            case 1: {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        String[] params = (String[])data;
                        new TextViewerWindow(params[0], params[1], params[2]);
                    }
                });
                break;
            }
            case 21: {
                final int[] result = new int[]{0};
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        UIFunctionsManagerSWT.getUIFunctionsSWT().bringToFront();
                        Object[] params = (Object[])data;
                        long _styles = (Long)params[2];
                        int styles = 0;
                        int def = 0;
                        if ((_styles & 4L) != 0L) {
                            styles |= 0x40;
                        }
                        if ((_styles & 0x10L) != 0L) {
                            styles |= 0x40;
                            def = 64;
                        }
                        if ((_styles & 8L) != 0L) {
                            styles |= 0x80;
                        }
                        if ((_styles & 0x20L) != 0L) {
                            styles |= 0x80;
                            def = 128;
                        }
                        if ((_styles & 1L) != 0L) {
                            styles |= 0x20;
                        }
                        if ((_styles & 0x40L) != 0L) {
                            styles |= 0x20;
                            def = 32;
                        }
                        if ((_styles & 2L) != 0L) {
                            styles |= 0x100;
                        }
                        MessageBoxShell mb = new MessageBoxShell(styles, MessageText.getString((String)params[0]), MessageText.getString((String)params[1]));
                        if (def != 0) {
                            mb.setDefaultButtonUsingStyle(def);
                        }
                        if (params.length == 4 && params[3] instanceof Map) {
                            Number auto_close_ms;
                            Map options = (Map)params[3];
                            String rememberID = (String)options.get("remember-id");
                            Boolean rememberByDefault = (Boolean)options.get("remember-by-def");
                            String rememberText = (String)options.get("remember-res");
                            if (rememberID != null && rememberByDefault != null && rememberText != null) {
                                mb.setRemember(rememberID, rememberByDefault, rememberText);
                            }
                            if ((auto_close_ms = (Number)options.get("auto-close-ms")) != null) {
                                mb.setAutoCloseInMS(auto_close_ms.intValue());
                            }
                        } else if (params.length >= 6) {
                            String rememberID = (String)params[3];
                            Boolean rememberByDefault = (Boolean)params[4];
                            String rememberText = (String)params[5];
                            if (rememberID != null && rememberByDefault != null && rememberText != null) {
                                mb.setRemember(rememberID, rememberByDefault, rememberText);
                            }
                        }
                        mb.open(null);
                        int _r = mb.waitUntilClosed();
                        int r = 0;
                        if ((_r & 0x40) != 0) {
                            r |= 4;
                        }
                        if ((_r & 0x80) != 0) {
                            r |= 8;
                        }
                        if ((_r & 0x20) != 0) {
                            r |= 1;
                        }
                        if ((_r & 0x100) != 0) {
                            r |= 2;
                        }
                        result[0] = r;
                    }
                }, false);
                event2.setResult(new Long(result[0]));
                break;
            }
            case 2: {
                TorrentOpener.openTorrent(((File)data).toString());
                break;
            }
            case 22: {
                Torrent t = (Torrent)data;
                try {
                    File f = AETemporaryFileHandler.createTempFile();
                    t.writeToFile(f);
                    TorrentOpener.openTorrent(f.toString());
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                break;
            }
            case 3: {
                Display display = SWTThread.getInstance().getDisplay();
                display.syncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        Object[] params = (Object[])data;
                        URL target = (URL)params[0];
                        URL referrer = (URL)params[1];
                        boolean auto_download = (Boolean)params[2];
                        Map request_properties = (Map)params[3];
                        if (auto_download) {
                            Shell shell = UISWTInstanceImpl.this.uiFunctions.getMainShell();
                            if (shell != null) {
                                new FileDownloadWindow(shell, target.toString(), referrer == null ? null : referrer.toString(), request_properties);
                            }
                        } else {
                            TorrentOpener.openTorrent(target.toString());
                        }
                    }
                });
                break;
            }
            case 4: {
                if (!(data instanceof BasicPluginViewModel)) break;
                BasicPluginViewModel model = (BasicPluginViewModel)data;
                String sViewID = model.getName().replaceAll(" ", ".");
                BasicPluginViewImpl view = new BasicPluginViewImpl(model);
                this.addView("Main", sViewID, view);
                break;
            }
            case 7: {
                if (!(data instanceof BasicPluginViewModel)) break;
                BasicPluginViewModel model = (BasicPluginViewModel)data;
                String sViewID = model.getName().replaceAll(" ", ".");
                this.removeViews("Main", sViewID);
                break;
            }
            case 5: {
                if (!(data instanceof BasicPluginConfigModel)) break;
                BasicPluginConfigModel model = (BasicPluginConfigModel)data;
                BasicPluginConfigImpl view = new BasicPluginConfigImpl(new WeakReference<BasicPluginConfigModel>(model));
                this.config_view_map.put(model, view);
                ConfigSectionRepository.getInstance().addConfigSection(view, model.getPluginInterface());
                break;
            }
            case 8: {
                BasicPluginConfigModel model;
                BasicPluginConfigImpl view;
                if (!(data instanceof BasicPluginConfigModel) || (view = this.config_view_map.get(model = (BasicPluginConfigModel)data)) == null) break;
                ConfigSectionRepository.getInstance().removeConfigSection(view);
                break;
            }
            case 6: {
                ClipboardCopy.copyToClipBoard((String)data);
                break;
            }
            case 9: {
                Utils.launch(((URL)data).toExternalForm());
                break;
            }
            case 10: {
                if (data instanceof TableColumn) {
                    event2.setResult(data);
                    break;
                }
                String[] args = (String[])data;
                event2.setResult(new TableColumnImpl(args[0], args[1]));
                break;
            }
            case 11: {
                TableColumn _col = (TableColumn)data;
                if (_col instanceof TableColumnImpl) {
                    TableColumnManager.getInstance().addColumns(new TableColumnCore[]{(TableColumnCore)_col});
                    TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(_col.getTableID());
                    tsed.tableStructureChanged(true, _col.getForDataSourceType());
                    break;
                }
                throw new UIRuntimeException("TableManager.addColumn(..) can only add columns created by createColumn(..)");
            }
            case 25: {
                String[] tables;
                Object[] params = (Object[])data;
                TableColumnManager tcManager = TableColumnManager.getInstance();
                Class dataSource = (Class)params[0];
                String columnName = (String)params[1];
                tcManager.registerColumn(dataSource, columnName, (TableColumnCreationListener)params[2]);
                for (String tid : tables = tcManager.getTableIDs()) {
                    TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(tid);
                    tsed.tableStructureChanged(true, dataSource);
                }
                break;
            }
            case 26: {
                String[] tables;
                Object[] params = (Object[])data;
                TableColumnManager tcManager = TableColumnManager.getInstance();
                Class dataSource = (Class)params[0];
                String columnName = (String)params[1];
                tcManager.unregisterColumn(dataSource, columnName, (TableColumnCreationListener)params[2]);
                for (String tid : tables = tcManager.getTableIDs()) {
                    TableColumnCore col = tcManager.getTableColumnCore(tid, columnName);
                    if (col == null) continue;
                    col.remove();
                }
                break;
            }
            case 12: {
                TableContextMenuItem item = (TableContextMenuItem)data;
                TableContextMenuManager.getInstance().addContextMenuItem(item);
                break;
            }
            case 15: {
                MenuItem item = (MenuItem)data;
                MenuItemManager.getInstance().addMenuItem(item);
                break;
            }
            case 17: {
                TableContextMenuItem item = (TableContextMenuItem)data;
                TableContextMenuManager.getInstance().removeContextMenuItem(item);
                break;
            }
            case 19: {
                MenuItem item = (MenuItem)data;
                MenuItemManager.getInstance().removeMenuItem(item);
                break;
            }
            case 13: {
                event2.setResult(new Boolean(false));
                if (!(data instanceof String)) break;
                event2.setResult(Boolean.TRUE);
                this.uiFunctions.getMDI().showEntryByID("ConfigView", data);
                break;
            }
            case 24: {
                File file_to_use = (File)data;
                Utils.launch(file_to_use.getAbsolutePath());
                break;
            }
            case 23: {
                File file_to_use = (File)data;
                boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
                ManagerUtils.open(file_to_use, use_open_containing_folder);
                break;
            }
            case 27: {
                boolean hide = (Boolean)data;
                this.uiFunctions.setHideAll(hide);
                break;
            }
            default: {
                done = false;
            }
        }
        return done;
    }

    @Override
    public Display getDisplay() {
        return SWTThread.getInstance().getDisplay();
    }

    @Override
    public Image loadImage(String resource) {
        throw new RuntimeException("plugin specific instance required");
    }

    @Override
    public UISWTGraphic createGraphic(Image img) {
        return new UISWTGraphicImpl(img);
    }

    @Override
    public Shell createShell(int style) {
        Shell shell = ShellFactory.createMainShell(style);
        Utils.setShellIcon(shell);
        return shell;
    }

    @Override
    public void detach() throws UIException {
        throw new UIException("not supported");
    }

    @Override
    public void addView(String sParentID, String sViewID, Class<? extends UISWTViewEventListener> cla, Object datasource) {
        this.addView(null, sParentID, sViewID, cla, datasource);
    }

    public void addView(PluginInterface pi, String sParentID, String sViewID, Class<? extends UISWTViewEventListener> cla, Object datasource) {
        UISWTViewEventListenerHolder _l = new UISWTViewEventListenerHolder(sViewID, cla, datasource, pi);
        this.addView(sParentID, sViewID, _l);
    }

    @Override
    public void addView(String sParentID, String sViewID, UISWTViewEventListener l) {
        UISWTViewEventListenerHolder _l = new UISWTViewEventListenerHolder(sViewID, l, null);
        this.addView(sParentID, sViewID, _l);
    }

    public void addView(String sParentID, final String sViewID, final UISWTViewEventListenerHolder holder) {
        SWTViewListener[] viewListeners;
        Map<String, UISWTViewEventListenerHolder> subViews;
        if (sParentID == null) {
            sParentID = "Main";
        }
        if ((subViews = this.views.get(sParentID)) == null) {
            subViews = new LinkedHashMap<String, UISWTViewEventListenerHolder>();
            this.views.put(sParentID, subViews);
        }
        subViews.put(sViewID, holder);
        if (sParentID.equals("Main")) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    try {
                        UISWTInstanceImpl.this.uiFunctions.addPluginView(sViewID, holder);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        for (SWTViewListener l : viewListeners = this.listSWTViewListeners.toArray(new SWTViewListener[0])) {
            l.setViewAdded(sParentID, sViewID, holder);
        }
    }

    public void addSWTViewListener(SWTViewListener l) {
        this.listSWTViewListeners.add(l);
    }

    public void removeSWTViewListener(SWTViewListener l) {
        this.listSWTViewListeners.remove(l);
    }

    @Override
    public void removeViews(String sParentID, final String sViewID) {
        Map<String, UISWTViewEventListenerHolder> subViews = this.views.get(sParentID);
        if (subViews == null) {
            return;
        }
        if (sParentID.equals("Main")) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    try {
                        if (UISWTInstanceImpl.this.uiFunctions != null) {
                            UISWTInstanceImpl.this.uiFunctions.removePluginView(sViewID);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        SWTViewListener[] viewListeners = this.listSWTViewListeners.toArray(new SWTViewListener[0]);
        for (UISWTViewEventListenerHolder holder : subViews.values()) {
            for (SWTViewListener l : viewListeners) {
                l.setViewRemoved(sParentID, sViewID, holder);
            }
        }
        subViews.remove(sViewID);
    }

    @Override
    public boolean openView(String sParentID, String sViewID, Object dataSource) {
        return this.openView(sParentID, sViewID, dataSource, true);
    }

    @Override
    public boolean openView(final String sParentID, final String sViewID, final Object dataSource, final boolean setfocus) {
        Map<String, UISWTViewEventListenerHolder> subViews = this.views.get(sParentID);
        if (subViews == null) {
            return false;
        }
        final UISWTViewEventListenerHolder l = subViews.get(sViewID);
        if (l == null) {
            return false;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (UISWTInstanceImpl.this.uiFunctions != null) {
                    UISWTInstanceImpl.this.uiFunctions.openPluginView(sParentID, sViewID, l, dataSource, setfocus && !UISWTInstanceImpl.this.bUIAttaching);
                }
            }
        });
        return true;
    }

    @Override
    public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource) {
        this.openMainView(null, sViewID, l, dataSource, true);
    }

    public void openMainView(PluginInterface pi, String sViewID, UISWTViewEventListener l, Object dataSource) {
        this.openMainView(pi, sViewID, l, dataSource, true);
    }

    @Override
    public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource, boolean setfocus) {
        this.openMainView(null, sViewID, l, dataSource, setfocus);
    }

    public void openMainView(final PluginInterface pi, final String sViewID, final UISWTViewEventListener _l, final Object dataSource, final boolean setfocus) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (UISWTInstanceImpl.this.uiFunctions != null) {
                    UISWTViewEventListenerHolder l = new UISWTViewEventListenerHolder(sViewID, _l, pi);
                    UISWTInstanceImpl.this.uiFunctions.openPluginView("Main", sViewID, l, dataSource, setfocus && !UISWTInstanceImpl.this.bUIAttaching);
                }
            }
        });
    }

    @Override
    public UISWTView[] getOpenViews(String sParentID) {
        if (sParentID.equals("Main")) {
            try {
                if (this.uiFunctions != null) {
                    return this.uiFunctions.getPluginViews();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new UISWTView[0];
    }

    @Override
    public int promptUser(String title, String text, String[] options, int defaultOption) {
        MessageBoxShell mb = new MessageBoxShell(title, text, options, defaultOption);
        mb.open(null);
        return mb.waitUntilClosed();
    }

    @Override
    public void showDownloadBar(Download download, final boolean display) {
        if (!(download instanceof DownloadImpl)) {
            return;
        }
        final DownloadManager dm = ((DownloadImpl)download).getDownload();
        if (dm == null) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                if (display) {
                    DownloadBar.open(dm, UISWTInstanceImpl.this.getDisplay().getActiveShell());
                } else {
                    DownloadBar.close(dm);
                }
            }
        }, false);
    }

    @Override
    public void showTransfersBar(final boolean display) {
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                if (display) {
                    AllTransfersBar.open(UISWTInstanceImpl.this.getDisplay().getActiveShell());
                } else {
                    AllTransfersBar.closeAllTransfersBar();
                }
            }
        }, false);
    }

    public UISWTViewEventListenerHolder[] getViewListeners(String sParentID) {
        Map<String, UISWTViewEventListenerHolder> map = this.views.get(sParentID);
        if (map == null) {
            return new UISWTViewEventListenerHolder[0];
        }
        UISWTViewEventListenerHolder[] array = map.values().toArray(new UISWTViewEventListenerHolder[0]);
        Arrays.sort(array, new Comparator<UISWTViewEventListenerHolder>(){

            @Override
            public int compare(UISWTViewEventListenerHolder o1, UISWTViewEventListenerHolder o2) {
                if (o1.getPluginInterface() == null && o2.getPluginInterface() == null) {
                    return 0;
                }
                if (o1.getPluginInterface() != null && o2.getPluginInterface() != null) {
                    return 0;
                }
                return o1.getPluginInterface() == null ? -1 : 1;
            }
        });
        return array;
    }

    @Override
    public UIInputReceiver getInputReceiver() {
        return new SimpleTextEntryWindow();
    }

    @Override
    public UIMessage createMessage() {
        return new UIMessageImpl();
    }

    @Override
    public UISWTStatusEntry createStatusEntry() {
        UISWTStatusEntryImpl entry = new UISWTStatusEntryImpl();
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT == null) {
            Debug.outNoStack("No UIFunctionsSWT on createStatusEntry");
            return null;
        }
        IMainStatusBar mainStatusBar = functionsSWT.getMainStatusBar();
        if (mainStatusBar == null) {
            Debug.outNoStack("No MainStatusBar on createStatusEntry");
            return null;
        }
        mainStatusBar.createStatusEntry(entry);
        return entry;
    }

    @Override
    public boolean openView(BasicPluginViewModel model) {
        return this.openView("Main", model.getName().replaceAll(" ", "."), null);
    }

    @Override
    public void openConfig(final BasicPluginConfigModel model) {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                UISWTInstanceImpl.this.uiFunctions.getMDI().loadEntryByID("ConfigView", true, false, model.getSection());
            }
        });
    }

    @Override
    public UIToolBarManager getToolBarManager() {
        throw new RuntimeException("plugin specific instance required");
    }

    @Override
    public void unload(PluginInterface pi) {
        throw new RuntimeException("plugin specific instance required");
    }

    public static interface SWTViewListener {
        public void setViewAdded(String var1, String var2, UISWTViewEventListener var3);

        public void setViewRemoved(String var1, String var2, UISWTViewEventListener var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class instanceWrapper
    implements UISWTInstance,
    UIToolBarManager {
        private WeakReference<PluginInterface> pi_ref;
        private UIFunctionsSWT ui_functions;
        private UISWTInstanceImpl delegate;
        private UIToolBarManagerCore toolBarManager;
        private List<UIToolBarItem> listItems = new ArrayList<UIToolBarItem>();
        private List<Resource> listDisposeOnUnload = new ArrayList<Resource>();

        protected instanceWrapper(PluginInterface _pi, UIFunctionsSWT _ui_functions, UISWTInstanceImpl _delegate) {
            this.pi_ref = new WeakReference<PluginInterface>(_pi);
            this.ui_functions = _ui_functions;
            this.delegate = _delegate;
        }

        @Override
        public UIToolBarItem getToolBarItem(String id) {
            return this.toolBarManager.getToolBarItem(id);
        }

        @Override
        public UIToolBarItem[] getAllToolBarItems() {
            return this.toolBarManager.getAllToolBarItems();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UIToolBarItem createToolBarItem(String id) {
            UIToolBarItem addToolBarItem = this.toolBarManager.createToolBarItem(id);
            instanceWrapper instanceWrapper2 = this;
            synchronized (instanceWrapper2) {
                this.listItems.add(addToolBarItem);
            }
            return addToolBarItem;
        }

        @Override
        public void addToolBarItem(UIToolBarItem item) {
            this.toolBarManager.addToolBarItem(item);
        }

        @Override
        public void removeToolBarItem(String id) {
            this.toolBarManager.removeToolBarItem(id);
        }

        public void detach() throws UIException {
            this.delegate.detach();
        }

        @Override
        public int getUIType() {
            return this.delegate.getUIType();
        }

        @Override
        public Display getDisplay() {
            return this.delegate.getDisplay();
        }

        @Override
        public Image loadImage(String resource) {
            PluginInterface pi = (PluginInterface)this.pi_ref.get();
            if (pi == null) {
                return null;
            }
            InputStream is = pi.getPluginClassLoader().getResourceAsStream(resource);
            if (is != null) {
                ImageData imageData = new ImageData(is);
                try {
                    is.close();
                }
                catch (IOException e) {
                    Debug.out(e);
                }
                Display display = this.getDisplay();
                Image image = new Image((Device)display, imageData);
                image = Utils.adjustPXForDPI(display, image);
                this.listDisposeOnUnload.add((Resource)image);
                return image;
            }
            return null;
        }

        @Override
        public UISWTGraphic createGraphic(Image img) {
            return this.delegate.createGraphic(img);
        }

        @Override
        public void addView(String sParentID, String sViewID, UISWTViewEventListener l) {
            PluginInterface pi = (PluginInterface)this.pi_ref.get();
            this.delegate.addView(sParentID, sViewID, new UISWTViewEventListenerHolder(sViewID, l, pi));
        }

        @Override
        public void addView(String sParentID, String sViewID, Class<? extends UISWTViewEventListener> cla, Object datasource) {
            PluginInterface pi = (PluginInterface)this.pi_ref.get();
            this.delegate.addView(sParentID, sViewID, new UISWTViewEventListenerHolder(sViewID, cla, datasource, pi));
        }

        @Override
        public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource) {
            PluginInterface pi = (PluginInterface)this.pi_ref.get();
            this.delegate.openMainView(pi, sViewID, l, dataSource);
        }

        @Override
        public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource, boolean setfocus) {
            PluginInterface pi = (PluginInterface)this.pi_ref.get();
            this.delegate.openMainView(pi, sViewID, l, dataSource, setfocus);
        }

        @Override
        public void removeViews(String sParentID, String sViewID) {
            this.delegate.removeViews(sParentID, sViewID);
        }

        @Override
        public UISWTView[] getOpenViews(String sParentID) {
            return this.delegate.getOpenViews(sParentID);
        }

        @Override
        public int promptUser(String title, String text, String[] options, int defaultOption) {
            return this.delegate.promptUser(title, text, options, defaultOption);
        }

        @Override
        public boolean openView(String sParentID, String sViewID, Object dataSource) {
            return this.delegate.openView(sParentID, sViewID, dataSource);
        }

        @Override
        public boolean openView(String sParentID, String sViewID, Object dataSource, boolean setfocus) {
            return this.delegate.openView(sParentID, sViewID, dataSource, setfocus);
        }

        @Override
        public UISWTInstance.UISWTViewEventListenerWrapper[] getViewListeners(String sParentId) {
            return this.delegate.getViewListeners(sParentId);
        }

        @Override
        public UIInputReceiver getInputReceiver() {
            return this.delegate.getInputReceiver();
        }

        @Override
        public UIMessage createMessage() {
            return this.delegate.createMessage();
        }

        @Override
        public void showDownloadBar(Download download, boolean display) {
            this.delegate.showDownloadBar(download, display);
        }

        @Override
        public void showTransfersBar(boolean display) {
            this.delegate.showTransfersBar(display);
        }

        @Override
        public UISWTStatusEntry createStatusEntry() {
            return this.delegate.createStatusEntry();
        }

        @Override
        public boolean openView(BasicPluginViewModel model) {
            return this.delegate.openView(model);
        }

        @Override
        public void openConfig(BasicPluginConfigModel model) {
            this.delegate.openConfig(model);
        }

        @Override
        public Shell createShell(int style) {
            return this.delegate.createShell(style);
        }

        @Override
        public UIToolBarManager getToolBarManager() {
            if (this.toolBarManager == null) {
                UIToolBarManager tbm = this.ui_functions.getToolBarManager();
                if (tbm instanceof UIToolBarManagerCore) {
                    this.toolBarManager = (UIToolBarManagerCore)tbm;
                } else {
                    return null;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unload(PluginInterface pi) {
            if (this.toolBarManager != null) {
                instanceWrapper instanceWrapper2 = this;
                synchronized (instanceWrapper2) {
                    for (UIToolBarItem item : this.listItems) {
                        this.toolBarManager.removeToolBarItem(item.getID());
                    }
                    this.listItems.clear();
                }
            }
            Utils.disposeSWTObjects(this.listDisposeOnUnload);
            this.listDisposeOnUnload.clear();
        }
    }
}

