/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.progress;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationListener;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class ProgressWindow {
    private volatile Shell shell;
    private volatile boolean task_complete;
    private final String resource;
    private Image[] spinImages;
    protected int curSpinIndex = 0;

    public static void register(AzureusCore core) {
        core.addOperationListener(new AzureusCoreOperationListener(){

            public boolean operationCreated(AzureusCoreOperation operation) {
                if ((operation.getOperationType() == 2 || operation.getOperationType() == 3) && Utils.isThisThreadSWT() && operation.getTask() != null) {
                    new ProgressWindow(operation);
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProgressWindow(final AzureusCoreOperation operation) {
        ProgressWindow progressWindow;
        final RuntimeException[] error = new RuntimeException[]{null};
        this.resource = operation.getOperationType() == 2 ? "progress.window.msg.filemove" : "progress.window.msg.progress";
        new DelayedEvent("ProgWin", operation.getOperationType() == 2 ? 1000L : 10L, new AERunnable(){

            public void runSupport() {
                if (!ProgressWindow.this.task_complete) {
                    Utils.execSWTThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            ProgressWindow progressWindow = ProgressWindow.this;
                            synchronized (progressWindow) {
                                if (!ProgressWindow.this.task_complete) {
                                    Shell shell = ShellFactory.createMainShell(2144);
                                    ProgressWindow.this.showDialog(shell);
                                }
                            }
                        }
                    }, false);
                }
            }
        });
        new AEThread2("ProgressWindow", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        AzureusCoreOperationTask task2 = operation.getTask();
                        if (task2 == null) {
                            throw new RuntimeException("Task not available");
                        }
                        task2.run(operation);
                    }
                    catch (RuntimeException e) {
                        error[0] = e;
                        Object var3_5 = null;
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                ProgressWindow.this.destroy();
                            }
                        });
                        return;
                    }
                    catch (Throwable e) {
                        error[0] = new RuntimeException(e);
                        Object var3_6 = null;
                        Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
        try {
            Display display = SWTThread.getInstance().getDisplay();
            while (!this.task_complete && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            Object var5_4 = null;
            progressWindow = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ProgressWindow progressWindow2 = this;
            synchronized (progressWindow2) {
                this.task_complete = true;
            }
            try {
                if (this.shell != null && !this.shell.isDisposed()) {
                    this.shell.dispose();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            throw throwable;
        }
        synchronized (progressWindow) {
            this.task_complete = true;
        }
        try {
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    public ProgressWindow(Shell _parent, String _resource, int _style, int _delay_millis) {
        this.resource = _resource;
        final Shell shell = new Shell(_parent, _style);
        if (_delay_millis <= 0) {
            this.showDialog(shell);
        } else {
            new DelayedEvent("ProgWin", _delay_millis, new AERunnable(){

                public void runSupport() {
                    if (!ProgressWindow.this.task_complete) {
                        Utils.execSWTThread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                ProgressWindow progressWindow = ProgressWindow.this;
                                synchronized (progressWindow) {
                                    if (!ProgressWindow.this.task_complete) {
                                        ProgressWindow.this.showDialog(shell);
                                    }
                                }
                            }
                        }, false);
                    }
                }
            });
        }
    }

    protected void showDialog(Shell _shell) {
        this.shell = _shell;
        this.shell.setText(MessageText.getString("progress.window.title"));
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        this.spinImages = ImageLoader.getInstance().getImages("working");
        if (this.spinImages == null || this.spinImages.length == 0) {
            new Label((Composite)this.shell, 0);
        } else {
            final Rectangle spinBounds = this.spinImages[0].getBounds();
            final Canvas canvas = new Canvas((Composite)this.shell, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(spinBounds.width, spinBounds.height);
                }
            };
            canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(ProgressWindow.this.spinImages[ProgressWindow.this.curSpinIndex], 0, 0);
                }
            });
            Utils.execSWTThreadLater(100, new AERunnable(){

                public void runSupport() {
                    if (canvas == null || canvas.isDisposed()) {
                        return;
                    }
                    canvas.redraw();
                    canvas.update();
                    ProgressWindow.this.curSpinIndex = ProgressWindow.this.curSpinIndex == ProgressWindow.this.spinImages.length - 1 ? 0 : ++ProgressWindow.this.curSpinIndex;
                    Utils.execSWTThreadLater(100, this);
                }
            });
        }
        Label label = new Label((Composite)this.shell, 0);
        label.setText(MessageText.getString(this.resource));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.shell.pack();
        Composite parent = this.shell.getParent();
        if (parent != null) {
            Utils.centerWindowRelativeTo(this.shell, (Control)parent);
        } else {
            Utils.centreWindow(this.shell);
        }
        this.shell.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ProgressWindow progressWindow = this;
        synchronized (progressWindow) {
            this.task_complete = true;
        }
        try {
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (this.spinImages != null) {
            ImageLoader.getInstance().releaseImage("working");
            this.spinImages = null;
        }
    }
}

