/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.sharing;

import java.io.File;
import java.util.Map;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareUtils {
    public static void shareFile(final Shell shell) {
        new AEThread("shareFile"){

            public void runSupport() {
                Display display = shell.getDisplay();
                final String[] path = new String[]{null};
                final AESemaphore sem = new AESemaphore("ShareUtils:file");
                display.asyncExec((Runnable)new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        try {
                            FileDialog dialog = new FileDialog(shell, 135168);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("MainWindow.dialog.share.sharefile"));
                            path[0] = TorrentOpener.setFilterPathData(dialog.open());
                            Object var3_2 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            sem.release();
                            throw throwable;
                        }
                    }
                });
                sem.reserve();
                if (path[0] != null) {
                    ShareUtils.shareFile(path[0]);
                }
            }
        }.start();
    }

    public static void shareDir(Shell shell) {
        ShareUtils.shareDirSupport(shell, false, false);
    }

    public static void shareDirContents(Shell shell, boolean recursive) {
        ShareUtils.shareDirSupport(shell, true, recursive);
    }

    protected static void shareDirSupport(final Shell shell, final boolean contents, final boolean recursive) {
        new AEThread("shareDirSupport"){

            public void runSupport() {
                Display display = shell.getDisplay();
                final String[] path = new String[]{null};
                final AESemaphore sem = new AESemaphore("ShareUtils:dir");
                display.asyncExec((Runnable)new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        try {
                            DirectoryDialog dialog = new DirectoryDialog(shell, 131072);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(contents ? MessageText.getString("MainWindow.dialog.share.sharedircontents") + (recursive ? "(" + MessageText.getString("MainWindow.dialog.share.sharedircontents.recursive") + ")" : "") : MessageText.getString("MainWindow.dialog.share.sharedir"));
                            path[0] = TorrentOpener.setFilterPathData(dialog.open());
                            Object var3_2 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            sem.release();
                            throw throwable;
                        }
                    }
                });
                sem.reserve();
                if (path[0] != null) {
                    if (contents) {
                        ShareUtils.shareDirContents(path[0], recursive);
                    } else {
                        ShareUtils.shareDir(path[0]);
                    }
                }
            }
        }.start();
    }

    public static void shareFile(String file_name) {
        ShareUtils.shareFile(file_name, null);
    }

    public static void shareFile(final String file_name, final Map<String, String> properties) {
        new AEThread("shareFile"){

            public void runSupport() {
                try {
                    PluginInitializer.getDefaultInterface().getShareManager().addFile(new File(file_name), properties);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }

    public static void shareDir(String file_name) {
        ShareUtils.shareDir(file_name, null);
    }

    public static void shareDir(final String file_name, final Map<String, String> properties) {
        new AEThread("shareDir"){

            public void runSupport() {
                try {
                    PluginInitializer.getDefaultInterface().getShareManager().addDir(new File(file_name), properties);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }

    public static void shareDirContents(final String file_name, final boolean recursive) {
        new AEThread("shareDirCntents"){

            public void runSupport() {
                try {
                    PluginInitializer.getDefaultInterface().getShareManager().addDirContents(new File(file_name), recursive);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }
}

