/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class AdvRenameWindow {
    private DownloadManager dm;
    private Shell shell;
    private String newName = null;
    protected int renameDecisions;
    private static final int RENAME_DISPLAY = 1;
    private static final int RENAME_SAVEPATH = 2;
    private static final int RENAME_TORRENT = 4;

    public static void main(String[] args) {
        AdvRenameWindow window = new AdvRenameWindow();
        window.open(null);
        window.waitUntilDone();
    }

    public void open(DownloadManager dm) {
        this.dm = dm;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                AdvRenameWindow.this.openInSWT();
            }
        });
    }

    private void openInSWT() {
        this.shell = ShellFactory.createMainShell(2160);
        Utils.setShellIcon(this.shell);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    AdvRenameWindow.this.shell.dispose();
                }
            }
        });
        Messages.setLanguageText((Widget)this.shell, "AdvRenameWindow.title");
        Label lblMessage = new Label((Composite)this.shell, 64);
        Messages.setLanguageText((Widget)lblMessage, "AdvRenameWindow.message");
        final Text txtInput = new Text((Composite)this.shell, 2048);
        txtInput.setText(this.dm == null ? "" : this.dm.getDisplayName());
        final Button btnDisplayName = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnDisplayName, "MyTorrentsView.menu.rename.displayed");
        final Button btnSavePath = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnSavePath, "MyTorrentsView.menu.rename.save_path");
        final Button btnTorrent = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnTorrent, "AdvRenameWindow.rename.torrent");
        Composite cButtons = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.fill = true;
        rowLayout.spacing = 5;
        Utils.setLayout(cButtons, rowLayout);
        Button btnReset = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnReset, "Button.reset");
        btnReset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                txtInput.setText(TorrentUtils.getLocalisedName(AdvRenameWindow.this.dm.getTorrent()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnOk = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnOk, "Button.ok");
        this.shell.setDefaultButton(btnOk);
        btnOk.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AdvRenameWindow.this.newName = txtInput.getText();
                AdvRenameWindow.this.renameDecisions = 0;
                if (btnDisplayName.getSelection()) {
                    AdvRenameWindow.this.renameDecisions |= 1;
                }
                if (btnSavePath.getSelection()) {
                    AdvRenameWindow.this.renameDecisions |= 2;
                }
                if (btnTorrent.getSelection()) {
                    AdvRenameWindow.this.renameDecisions |= 4;
                }
                RememberedDecisionsManager.setRemembered("adv.rename", AdvRenameWindow.this.renameDecisions);
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        AdvRenameWindow.this.doRename();
                    }
                });
                AdvRenameWindow.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnCancel = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnCancel, "Button.cancel");
        btnCancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AdvRenameWindow.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.shell.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        lblMessage.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lblMessage, 5);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        fd.width = 300;
        txtInput.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)txtInput, 5);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -3);
        btnDisplayName.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnDisplayName, 2);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -3);
        btnSavePath.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnSavePath, 2);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -3);
        btnTorrent.setLayoutData((Object)fd);
        int renameDecisions = RememberedDecisionsManager.getRememberedDecision("adv.rename");
        if ((renameDecisions & 1) > 0) {
            btnDisplayName.setSelection(true);
        }
        if ((renameDecisions & 2) > 0) {
            btnSavePath.setSelection(true);
        }
        if ((renameDecisions & 4) > 0) {
            btnTorrent.setSelection(true);
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnTorrent, 5);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment(100, -3);
        cButtons.setLayoutData((Object)fd);
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    private void waitUntilDone() {
        while (this.shell != null && !this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void doRename() {
        if (this.dm == null) {
            return;
        }
        boolean saveLocationIsFolder = this.dm.getSaveLocation().isDirectory();
        String newDisplayName = this.newName;
        String newSavePath = FileUtil.convertOSSpecificChars(this.newName, saveLocationIsFolder);
        String newTorrentName = FileUtil.convertOSSpecificChars(this.newName, false);
        if ((this.renameDecisions & 1) > 0) {
            this.dm.getDownloadState().setDisplayName(newDisplayName);
        }
        if ((this.renameDecisions & 2) > 0) {
            try {
                try {
                    String dnd_sf;
                    if (this.dm.getTorrent().isSimpleTorrent() && (dnd_sf = this.dm.getDownloadState().getAttribute("incompfilesuffix")) != null) {
                        dnd_sf = dnd_sf.trim();
                        String existing_name = this.dm.getSaveLocation().getName();
                        if (existing_name.endsWith(dnd_sf) && !newSavePath.endsWith(dnd_sf)) {
                            newSavePath = newSavePath + dnd_sf;
                        }
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this.dm.renameDownload(newSavePath);
            }
            catch (Exception e) {
                Logger.log(new LogAlert((Object)this.dm, true, "Download data rename operation failed", (Throwable)e));
            }
        }
        if ((this.renameDecisions & 4) > 0) {
            try {
                this.dm.renameTorrentSafe(newTorrentName);
            }
            catch (Exception e) {
                Logger.log(new LogAlert((Object)this.dm, true, "Torrent rename operation failed", (Throwable)e));
            }
        }
    }
}

