/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import java.util.ArrayList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateCheckerListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.update.UpdateProgressListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class UpdateProgressWindow
implements UpdateManagerListener {
    protected Display display;
    protected Shell window;
    protected StyledText text_area;
    protected UpdateManager manager;
    protected ArrayList current_instances = new ArrayList();

    public static void show(UpdateCheckInstance[] instances, Shell shell) {
        if (instances.length == 0) {
            return;
        }
        new UpdateProgressWindow().showSupport(instances, shell);
    }

    protected void showSupport(UpdateCheckInstance[] instances, Shell shell) {
        this.manager = instances[0].getManager();
        this.display = shell.getDisplay();
        this.window = ShellFactory.createShell(this.display, 67696);
        Messages.setLanguageText((Widget)this.window, "updater.progress.window.title");
        Utils.setShellIcon(shell);
        FormLayout layout = new FormLayout();
        try {
            layout.spacing = 5;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.window.setLayout((Layout)layout);
        this.text_area = new StyledText((Composite)this.window, 2816);
        this.text_area.setEditable(false);
        Button btnOk = new Button((Composite)this.window, 8);
        Button btnAbort = new Button((Composite)this.window, 8);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(90, 0);
        Utils.setLayoutData((Control)this.text_area, formData);
        Label info_label = new Label((Composite)this.window, 0);
        Messages.setLanguageText((Widget)info_label, "updater.progress.window.info");
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.text_area);
        formData.right = new FormAttachment((Control)btnAbort);
        formData.left = new FormAttachment(0, 0);
        Utils.setLayoutData((Control)info_label, formData);
        Messages.setLanguageText((Widget)btnAbort, "Button.abort");
        formData = new FormData();
        formData.right = new FormAttachment((Control)btnOk);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        Utils.setLayoutData((Control)btnAbort, formData);
        btnAbort.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UpdateProgressWindow.this.manager.removeListener(UpdateProgressWindow.this);
                for (int i = 0; i < UpdateProgressWindow.this.current_instances.size(); ++i) {
                    ((UpdateCheckInstance)UpdateProgressWindow.this.current_instances.get(i)).cancel();
                }
                UpdateProgressWindow.this.window.dispose();
            }
        });
        Messages.setLanguageText((Widget)btnOk, "Button.ok");
        formData = new FormData();
        formData.right = new FormAttachment(95, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        Utils.setLayoutData((Control)btnOk, formData);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UpdateProgressWindow.this.manager.removeListener(UpdateProgressWindow.this);
                UpdateProgressWindow.this.window.dispose();
            }
        });
        this.window.setDefaultButton(btnOk);
        this.window.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    UpdateProgressWindow.this.manager.removeListener(UpdateProgressWindow.this);
                    UpdateProgressWindow.this.window.dispose();
                }
            }
        });
        this.manager.addListener(this);
        this.window.setSize(620, 450);
        this.window.layout();
        Utils.centreWindow(this.window);
        this.window.open();
        for (int i = 0; i < instances.length; ++i) {
            this.addInstance(instances[i]);
        }
    }

    protected void log(UpdateCheckInstance instance, String str) {
        String name = instance.getName();
        if (MessageText.keyExists(name)) {
            name = MessageText.getString(name);
        }
        this.log(name + " - " + str);
    }

    protected void log(UpdateChecker checker, String str) {
        this.log("    " + checker.getComponent().getName() + " - " + str);
    }

    protected void log(final String str) {
        try {
            if (!this.display.isDisposed()) {
                this.display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (!UpdateProgressWindow.this.text_area.isDisposed()) {
                            UpdateProgressWindow.this.text_area.append(str + "\n");
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void checkInstanceCreated(UpdateCheckInstance instance) {
        this.addInstance(instance);
    }

    protected void addInstance(final UpdateCheckInstance instance) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (UpdateProgressWindow.this.display.isDisposed() || UpdateProgressWindow.this.window.isDisposed()) {
                        return;
                    }
                    if (!UpdateProgressWindow.this.current_instances.contains(instance)) {
                        UpdateProgressWindow.this.current_instances.add(instance);
                        UpdateProgressWindow.this.log(instance, "added");
                        instance.addListener(new UpdateCheckInstanceListener(){

                            public void cancelled(UpdateCheckInstance instance) {
                                UpdateProgressWindow.this.log(instance, "cancelled");
                            }

                            public void complete(UpdateCheckInstance instance) {
                                UpdateProgressWindow.this.log(instance, "complete");
                            }
                        });
                        UpdateChecker[] checkers = instance.getCheckers();
                        for (int i = 0; i < checkers.length; ++i) {
                            final UpdateChecker checker = checkers[i];
                            UpdateProgressWindow.this.log(checker, "added");
                            checker.addListener(new UpdateCheckerListener(){

                                public void completed(UpdateChecker checker) {
                                    UpdateProgressWindow.this.log(checker, "completed");
                                }

                                public void failed(UpdateChecker checker) {
                                    UpdateProgressWindow.this.log(checker, "failed");
                                }

                                public void cancelled(UpdateChecker checker) {
                                    UpdateProgressWindow.this.log(checker, "cancelled");
                                }
                            });
                            checker.addProgressListener(new UpdateProgressListener(){

                                public void reportProgress(String str) {
                                    UpdateProgressWindow.this.log(checker, "    " + str);
                                }
                            });
                        }
                    }
                }
            });
        }
    }
}

