/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BubbleTextBox;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.FilesViewMenuUtil;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.file.FileInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.files.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileAvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileCRC32Item;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileETAItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileExtensionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileIndexItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileMD5Item;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileReadSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileSHA1Item;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileWriteSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FirstPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ModeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PieceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ProgressGraphItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.RelocatedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.RemainingPiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.StorageTypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.TorrentRelativePathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AlertsItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesView
extends TableViewTab<DiskManagerFileInfo>
implements TableDataSourceChangedListener,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
DownloadManagerStateAttributeListener,
DownloadManagerListener,
TableLifeCycleListener,
TableViewFilterCheck.TableViewFilterCheckEx<DiskManagerFileInfo>,
KeyListener,
ParameterListener,
UISWTViewCoreEventListenerEx {
    private static boolean registeredCoreSubViews = false;
    boolean refreshing = false;
    private DragSource dragSource = null;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PathItem(), new SizeItem(), new DoneItem(), new PercentItem(), new FirstPieceItem(), new PieceCountItem(), new RemainingPiecesItem(), new ProgressGraphItem(), new ModeItem(), new PriorityItem(), new StorageTypeItem(), new FileExtensionItem(), new FileIndexItem(), new TorrentRelativePathItem(), new FileCRC32Item(), new FileMD5Item(), new FileSHA1Item(), new FileAvailabilityItem(), new AlertsItem("Files"), new FileReadSpeedItem(), new FileWriteSpeedItem(), new FileETAItem(), new RelocatedItem()};
    public static final String MSGID_PREFIX = "FilesView";
    private List<DownloadManager> managers = new ArrayList<DownloadManager>();
    private boolean enable_tabs = true;
    public static boolean show_full_path;
    public boolean hide_dnd_files;
    private volatile long selection_size;
    private volatile long selection_done;
    private MenuItem path_item;
    private TableViewSWT<DiskManagerFileInfo> tv;
    private final boolean allowTabViews;
    private Composite cTop;
    private BubbleTextBox bubbleTextBox;
    private Button btnShowDND;
    private Label lblHeader;
    private boolean disableTableWhenEmpty = true;
    private boolean force_refresh = false;

    public FilesView() {
        super(MSGID_PREFIX);
        this.allowTabViews = true;
    }

    public FilesView(boolean allowTabViews) {
        super(MSGID_PREFIX);
        this.allowTabViews = allowTabViews;
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public UISWTViewCoreEventListener getClone() {
        return new FilesView(this.allowTabViews);
    }

    @Override
    public TableViewSWT<DiskManagerFileInfo> initYourTableView() {
        UISWTInstance pluginUI;
        UIFunctionsSWT uiFunctions;
        this.tv = TableViewFactory.createTableViewSWT(org.gudy.azureus2.plugins.disk.DiskManagerFileInfo.class, "Files", this.getPropertiesPrefix(), basicItems, "firstpiece", 0x10010002);
        if (this.allowTabViews) {
            this.tv.setEnableTabViews(this.enable_tabs, true, null);
        }
        if ((uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && !registeredCoreSubViews) {
            DownloadManager manager = this.managers.size() == 1 ? this.managers.get(0) : null;
            pluginUI.addView("Files", "FileInfoView", FileInfoView.class, manager);
            registeredCoreSubViews = true;
        }
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addRefreshListener(this, true);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addLifeCycleListener(this);
        this.tv.addKeyListener(this);
        return this.tv;
    }

    @Override
    public Composite initComposite(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Layout compositeLayout = composite.getLayout();
        if (compositeLayout instanceof GridLayout) {
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
        } else if (compositeLayout instanceof FormLayout) {
            parent.setLayoutData((Object)Utils.getFilledFormData());
        }
        this.cTop = new Composite(parent, 0);
        this.cTop.setLayoutData((Object)new GridData(4, 1, true, false));
        this.cTop.setLayout((Layout)new FormLayout());
        this.btnShowDND = new Button(this.cTop, 32);
        Messages.setLanguageText((Widget)this.btnShowDND, "FilesView.hide.dnd");
        this.btnShowDND.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("FilesView.hide.dnd", !FilesView.this.hide_dnd_files);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.hide_dnd_files = COConfigurationManager.getBooleanParameter("FilesView.hide.dnd");
        this.btnShowDND.setSelection(this.hide_dnd_files);
        this.lblHeader = new Label(this.cTop, 0x1000000);
        this.bubbleTextBox = new BubbleTextBox(this.cTop, 2948);
        this.bubbleTextBox.getTextWidget().setMessage(MessageText.getString("TorrentDetailsView.filter"));
        FormData fd = Utils.getFilledFormData();
        fd.left = null;
        this.bubbleTextBox.getParent().setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.bubbleTextBox.getParent(), 10, 0x1000000);
        fd.left = new FormAttachment(0, 0);
        this.btnShowDND.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.bubbleTextBox.getParent(), 10, 0x1000000);
        fd.left = new FormAttachment((Control)this.btnShowDND, 10);
        fd.right = new FormAttachment((Control)this.bubbleTextBox.getParent(), -10);
        this.lblHeader.setLayoutData((Object)fd);
        this.tv.enableFilterCheck(this.bubbleTextBox.getTextWidget(), this);
        Composite tableParent = new Composite(parent, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        tableParent.setLayout((Layout)gridLayout);
        parent.setTabList(new Control[]{tableParent, this.cTop});
        return tableParent;
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        List<DownloadManager> newManagers = ViewUtils.getDownloadManagersFromDataSource(newDataSource);
        if (newManagers.size() == this.managers.size()) {
            boolean diff = false;
            for (DownloadManager manager : this.managers) {
                if (newManagers.contains(manager)) continue;
                diff = true;
                break;
            }
            if (!diff) {
                if (this.disableTableWhenEmpty) {
                    this.tv.setEnabled(this.managers.size() > 0);
                }
                return;
            }
        }
        for (DownloadManager manager : this.managers) {
            manager.getDownloadState().removeListener(this, "filelinks2", 1);
            manager.removeListener(this);
        }
        this.managers = newManagers;
        for (DownloadManager manager : this.managers) {
            manager.getDownloadState().addListener(this, "filelinks2", 1);
            manager.addListener(this);
        }
        if (!this.tv.isDisposed()) {
            this.tv.removeAllTableRows();
            if (this.disableTableWhenEmpty) {
                this.tv.setEnabled(this.managers.size() > 0);
            }
            this.updateHeader();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    @Override
    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
        if (this.hide_dnd_files) {
            this.tv.refilter();
        }
    }

    @Override
    public boolean filterCheck(DiskManagerFileInfo ds, String filter2, boolean regex) {
        if (this.hide_dnd_files && ds.isSkipped()) {
            return false;
        }
        if (filter2 == null || filter2.length() == 0) {
            return true;
        }
        if (this.tv.getFilterControl() == null) {
            return true;
        }
        try {
            Pattern pattern;
            File file = ds.getFile(true);
            String name = filter2.contains(File.separator) ? file.getAbsolutePath() : file.getName();
            String s = regex ? filter2 : "\\Q" + filter2.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
            boolean match_result = true;
            if (regex && s.startsWith("!")) {
                s = s.substring(1);
                match_result = false;
            }
            return (pattern = RegExUtil.getCachedPattern("fv:search", s, 2)).matcher(name).find() == match_result;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public void viewChanged(TableView<DiskManagerFileInfo> view) {
        this.updateHeader();
    }

    public void updateSelectedContent() {
        long total_size = 0L;
        long total_done = 0L;
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        ArrayList<SelectedContent> listSelected = new ArrayList<SelectedContent>(dataSources.length);
        for (Object ds : dataSources) {
            if (!(ds instanceof DiskManagerFileInfo)) continue;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            listSelected.add(new SelectedContent(fileInfo2.getDownloadManager(), fileInfo2.getIndex()));
            if (fileInfo2.isSkipped()) continue;
            total_size += fileInfo2.getLength();
            total_done += fileInfo2.getDownloaded();
        }
        this.selection_size = total_size;
        this.selection_done = total_done;
        this.updateHeader();
        ISelectedContent[] sc = listSelected.toArray(new SelectedContent[0]);
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)this.tv.getFirstSelectedDataSource();
        if (fileInfo2 == null) {
            return;
        }
        String mode = COConfigurationManager.getStringParameter("list.dm.dblclick");
        if (mode.equals("2")) {
            boolean openMode = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            ManagerUtils.open(fileInfo2, openMode);
        } else {
            boolean webInBrowser = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowser");
            if (webInBrowser && ManagerUtils.browseWebsite(fileInfo2)) {
                return;
            }
            if (mode.equals("3") || mode.equals("4")) {
                if (fileInfo2.getAccessMode() == 1) {
                    if (mode.equals("4") && fileInfo2.getDownloaded() == fileInfo2.getLength() && Utils.isQuickViewSupported(fileInfo2)) {
                        Utils.setQuickViewActive(fileInfo2, true);
                    } else {
                        Utils.launch(fileInfo2);
                    }
                }
            } else if (mode.equals("5")) {
                ManagerUtils.browse(fileInfo2);
            } else {
                DownloadManager dm;
                AZ3Functions.provider az3 = AZ3Functions.getProvider();
                if (az3 != null && (az3.canPlay(dm = fileInfo2.getDownloadManager(), fileInfo2.getIndex()) || (stateMask & 0x40000) != 0)) {
                    az3.play(dm, fileInfo2.getIndex());
                    return;
                }
                if (fileInfo2.getAccessMode() == 1) {
                    Utils.launch(fileInfo2);
                }
            }
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        if (this.managers.size() != 0) {
            if (this.managers.size() == 1) {
                Object[] data_sources = this.tv.getSelectedDataSources().toArray();
                DiskManagerFileInfo[] files = new DiskManagerFileInfo[data_sources.length];
                for (int i = 0; i < data_sources.length; ++i) {
                    files[i] = (DiskManagerFileInfo)data_sources[i];
                }
                FilesViewMenuUtil.fillMenu(this.tv, menu, new DownloadManager[]{this.managers.get(0)}, new DiskManagerFileInfo[][]{files});
            } else {
                Object[] data_sources = this.tv.getSelectedDataSources().toArray();
                IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> map = new IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
                ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>();
                for (Object ds : data_sources) {
                    DiskManagerFileInfo file = (DiskManagerFileInfo)ds;
                    DownloadManager dm = file.getDownloadManager();
                    ArrayList<DiskManagerFileInfo> list = (ArrayList<DiskManagerFileInfo>)map.get(dm);
                    if (list == null) {
                        list = new ArrayList<DiskManagerFileInfo>(dm.getDiskManagerFileInfoSet().nbFiles());
                        map.put(dm, list);
                        dms.add(dm);
                    }
                    list.add(file);
                }
                DownloadManager[] manager_list = dms.toArray(new DownloadManager[dms.size()]);
                DiskManagerFileInfo[][] files_list = new DiskManagerFileInfo[manager_list.length][];
                for (int i = 0; i < manager_list.length; ++i) {
                    List list = (List)map.get(manager_list[i]);
                    files_list[i] = list.toArray(new DiskManagerFileInfo[list.size()]);
                }
                FilesViewMenuUtil.fillMenu(this.tv, menu, manager_list, files_list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableRefresh() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            if (this.tv.isDisposed()) {
                Object var8_1 = null;
                this.refreshing = false;
                return;
            }
            DiskManagerFileInfo[] files = this.getFileInfo();
            if (files != null && (this.force_refresh || !this.doAllExist(files))) {
                this.force_refresh = false;
                List datasources = this.tv.getDataSources();
                if (datasources.size() == files.length) {
                    ArrayList<DiskManagerFileInfo> toAdd = new ArrayList<DiskManagerFileInfo>(Arrays.asList(files));
                    ArrayList<DiskManagerFileInfo> toRemove = new ArrayList<DiskManagerFileInfo>();
                    for (int i = 0; i < datasources.size(); ++i) {
                        DiskManagerFileInfo info = (DiskManagerFileInfo)datasources.get(i);
                        if (files[info.getIndex()] == info) {
                            toAdd.set(info.getIndex(), null);
                            continue;
                        }
                        toRemove.add(info);
                    }
                    this.tv.removeDataSources((DiskManagerFileInfo[])toRemove.toArray(new DiskManagerFileInfo[toRemove.size()]));
                    this.tv.addDataSources((DiskManagerFileInfo[])toAdd.toArray(new DiskManagerFileInfo[toAdd.size()]));
                    this.tv.tableInvalidate();
                } else {
                    this.tv.removeAllTableRows();
                    DiskManagerFileInfo[] filesCopy = new DiskManagerFileInfo[files.length];
                    System.arraycopy(files, 0, filesCopy, 0, files.length);
                    this.tv.addDataSources((DiskManagerFileInfo[])filesCopy);
                }
                this.tv.processDataSourceQueue();
            }
        }
        catch (Throwable throwable) {
            Object var8_3 = null;
            this.refreshing = false;
            throw throwable;
        }
        Object var8_2 = null;
        this.refreshing = false;
    }

    private boolean doAllExist(DiskManagerFileInfo[] files) {
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo fileinfo = files[i];
            if (!this.tv.isFiltered(fileinfo)) continue;
            TableRowCore row = this.tv.getRow(fileinfo);
            if (row == null) {
                return false;
            }
            if (row.getDataSource(true) == fileinfo) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("path")) {
            this.path_item = new MenuItem(menuThisColumn, 32);
            this.path_item.setSelection(show_full_path);
            Messages.setLanguageText((Widget)this.path_item, "FilesView.fullpath");
            this.path_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    show_full_path = FilesView.this.path_item.getSelection();
                    FilesView.this.tv.columnInvalidate("path");
                    FilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("FilesView.show.full.path", show_full_path);
                }
            });
        } else if (sColumnName.equals("file_eta")) {
            final MenuItem item = new MenuItem(menuThisColumn, 32);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.eta.abs");
            item.setSelection(MyTorrentsView.eta_absolute);
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MyTorrentsView.eta_absolute = item.getSelection();
                    FilesView.this.tv.columnInvalidate("eta");
                    FilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("mtv.eta.show_absolute", MyTorrentsView.eta_absolute);
                }
            });
        } else if (sColumnName.equals("priority")) {
            final MenuItem item = new MenuItem(menuThisColumn, 32);
            Messages.setLanguageText((Widget)item, "FilesView.hide.dnd");
            item.setSelection(this.hide_dnd_files);
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    FilesView.this.hide_dnd_files = item.getSelection();
                    COConfigurationManager.setParameter("FilesView.hide.dnd", FilesView.this.hide_dnd_files);
                }
            });
        }
    }

    private DiskManagerFileInfo[] getFileInfo() {
        if (this.managers.size() == 0) {
            return null;
        }
        if (this.managers.size() == 1) {
            return this.managers.get(0).getDiskManagerFileInfoSet().getFiles();
        }
        ArrayList<DiskManagerFileInfo> temp = new ArrayList<DiskManagerFileInfo>();
        for (DownloadManager dm : this.managers) {
            temp.addAll(Arrays.asList(dm.getDiskManagerFileInfoSet().getFiles()));
        }
        return temp.toArray(new DiskManagerFileInfo[temp.size()]);
    }

    @Override
    public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
        Object oIsChangingLinks = dm.getUserData("is_changing_links");
        if (oIsChangingLinks instanceof Boolean && ((Boolean)oIsChangingLinks).booleanValue()) {
            return;
        }
        this.force_refresh = true;
    }

    @Override
    public void tableViewInitialized() {
        this.createDragDrop();
        this.hide_dnd_files = COConfigurationManager.getBooleanParameter("FilesView.hide.dnd");
        COConfigurationManager.addParameterListener("FilesView.hide.dnd", (ParameterListener)this);
    }

    @Override
    public void tableViewTabInitComplete() {
        this.updateSelectedContent();
        super.tableViewTabInitComplete();
    }

    @Override
    public void tableViewDestroyed() {
        COConfigurationManager.removeParameterListener("FilesView.hide.dnd", this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    Utils.disposeSWTObjects(new Object[]{FilesView.this.dragSource});
                    FilesView.this.dragSource = null;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
        for (DownloadManager manager : this.managers) {
            manager.getDownloadState().removeListener(this, "filelinks2", 1);
            manager.removeListener(this);
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            this.dragSource = this.tv.createDragSource(3);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData1;
                    private String[] eventData2;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = FilesView.this.tv.getSelectedRows();
                        if (rows.length == 0 || FilesView.this.managers.size() <= 0) {
                            event2.doit = false;
                            return;
                        }
                        event2.doit = true;
                        Object[] selectedDownloads = FilesView.this.tv.getSelectedDataSources().toArray();
                        this.eventData2 = new String[selectedDownloads.length];
                        this.eventData1 = "DiskManagerFileInfo\n";
                        for (int i = 0; i < selectedDownloads.length; ++i) {
                            DiskManagerFileInfo fi = (DiskManagerFileInfo)selectedDownloads[i];
                            try {
                                TOTorrent torrent = fi.getDownloadManager().getTorrent();
                                if (torrent != null) {
                                    this.eventData1 = this.eventData1 + torrent.getHashWrapper().toBase32String() + ";" + fi.getIndex() + "\n";
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                this.eventData2[i] = fi.getFile(true).getAbsolutePath();
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = FileTransfer.getInstance().isSupportedType(event2.dataType) ? this.eventData2 : this.eventData1;
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LogIDs.GUI, "failed to init drag-n-drop", t));
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        if (event2.getType() == 0 && event2 instanceof UISWTViewEventImpl) {
            String parent = ((UISWTViewEventImpl)event2).getParentID();
            this.enable_tabs = parent != null && parent.equals("TorrentDetailsView");
        }
        boolean b = super.eventOccurred(event2);
        if (event2.getType() == 3) {
            this.updateSelectedContent();
        } else if (event2.getType() == 4) {
            SelectedContentManager.clearCurrentlySelectedContent();
        }
        return b;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
            FilesViewMenuUtil.rename(this.tv, this.tv.getSelectedDataSources(true), true, false);
            e.doit = false;
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void parameterChanged(String parameterName) {
        if ("FilesView.hide.dnd".equals(parameterName)) {
            this.hide_dnd_files = COConfigurationManager.getBooleanParameter(parameterName);
            if (this.btnShowDND != null && !this.btnShowDND.isDisposed()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (FilesView.this.btnShowDND != null && !FilesView.this.btnShowDND.isDisposed()) {
                            FilesView.this.btnShowDND.setSelection(FilesView.this.hide_dnd_files);
                        }
                    }
                });
            }
            if (this.tv == null || this.tv.isDisposed()) {
                return;
            }
            this.tv.refilter();
        }
    }

    private void updateHeader() {
        if (this.managers.size() == 0) {
            if (this.lblHeader != null) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (FilesView.this.lblHeader == null || FilesView.this.lblHeader.isDisposed()) {
                            return;
                        }
                        FilesView.this.lblHeader.setText("");
                    }
                });
            }
            return;
        }
        int total = 0;
        for (DownloadManager manager : this.managers) {
            total += manager.getNumFileInfos();
        }
        int numInList = this.tv.getRowCount();
        String s = MessageText.getString("library.unopened.header" + (total > 1 ? ".p" : ""), new String[]{String.valueOf(total)});
        if (total != numInList) {
            s = MessageText.getString("v3.MainWindow.xofx", new String[]{String.valueOf(numInList), s});
        }
        final String sHeader = s = s + this.getSelectionText();
        if (this.lblHeader != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (FilesView.this.lblHeader == null || FilesView.this.lblHeader.isDisposed()) {
                        return;
                    }
                    FilesView.this.lblHeader.setText(sHeader);
                }
            });
        }
    }

    private String getSelectionText() {
        int selection_count = this.tv.getSelectedRowsSize();
        if (selection_count == 0) {
            return "";
        }
        String str = ", " + MessageText.getString("label.num_selected", new String[]{String.valueOf(selection_count)});
        if (this.selection_size > 0L) {
            str = this.selection_size == this.selection_done ? str + " (" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size) + ")" : str + " (" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_done) + "/" + DisplayFormatters.formatByteCountToKiBEtc(this.selection_size) + ")";
        }
        return str;
    }

    public void setDisableWhenEmpty(boolean b) {
        this.disableTableWhenEmpty = b;
    }

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Files", basicItems);
        COConfigurationManager.addAndFireParameterListener("FilesView.show.full.path", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path");
            }
        });
    }
}

