/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.PersistentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.TypeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySharesView
extends TableViewTab<ShareResource>
implements ShareManagerListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableSelectionListener,
ViewTitleInfo2,
UIPluginViewToolBarListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TypeItem(), new CategoryItem(), new PersistentItem()};
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private Menu menuCategory;
    private TableViewSWT<ShareResource> tv = TableViewFactory.createTableViewSWT(ShareResource.class, "MyShares", this.getPropertiesPrefix(), basicItems, "name", 268503042);
    private DropTarget dropTarget;

    public MySharesView() {
        super("MySharesView");
        this.tv.addSelectionListener(new TableSelectionAdapter(){

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                MySharesView.this.defaultSelected(rows);
            }
        }, false);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
        this.tv.addSelectionListener(this, false);
    }

    @Override
    public TableViewSWT initYourTableView() {
        return this.tv;
    }

    private void defaultSelected(TableRowCore[] rows) {
        ShareResource share = (ShareResource)this.tv.getFirstSelectedDataSource();
        if (share == null) {
            return;
        }
        List<org.gudy.azureus2.core3.download.DownloadManager> dms = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
        for (int i = 0; i < dms.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager dm = dms.get(i);
            try {
                byte[] share_hash = null;
                if (share.getType() == 2) {
                    share_hash = ((ShareResourceDir)share).getItem().getTorrent().getHash();
                } else if (share.getType() == 1) {
                    share_hash = ((ShareResourceFile)share).getItem().getTorrent().getHash();
                }
                if (!Arrays.equals(share_hash, dm.getTorrent().getHash())) continue;
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions == null) break;
                uiFunctions.getMDI().showEntryByID("DMDetails", dm);
                break;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void tableViewInitialized() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                MySharesView.this.createRows(core);
            }
        });
        if (this.dropTarget == null) {
            this.dropTarget = this.tv.createDropTarget(31);
            if (this.dropTarget != null) {
                this.dropTarget.setTransfer(new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void drop(DropTargetEvent event2) {
                        if (!MySharesView.this.share(event2.data)) {
                            TorrentOpener.openDroppedTorrents(event2, true);
                        }
                    }
                });
            }
        }
    }

    protected boolean share(Object eventData) {
        boolean shared = false;
        if (eventData instanceof String[] || eventData instanceof String) {
            String[] stringArray;
            if (eventData instanceof String[]) {
                stringArray = (String[])eventData;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)eventData;
            }
            String[] sourceNames = stringArray;
            if (sourceNames == null) {
                return false;
            }
            for (int i = 0; i < sourceNames.length; ++i) {
                File source = new File(sourceNames[i]);
                String filename = source.getAbsolutePath();
                try {
                    if (source.isFile() && !TorrentUtils.isTorrentFile(filename)) {
                        ShareUtils.shareFile(filename);
                        shared = true;
                        continue;
                    }
                    if (!source.isDirectory()) continue;
                    ShareUtils.shareDir(filename);
                    shared = true;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return shared;
    }

    @Override
    public void tableViewDestroyed() {
        try {
            PluginInitializer.getDefaultInterface().getShareManager().removeListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createRows(AzureusCore core) {
        try {
            ShareManager sm = core.getPluginManager().getDefaultPluginInterface().getShareManager();
            ShareResource[] shares = sm.getShares();
            for (int i = 0; i < shares.length; ++i) {
                this.resourceAdded(shares[i]);
            }
            sm.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        Shell shell = menu.getShell();
        this.menuCategory = new Menu((Decorations)shell, 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        itemRemove.setEnabled(shares.length > 0);
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MySharesView.this.removeSelectedShares();
            }
        });
        new MenuItem(menu, 2);
    }

    @Override
    public void resourceAdded(ShareResource resource) {
        this.tv.addDataSource(resource);
    }

    @Override
    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
        this.tv.removeDataSource(old_resource);
        this.tv.addDataSource(new_resource);
    }

    @Override
    public void resourceDeleted(ShareResource resource) {
        this.tv.removeDataSource(resource);
    }

    @Override
    public void reportProgress(int percent_complete) {
    }

    @Override
    public void reportCurrentTask(String task_description) {
    }

    @Override
    public void tableRefresh() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    private void addCategorySubMenu() {
        int i;
        MenuItem[] items = this.menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(this.menuCategory, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MySharesView.this.addCategory();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(Display.getDefault());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(final Category category) {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                String value = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                ((ShareResource)row.getDataSource(true)).setAttribute(category_attribute, value);
            }
        });
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        boolean start = false;
        boolean stop = false;
        boolean remove = false;
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        List items = this.getSelectedItems();
        if (items.size() > 0) {
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            DownloadManager dm = pi.getDownloadManager();
            remove = true;
            for (int i = 0; i < items.size(); ++i) {
                ShareItem item = (ShareItem)items.get(i);
                try {
                    int dl_state;
                    Torrent t = item.getTorrent();
                    Download download = dm.getDownload(t);
                    if (download == null || (dl_state = download.getState()) == 8) continue;
                    if (dl_state != 7) {
                        stop = true;
                        continue;
                    }
                    start = true;
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        list.put("start", start ? 1L : 0L);
        list.put("stop", stop ? 1L : 0L);
        list.put("remove", remove ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        String itemKey = item.getID();
        if (itemKey.equals("remove")) {
            this.removeSelectedShares();
            return true;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedShares();
            return true;
        }
        if (itemKey.equals("start")) {
            this.startSelectedShares();
            return true;
        }
        return false;
    }

    private List getSelectedItems() {
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        ArrayList<ShareItem> items = new ArrayList<ShareItem>();
        if (shares.length > 0) {
            for (int i = 0; i < shares.length; ++i) {
                ShareResource sr;
                ShareResource share = (ShareResource)shares[i];
                int type = share.getType();
                if (type == 2) {
                    sr = (ShareResourceDir)share;
                    items.add(sr.getItem());
                    continue;
                }
                if (type == 1) {
                    sr = (ShareResourceFile)share;
                    items.add(sr.getItem());
                    continue;
                }
                ShareResourceDirContents cont = (ShareResourceDirContents)share;
                ArrayList entries = new ArrayList();
                this.getEntries(entries, cont);
                for (int j = 0; j < entries.size(); ++j) {
                    ShareResource sr2;
                    share = (ShareResource)entries.get(j);
                    type = share.getType();
                    if (type == 2) {
                        sr2 = (ShareResourceDir)share;
                        items.add(sr2.getItem());
                        continue;
                    }
                    if (type != 1) continue;
                    sr2 = (ShareResourceFile)share;
                    items.add(sr2.getItem());
                }
            }
        }
        return items;
    }

    private void getEntries(List entries, ShareResourceDirContents cont) {
        ShareResource[] kids = cont.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            ShareResource share = kids[i];
            int type = share.getType();
            if (type == 3) {
                this.getEntries(entries, (ShareResourceDirContents)share);
                continue;
            }
            entries.add(share);
        }
    }

    private void startStopSelectedShares(boolean do_stop) {
        List items = this.getSelectedItems();
        if (items.size() == 0) {
            return;
        }
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        DownloadManager dm = pi.getDownloadManager();
        Tracker tracker = pi.getTracker();
        for (int i = 0; i < items.size(); ++i) {
            ShareItem item = (ShareItem)items.get(i);
            try {
                int dl_state;
                Torrent t = item.getTorrent();
                TrackerTorrent tracker_torrent = tracker.getTorrent(t);
                Download download = dm.getDownload(t);
                if (tracker_torrent == null || download == null || (dl_state = download.getState()) == 8) continue;
                if (dl_state != 7) {
                    if (!do_stop) continue;
                    try {
                        download.stop();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        tracker_torrent.stop();
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (do_stop) continue;
                try {
                    download.restart();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    tracker_torrent.start();
                }
                catch (Throwable e) {}
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void startSelectedShares() {
        this.startStopSelectedShares(false);
    }

    private void stopSelectedShares() {
        this.startStopSelectedShares(true);
    }

    private void removeSelectedShares() {
        this.stopSelectedShares();
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        for (int i = 0; i < shares.length; ++i) {
            try {
                ((ShareResource)shares[i]).delete();
                continue;
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(shares[i], false, "{globalmanager.download.remove.veto}", e));
            }
        }
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        return null;
    }

    @Override
    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
        mdiEntry.addListener(new MdiEntryDropListener(){

            public boolean mdiEntryDrop(MdiEntry entry, Object droppedObject) {
                return MySharesView.this.share(droppedObject);
            }
        });
    }
}

