/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.tag.Tag;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;

public class MyTorrentsSubView
extends MyTorrentsView {
    private Button btnAnyTags;
    private boolean anyTorrentTags;

    public MyTorrentsSubView() {
        super("MyTorrentsSubView", false);
        this.neverShowCatOrTagButtons = true;
        this.isEmptyListOnNullDS = true;
        AzureusCore _azureus_core = AzureusCoreFactory.getSingleton();
        this.init(_azureus_core, "MyTorrentsSubView", Download.class, TableColumnCreator.createCompleteDM("MyTorrentsSubView"));
    }

    public Composite initComposite(Composite composite) {
        Composite parent = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        Layout compositeLayout = composite.getLayout();
        if (compositeLayout instanceof GridLayout) {
            parent.setLayoutData((Object)new GridData(4, 4, true, true));
        } else if (compositeLayout instanceof FormLayout) {
            parent.setLayoutData((Object)Utils.getFilledFormData());
        }
        Composite cTop = new Composite(parent, 0);
        GridData gd = new GridData(4, 1, true, false);
        cTop.setLayoutData((Object)gd);
        cTop.setLayout((Layout)new FormLayout());
        this.btnAnyTags = new Button(cTop, 32);
        Messages.setLanguageText((Widget)this.btnAnyTags, "TorrentTags.Button.Any");
        this.btnAnyTags.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("TorrentTags.Any", !MyTorrentsSubView.this.anyTorrentTags);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.anyTorrentTags = COConfigurationManager.getBooleanParameter("TorrentTags.Any");
        this.btnAnyTags.setSelection(this.anyTorrentTags);
        this.setCurrentTagsAny(this.anyTorrentTags);
        this.updateButtonVisibility(this.getCurrentTags());
        Composite tableParent = new Composite(parent, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        tableParent.setLayout((Layout)gridLayout);
        parent.setTabList(new Control[]{tableParent, cTop});
        return tableParent;
    }

    public void tableViewInitialized() {
        this.anyTorrentTags = COConfigurationManager.getBooleanParameter("TorrentTags.Any");
        COConfigurationManager.addParameterListener("TorrentTags.Any", (ParameterListener)this);
        super.tableViewInitialized();
    }

    public void tableViewDestroyed() {
        COConfigurationManager.removeParameterListener("TorrentTags.Any", this);
        super.tableViewDestroyed();
    }

    public void parameterChanged(String parameterName) {
        if ("TorrentTags.Any".equals(parameterName)) {
            this.anyTorrentTags = COConfigurationManager.getBooleanParameter(parameterName);
            if (this.btnAnyTags != null && !this.btnAnyTags.isDisposed()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (MyTorrentsSubView.this.btnAnyTags != null && !MyTorrentsSubView.this.btnAnyTags.isDisposed()) {
                            MyTorrentsSubView.this.btnAnyTags.setSelection(MyTorrentsSubView.this.anyTorrentTags);
                        }
                    }
                });
            }
            this.setCurrentTagsAny(this.anyTorrentTags);
        }
        super.parameterChanged(parameterName);
    }

    protected void setCurrentTags(Tag[] tags) {
        super.setCurrentTags(tags);
        this.updateButtonVisibility(tags);
    }

    private void updateButtonVisibility(final Tag[] tags) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MyTorrentsSubView.this.btnAnyTags == null || MyTorrentsSubView.this.btnAnyTags.isDisposed()) {
                    return;
                }
                boolean show = tags != null && tags.length > 1;
                MyTorrentsSubView.this.btnAnyTags.setVisible(show);
                FormData fd = Utils.getFilledFormData();
                fd.height = show ? -1 : 0;
                MyTorrentsSubView.this.btnAnyTags.setLayoutData((Object)fd);
                Composite cTop = MyTorrentsSubView.this.btnAnyTags.getParent();
                cTop.getParent().layout(true, true);
            }
        });
    }
}

